/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.util.Locations;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class WorldGuardVehicleListener
implements Listener {
    private WorldGuardPlugin plugin;

    public WorldGuardVehicleListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle.getPassengers().isEmpty()) {
            return;
        }
        List playerPassengers = vehicle.getPassengers().stream().filter(ent -> ent instanceof Player).map(ent -> (Player)ent).collect(Collectors.toList());
        if (playerPassengers.isEmpty()) {
            return;
        }
        World world = vehicle.getWorld();
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)world));
        if (wcfg.useRegions && Locations.isDifferentBlock(BukkitAdapter.adapt((Location)event.getFrom()), BukkitAdapter.adapt((Location)event.getTo()))) {
            for (Player player : playerPassengers) {
                LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
                com.sk89q.worldedit.util.Location lastValid = WorldGuard.getInstance().getPlatform().getSessionManager().get(localPlayer).testMoveTo(localPlayer, BukkitAdapter.adapt((Location)event.getTo()), MoveType.RIDE);
                if (lastValid == null) continue;
                vehicle.setVelocity(new Vector(0, 0, 0));
                vehicle.teleport(event.getFrom());
                if (Locations.isDifferentBlock(lastValid, BukkitAdapter.adapt((Location)event.getFrom()))) {
                    Vector dir = player.getLocation().getDirection();
                    player.teleport(BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)lastValid).setDirection(dir));
                }
                return;
            }
        }
    }
}

