/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class BlockType
implements Keyed {
    public static final NamespacedRegistry<BlockType> REGISTRY = new NamespacedRegistry("block type");
    private final String id;
    private final Function<BlockState, BlockState> values;
    private final AtomicReference<BlockState> defaultState = new AtomicReference();
    private final AtomicReference<FuzzyBlockState> emptyFuzzy = new AtomicReference();
    private final AtomicReference<Map<String, ? extends Property<?>>> properties = new AtomicReference();
    private final AtomicReference<BlockMaterial> blockMaterial = new AtomicReference();
    private final AtomicReference<Map<Map<Property<?>, Object>, BlockState>> blockStatesMap = new AtomicReference();

    public BlockType(String id) {
        this(id, null);
    }

    public BlockType(String id, Function<BlockState, BlockState> values) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        this.id = id;
        this.values = values;
    }

    private <T> T updateField(AtomicReference<T> field, Supplier<T> value) {
        T result = field.get();
        if (result == null) {
            T update = value.get();
            result = field.compareAndSet(null, update) ? update : field.get();
        }
        return result;
    }

    private Map<Map<Property<?>, Object>, BlockState> getBlockStatesMap() {
        return this.updateField(this.blockStatesMap, () -> BlockState.generateStateMap(this));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        String name = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry().getName(this);
        if (name == null) {
            return this.getId();
        }
        return name;
    }

    public Map<String, ? extends Property<?>> getPropertyMap() {
        return this.updateField(this.properties, () -> ImmutableMap.copyOf(WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry().getProperties(this)));
    }

    public List<? extends Property<?>> getProperties() {
        return ImmutableList.copyOf(this.getPropertyMap().values());
    }

    public <V> Property<V> getProperty(String name) {
        Property<?> property = this.getPropertyMap().get(name);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"%s has no property named %s", (Object)this, (Object)name);
        return property;
    }

    public BlockState getDefaultState() {
        return this.updateField(this.defaultState, () -> {
            BlockState defaultState = new ArrayList<BlockState>(this.getBlockStatesMap().values()).get(0);
            if (this.values != null) {
                defaultState = this.values.apply(defaultState);
            }
            return defaultState;
        });
    }

    public FuzzyBlockState getFuzzyMatcher() {
        return this.updateField(this.emptyFuzzy, () -> new FuzzyBlockState(this));
    }

    public List<BlockState> getAllStates() {
        return ImmutableList.copyOf(this.getBlockStatesMap().values());
    }

    public BlockState getState(Map<Property<?>, Object> key) {
        BlockState state = this.getBlockStatesMap().get(key);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"%s has no state for %s", (Object)this, key);
        return state;
    }

    public boolean hasItemType() {
        return this.getItemType() != null;
    }

    @Nullable
    public ItemType getItemType() {
        return ItemTypes.get(this.id);
    }

    public BlockMaterial getMaterial() {
        return this.updateField(this.blockMaterial, () -> WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBlockRegistry().getMaterial(this));
    }

    @Deprecated
    public int getLegacyId() {
        int[] id = LegacyMapper.getInstance().getLegacyFromBlock(this.getDefaultState());
        if (id != null) {
            return id[0];
        }
        return 0;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BlockType && this.id.equals(((BlockType)obj).id);
    }
}

