/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sk89q.worldedit.extension.platform.PlatformCommandManager;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.enginehub.piston.Command;
import org.enginehub.piston.exception.CommandException;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.part.SubCommandPart;

public class CommandUtil {
    private static final Comparator<Command> BY_CLEAN_NAME = Comparator.comparing(c -> CommandUtil.clean(c.getName()));

    public static Map<String, Command> getSubCommands(Command currentCommand) {
        return currentCommand.getParts().stream().filter(p -> p instanceof SubCommandPart).flatMap(p -> ((SubCommandPart)p).getCommands().stream()).collect(Collectors.toMap(Command::getName, Function.identity()));
    }

    private static String clean(String input) {
        return PlatformCommandManager.COMMAND_CLEAN_PATTERN.matcher(input).replaceAll("");
    }

    public static Comparator<Command> byCleanName() {
        return BY_CLEAN_NAME;
    }

    public static List<String> fixSuggestions(String arguments, List<Substring> suggestions) {
        Substring lastArg = (Substring)Iterables.getLast(CommandArgParser.spaceSplit(arguments));
        return suggestions.stream().map(suggestion -> CommandUtil.onlyOnLastQuotedWord(lastArg, suggestion)).map(suggestion -> CommandUtil.suggestLast(lastArg, suggestion)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Substring onlyOnLastQuotedWord(Substring lastArg, Substring suggestion) {
        if (suggestion.getSubstring().startsWith(lastArg.getSubstring())) {
            return suggestion;
        }
        String substr = suggestion.getSubstring();
        int sp = substr.lastIndexOf(32);
        if (sp < 0) {
            return suggestion;
        }
        return Substring.wrap(substr.substring(sp + 1), suggestion.getStart() + sp + 1, suggestion.getEnd());
    }

    private static Optional<String> suggestLast(Substring last, Substring suggestion) {
        if (suggestion.getStart() == last.getEnd() && !last.getSubstring().equals("\"")) {
            if (last.getSubstring().isEmpty()) {
                return Optional.of(suggestion.getSubstring());
            }
            return Optional.of(last.getSubstring() + " " + suggestion.getSubstring());
        }
        StringBuilder builder = new StringBuilder(last.getSubstring());
        int start = suggestion.getStart() - last.getStart();
        int end = suggestion.getEnd() - last.getStart();
        if (start < 0) {
            return Optional.empty();
        }
        Preconditions.checkState((end <= builder.length() ? 1 : 0) != 0, (String)"Suggestion ends too late, last=%s, suggestion=", (Object)last, (Object)suggestion);
        builder.replace(start, end, suggestion.getSubstring());
        return Optional.of(builder.toString());
    }

    public static void checkCommandArgument(boolean condition, String message) {
        CommandUtil.checkCommandArgument(condition, TextComponent.of(message));
    }

    public static void checkCommandArgument(boolean condition, Component message) {
        if (!condition) {
            throw new CommandException(message, (ImmutableList<Command>)ImmutableList.of());
        }
    }

    public static <T> T requireIV(Key<T> type, String name, InjectedValueAccess injectedValueAccess) {
        return injectedValueAccess.injectedValue(type).orElseThrow(() -> new IllegalStateException("No injected value for " + name + " (type " + type + ")"));
    }

    private CommandUtil() {
    }
}

