/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Direction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public abstract class BreadthFirstSearch
implements Operation {
    private final RegionFunction function;
    private final Queue<BlockVector3> queue = new ArrayDeque<BlockVector3>();
    private final Set<BlockVector3> visited = new HashSet<BlockVector3>();
    private final List<BlockVector3> directions = new ArrayList<BlockVector3>();
    private int affected = 0;

    protected BreadthFirstSearch(RegionFunction function) {
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.addAxes();
    }

    protected Collection<BlockVector3> getDirections() {
        return this.directions;
    }

    protected void addAxes() {
        this.directions.add(BlockVector3.UNIT_MINUS_Y);
        this.directions.add(BlockVector3.UNIT_Y);
        this.directions.add(BlockVector3.UNIT_MINUS_X);
        this.directions.add(BlockVector3.UNIT_X);
        this.directions.add(BlockVector3.UNIT_MINUS_Z);
        this.directions.add(BlockVector3.UNIT_Z);
    }

    protected void addDiagonal() {
        this.directions.add(Direction.NORTHEAST.toBlockVector());
        this.directions.add(Direction.SOUTHEAST.toBlockVector());
        this.directions.add(Direction.SOUTHWEST.toBlockVector());
        this.directions.add(Direction.NORTHWEST.toBlockVector());
    }

    public void visit(BlockVector3 position) {
        BlockVector3 blockVector = position;
        if (!this.visited.contains(blockVector)) {
            this.queue.add(blockVector);
            this.visited.add(blockVector);
        }
    }

    private void visit(BlockVector3 from, BlockVector3 to) {
        BlockVector3 blockVector = to;
        if (!this.visited.contains(blockVector)) {
            this.visited.add(blockVector);
            if (this.isVisitable(from, to)) {
                this.queue.add(blockVector);
            }
        }
    }

    protected abstract boolean isVisitable(BlockVector3 var1, BlockVector3 var2);

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        BlockVector3 position;
        while ((position = this.queue.poll()) != null) {
            if (this.function.apply(position)) {
                ++this.affected;
            }
            for (BlockVector3 dir : this.directions) {
                this.visit(position, position.add(dir));
            }
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
        messages.add(this.getAffected() + " blocks affected");
    }
}

