/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.command.util.EntityRemover;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.PrintCommandHelp;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.EntityFunction;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.EntityVisitor;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.formatting.component.SubtleFormat;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.enginehub.piston.annotation.Command;

public class UtilityCommands {
    private final WorldEdit we;
    private static final DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());

    public UtilityCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="/fill", desc="Fill a hole")
    @CommandPermissions(value={"worldedit.fill"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fill(Player player, LocalSession session, EditSession editSession, Pattern pattern, double radius, int depth) throws WorldEditException {
        radius = Math.max(1.0, radius);
        this.we.checkMaxRadius(radius);
        depth = Math.max(1, depth);
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = editSession.fillXZ(pos, pattern, radius, depth, false);
        player.print(affected + " block(s) have been created.");
        return affected;
    }

    @Command(name="/fillr", desc="Fill a hole recursively")
    @CommandPermissions(value={"worldedit.fill.recursive"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fillr(Player player, LocalSession session, EditSession editSession, Pattern pattern, double radius, Integer depth) throws WorldEditException {
        radius = Math.max(1.0, radius);
        this.we.checkMaxRadius(radius);
        depth = depth == null ? Integer.MAX_VALUE : Math.max(1, depth);
        this.we.checkMaxRadius(radius);
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = editSession.fillXZ(pos, pattern, radius, (int)depth, true);
        player.print(affected + " block(s) have been created.");
        return affected;
    }

    @Command(name="/drain", desc="Drain a pool")
    @CommandPermissions(value={"worldedit.drain"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int drain(Player player, LocalSession session, EditSession editSession, double radius, boolean waterlogged) throws WorldEditException {
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.drainArea(session.getPlacementPosition(player), radius, waterlogged);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="fixlava", aliases={"/fixlava"}, desc="Fix lava to be stationary")
    @CommandPermissions(value={"worldedit.fixlava"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fixLava(Player player, LocalSession session, EditSession editSession, double radius) throws WorldEditException {
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, BlockTypes.LAVA);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="fixwater", aliases={"/fixwater"}, desc="Fix water to be stationary")
    @CommandPermissions(value={"worldedit.fixwater"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int fixWater(Player player, LocalSession session, EditSession editSession, double radius) throws WorldEditException {
        radius = Math.max(0.0, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, BlockTypes.WATER);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="removeabove", aliases={"/removeabove"}, desc="Remove blocks above your head.")
    @CommandPermissions(value={"worldedit.removeabove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeAbove(Player player, LocalSession session, EditSession editSession, int size, Integer height) throws WorldEditException {
        size = Math.max(1, size);
        this.we.checkMaxRadius(size);
        World world = player.getWorld();
        height = height != null ? Math.min(world.getMaxY() + 1, height + 1) : world.getMaxY() + 1;
        int affected = editSession.removeAbove(session.getPlacementPosition(player), size, height);
        player.print(affected + " block(s) have been removed.");
        return affected;
    }

    @Command(name="removebelow", aliases={"/removebelow"}, desc="Remove blocks below you.")
    @CommandPermissions(value={"worldedit.removebelow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeBelow(Player player, LocalSession session, EditSession editSession, int size, Integer height) throws WorldEditException {
        size = Math.max(1, size);
        this.we.checkMaxRadius(size);
        World world = player.getWorld();
        height = height != null ? Math.min(world.getMaxY() + 1, height + 1) : world.getMaxY() + 1;
        int affected = editSession.removeBelow(session.getPlacementPosition(player), size, height);
        player.print(affected + " block(s) have been removed.");
        return affected;
    }

    @Command(name="removenear", aliases={"/removenear"}, desc="Remove blocks near you.")
    @CommandPermissions(value={"worldedit.removenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int removeNear(Player player, LocalSession session, EditSession editSession, Mask mask, int radius) throws WorldEditException {
        radius = Math.max(1, radius);
        this.we.checkMaxRadius(radius);
        int affected = editSession.removeNear(session.getPlacementPosition(player), mask, radius);
        player.print(affected + " block(s) have been removed.");
        return affected;
    }

    @Command(name="replacenear", aliases={"/replacenear"}, desc="Replace nearby blocks")
    @CommandPermissions(value={"worldedit.replacenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int replaceNear(Player player, LocalSession session, EditSession editSession, int radius, Mask from, Pattern to) throws WorldEditException {
        radius = Math.max(1, radius);
        this.we.checkMaxRadius(radius);
        BlockVector3 base = session.getPlacementPosition(player);
        BlockVector3 min = base.subtract(radius, radius, radius);
        BlockVector3 max = base.add(radius, radius, radius);
        CuboidRegion region = new CuboidRegion(player.getWorld(), min, max);
        if (from == null) {
            from = new ExistingBlockMask(editSession);
        }
        int affected = editSession.replaceBlocks((Region)region, from, to);
        player.print(affected + " block(s) have been replaced.");
        return affected;
    }

    @Command(name="snow", aliases={"/snow"}, desc="Simulates snow")
    @CommandPermissions(value={"worldedit.snow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int snow(Player player, LocalSession session, EditSession editSession, double size) throws WorldEditException {
        size = Math.max(1.0, size);
        this.we.checkMaxRadius(size);
        int affected = editSession.simulateSnow(session.getPlacementPosition(player), size);
        player.print(affected + " surface(s) covered. Let it snow~");
        return affected;
    }

    @Command(name="thaw", aliases={"/thaw"}, desc="Thaws the area")
    @CommandPermissions(value={"worldedit.thaw"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int thaw(Player player, LocalSession session, EditSession editSession, double size) throws WorldEditException {
        size = Math.max(1.0, size);
        this.we.checkMaxRadius(size);
        int affected = editSession.thaw(session.getPlacementPosition(player), size);
        player.print(affected + " surface(s) thawed.");
        return affected;
    }

    @Command(name="green", aliases={"/green"}, desc="Converts dirt to grass blocks in the area")
    @CommandPermissions(value={"worldedit.green"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int green(Player player, LocalSession session, EditSession editSession, double size, boolean convertCoarse) throws WorldEditException {
        size = Math.max(1.0, size);
        this.we.checkMaxRadius(size);
        boolean onlyNormalDirt = !convertCoarse;
        int affected = editSession.green(session.getPlacementPosition(player), size, onlyNormalDirt);
        player.print(affected + " surface(s) greened.");
        return affected;
    }

    @Command(name="extinguish", aliases={"/ex", "/ext", "/extinguish", "ex", "ext"}, desc="Extinguish nearby fire")
    @CommandPermissions(value={"worldedit.extinguish"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void extinguish(Player player, LocalSession session, EditSession editSession, Integer radius) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int defaultRadius = config.maxRadius != -1 ? Math.min(40, config.maxRadius) : 40;
        int size = radius != null ? Math.max(1, radius) : defaultRadius;
        this.we.checkMaxRadius(size);
        BlockTypeMask mask = new BlockTypeMask((Extent)editSession, BlockTypes.FIRE);
        int affected = editSession.removeNear(session.getPlacementPosition(player), mask, size);
        player.print(affected + " block(s) have been removed.");
    }

    @Command(name="butcher", desc="Kill all or nearby mobs")
    @CommandPermissions(value={"worldedit.butcher"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int butcher(Actor actor, Integer radius, boolean killPets, boolean killNpcs, boolean killGolems, boolean killAnimals, boolean killAmbient, boolean killWithName, boolean killFriendly, boolean killArmorStands) throws WorldEditException {
        Player player;
        LocalConfiguration config = this.we.getConfiguration();
        Player player2 = player = actor instanceof Player ? (Player)actor : null;
        if (radius == null) {
            radius = config.butcherDefaultRadius;
        } else {
            if (radius < -1) {
                actor.printError("Use -1 to remove all mobs in loaded chunks");
                return 0;
            }
            if (radius == -1 && config.butcherMaxRadius != -1) {
                radius = config.butcherMaxRadius;
            }
        }
        if (config.butcherMaxRadius != -1) {
            radius = Math.min(radius, config.butcherMaxRadius);
        }
        CreatureButcher flags = new CreatureButcher(actor);
        flags.or(63, killFriendly);
        flags.or(1, killPets, "worldedit.butcher.pets");
        flags.or(2, killNpcs, "worldedit.butcher.npcs");
        flags.or(8, killGolems, "worldedit.butcher.golems");
        flags.or(4, killAnimals, "worldedit.butcher.animals");
        flags.or(16, killAmbient, "worldedit.butcher.ambient");
        flags.or(32, killWithName, "worldedit.butcher.tagged");
        flags.or(64, killArmorStands, "worldedit.butcher.armorstands");
        int killed = this.killMatchingEntities(radius, player, flags::createFunction);
        actor.print("Killed " + killed + (killed != 1 ? " mobs" : " mob") + (radius < 0 ? "" : " in a radius of " + radius) + ".");
        return killed;
    }

    @Command(name="remove", aliases={"rem", "rement"}, desc="Remove all entities of a type")
    @CommandPermissions(value={"worldedit.remove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int remove(Actor actor, EntityRemover remover, int radius) throws WorldEditException {
        Player player;
        Player player2 = player = actor instanceof Player ? (Player)actor : null;
        if (radius < -1) {
            actor.printError("Use -1 to remove all entities in loaded chunks");
            return 0;
        }
        int removed = this.killMatchingEntities(radius, player, remover::createFunction);
        actor.print("Marked " + removed + (removed != 1 ? " entities" : " entity") + " for removal.");
        return removed;
    }

    private int killMatchingEntities(Integer radius, Player player, Supplier<EntityFunction> func) throws IncompleteRegionException, MaxChangedBlocksException {
        ArrayList<EntityVisitor> visitors = new ArrayList<EntityVisitor>();
        LocalSession session = null;
        EditSession editSession = null;
        if (player != null) {
            List<? extends Entity> entities;
            session = this.we.getSessionManager().get(player);
            BlockVector3 center = session.getPlacementPosition(player);
            editSession = session.createEditSession(player);
            if (radius >= 0) {
                CylinderRegion cylinderRegion = CylinderRegion.createRadius(editSession, center, radius.intValue());
                entities = editSession.getEntities(cylinderRegion);
            } else {
                entities = editSession.getEntities();
            }
            visitors.add(new EntityVisitor(entities.iterator(), func.get()));
        } else {
            Platform platform = this.we.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            for (World world : platform.getWorlds()) {
                List<? extends Entity> entities = world.getEntities();
                visitors.add(new EntityVisitor(entities.iterator(), func.get()));
            }
        }
        int killed = 0;
        for (EntityVisitor entityVisitor : visitors) {
            Operations.completeLegacy(entityVisitor);
            killed += entityVisitor.getAffected();
        }
        if (editSession != null) {
            session.remember(editSession);
            editSession.flushSession();
        }
        return killed;
    }

    @Command(name="/calculate", aliases={"/calc", "/eval", "/evaluate", "/solve"}, desc="Evaluate a mathematical expression")
    @CommandPermissions(value={"worldedit.calc"})
    public void calc(Actor actor, List<String> input) {
        Expression expression;
        try {
            expression = Expression.compile(String.join((CharSequence)" ", input), new String[0]);
        }
        catch (ExpressionException e) {
            actor.printError(String.format("'%s' could not be parsed as a valid expression", input));
            return;
        }
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, () -> {
            double result = expression.evaluate(new double[0], WorldEdit.getInstance().getSessionManager().get(actor).getTimeout());
            String formatted = Double.isNaN(result) ? "NaN" : formatter.format(result);
            return SubtleFormat.wrap(input + " = ").append(TextComponent.of(formatted, TextColor.LIGHT_PURPLE));
        }, null);
    }

    @Command(name="/help", desc="Displays help for WorldEdit commands")
    @CommandPermissions(value={"worldedit.help"})
    public void help(Actor actor, boolean listSubCommands, int page, List<String> command) throws WorldEditException {
        PrintCommandHelp.help(command, page, listSubCommands, this.we.getPlatformManager().getPlatformCommandManager().getCommandManager(), actor, "//help");
    }

    static {
        formatter.applyPattern("#,##0.#####");
    }
}

