/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.RegionCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class RegionCommandsRegistration
implements CommandRegistration<RegionCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<BlockVector3> blockVector3_directionIncludeDiagonalstrue_Key = Key.of(BlockVector3.class, new Object(){

        Annotation a(@Direction(includeDiagonals=true) Object ah) {
            return this.getClass().getDeclaredMethods()[0].getParameterAnnotations()[0][0];
        }
    }.a(null));
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private RegionCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg(TranslatableComponent.of("pattern"), TextComponent.of("The pattern of blocks to set")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg(TranslatableComponent.of("pattern"), TextComponent.of("The pattern of blocks to place")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument thicknessPart = CommandParts.arg(TranslatableComponent.of("thickness"), TextComponent.of("The thickness of the line")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"0")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag shellPart = CommandParts.flag('h', TextComponent.of("Generate only a shell")).build();
    private final CommandArgument thicknessPart2 = CommandParts.arg(TranslatableComponent.of("thickness"), TextComponent.of("The thickness of the curve")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"0")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fromPart = CommandParts.arg(TranslatableComponent.of("from"), TextComponent.of("The mask representing blocks to replace")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final CommandArgument toPart = CommandParts.arg(TranslatableComponent.of("to"), TextComponent.of("The pattern of blocks to replace with")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart3 = CommandParts.arg(TranslatableComponent.of("pattern"), TextComponent.of("The pattern of blocks to overlay")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg(TranslatableComponent.of("iterations"), TextComponent.of("# of iterations to perform")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg(TranslatableComponent.of("mask"), TextComponent.of("The mask of blocks to use as the height map")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final CommandArgument countPart = CommandParts.arg(TranslatableComponent.of("count"), TextComponent.of("# of blocks to move")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg(TranslatableComponent.of("direction"), TextComponent.of("The direction to move")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"me")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector3_directionIncludeDiagonalstrue_Key)).build();
    private final CommandArgument replacePart = CommandParts.arg(TranslatableComponent.of("replace"), TextComponent.of("The pattern of blocks to leave")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"air")).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final NoArgCommandFlag moveSelectionPart = CommandParts.flag('s', TextComponent.of("Shift the selection to the target location")).build();
    private final NoArgCommandFlag ignoreAirBlocksPart = CommandParts.flag('a', TextComponent.of("Ignore air blocks")).build();
    private final NoArgCommandFlag copyEntitiesPart = CommandParts.flag('e', TextComponent.of("Also copy entities")).build();
    private final NoArgCommandFlag copyBiomesPart = CommandParts.flag('b', TextComponent.of("Also copy biomes")).build();
    private final ArgAcceptingCommandFlag maskPart2 = CommandParts.flag('m', TextComponent.of("Set the include mask, non-matching blocks become air")).withRequiredArg().argNamed(TranslatableComponent.of("mask")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final CommandArgument countPart2 = CommandParts.arg(TranslatableComponent.of("count"), TextComponent.of("# of copies to stack")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart2 = CommandParts.arg(TranslatableComponent.of("direction"), TextComponent.of("The direction to stack")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"me")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector3_directionIncludeDiagonalstrue_Key)).build();
    private final NoArgCommandFlag moveSelectionPart2 = CommandParts.flag('s', TextComponent.of("Shift the selection to the last stacked copy")).build();
    private final CommandArgument expressionPart = CommandParts.arg(TranslatableComponent.of("expression"), TextComponent.of("The expression to use")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag('r', TextComponent.of("Use the game's coordinate origin")).build();
    private final NoArgCommandFlag offsetPart = CommandParts.flag('o', TextComponent.of("Use the selection's center as origin")).build();
    private final CommandArgument thicknessPart3 = CommandParts.arg(TranslatableComponent.of("thickness"), TextComponent.of("Thickness of the shell to leave")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"0")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument patternPart4 = CommandParts.arg(TranslatableComponent.of("pattern"), TextComponent.of("The pattern of blocks to replace the hollowed area with")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"air")).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument typePart = CommandParts.arg(TranslatableComponent.of("type"), TextComponent.of("The type of tree to place")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"tree")).ofTypes((Collection<Key<?>>)ImmutableList.of(treeType_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg(TranslatableComponent.of("density"), TextComponent.of("The density of the forest")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"5")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();

    private RegionCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static RegionCommandsRegistration builder() {
        return new RegionCommandsRegistration();
    }

    public RegionCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public RegionCommandsRegistration containerInstance(RegionCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public RegionCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public RegionCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("/set", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Sets all the blocks in the region"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart));
            b.action(this::_set);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "set", Player.class, EditSession.class, Region.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/line", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Draws a line segment between cuboid selection corners"));
            b.footer(TextComponent.of("Can only be used with a cuboid selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart2, (Object)this.thicknessPart, (Object)this.shellPart));
            b.action(this::_line);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "line", Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/curve", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Draws a spline through selected points"));
            b.footer(TextComponent.of("Can only be used with a convex polyhedral selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart2, (Object)this.thicknessPart2, (Object)this.shellPart));
            b.action(this::_curve);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "curve", Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/replace", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/re", (Object)"/rep"));
            b.description(TextComponent.of("Replace all blocks in the selection with another"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.fromPart, (Object)this.toPart));
            b.action(this::_replace);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "replace", Player.class, EditSession.class, Region.class, Mask.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/overlay", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set a block on top of blocks in the region"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart3));
            b.action(this::_overlay);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "overlay", Player.class, EditSession.class, Region.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/center", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/middle"));
            b.description(TextComponent.of("Set the center block(s)"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart));
            b.action(this::_center);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "center", Player.class, EditSession.class, Region.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/naturalize", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("3 layers of dirt on top then rock below"));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::_naturalize);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "naturalize", Player.class, EditSession.class, Region.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/walls", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Build the four sides of the selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart));
            b.action(this::_walls);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "walls", Player.class, EditSession.class, Region.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/faces", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/outline"));
            b.description(TextComponent.of("Build the walls, ceiling, and floor of a selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart));
            b.action(this::_faces);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "faces", Player.class, EditSession.class, Region.class, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/smooth", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Smooth the elevation in the selection"));
            b.footer(TextComponent.of("Example: '//smooth 1 grass_block,dirt,stone' would only smooth natural surface terrain."));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.iterationsPart, (Object)this.maskPart));
            b.action(this::_smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "smooth", Player.class, EditSession.class, Region.class, Integer.TYPE, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/move", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Move the contents of the selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.countPart, (Object)this.directionPart, (Object)this.replacePart, (Object)this.moveSelectionPart, (Object)this.ignoreAirBlocksPart, (Object)this.copyEntitiesPart, (Object)this.copyBiomesPart, (Object)this.maskPart2));
            b.action(this::_move);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "move", Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/stack", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Repeat the contents of the selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.countPart2, (Object)this.directionPart2, (Object)this.moveSelectionPart2, (Object)this.ignoreAirBlocksPart, (Object)this.copyEntitiesPart, (Object)this.copyBiomesPart, (Object)this.maskPart2));
            b.action(this::_stack);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "stack", Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/regen", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Regenerates the contents of the selection"));
            b.footer(TextComponent.of("This command might affect things outside the selection,\nif they are within the same chunk."));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::_regen);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "regenerateChunk", Player.class, LocalSession.class, EditSession.class, Region.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/deform", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Deforms a selected region with an expression"));
            b.footer(TextComponent.of("The expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. See also https://tinyurl.com/weexpr"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.expressionPart, (Object)this.useRawCoordsPart, (Object)this.offsetPart));
            b.action(this::_deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "deform", Player.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hollow", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Hollows out the object contained in this selection"));
            b.footer(TextComponent.of("Thickness is measured in manhattan distance."));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.thicknessPart3, (Object)this.patternPart4));
            b.action(this::_hollow);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "hollow", Player.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/forest", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Make a forest within the region"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.typePart, (Object)this.densityPart));
            b.action(this::_forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "forest", Player.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/flora", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Make flora within the region"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.densityPart));
            b.action(this::_flora);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "flora", Player.class, EditSession.class, Region.class, Double.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _set(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "set", Player.class, EditSession.class, Region.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.set(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _line(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "line", Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.line(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern2(parameters), this.thickness(parameters), this.shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _curve(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "curve", Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.curve(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern2(parameters), this.thickness2(parameters), this.shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _replace(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "replace", Player.class, EditSession.class, Region.class, Mask.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.replace(this.player(parameters), this.editSession(parameters), this.region(parameters), this.from(parameters), this.to(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _overlay(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "overlay", Player.class, EditSession.class, Region.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.overlay(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _center(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "center", Player.class, EditSession.class, Region.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.center(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _naturalize(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "naturalize", Player.class, EditSession.class, Region.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.naturalize(this.player(parameters), this.editSession(parameters), this.region(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _walls(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "walls", Player.class, EditSession.class, Region.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.walls(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _faces(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "faces", Player.class, EditSession.class, Region.class, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.faces(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "smooth", Player.class, EditSession.class, Region.class, Integer.TYPE, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.smooth(this.player(parameters), this.editSession(parameters), this.region(parameters), this.iterations(parameters), this.mask(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _move(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "move", Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.move(this.player(parameters), this.editSession(parameters), this.session(parameters), this.region(parameters), this.count(parameters), this.direction(parameters), this.replace(parameters), this.moveSelection(parameters), this.ignoreAirBlocks(parameters), this.copyEntities(parameters), this.copyBiomes(parameters), this.mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _stack(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "stack", Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.stack(this.player(parameters), this.editSession(parameters), this.session(parameters), this.region(parameters), this.count2(parameters), this.direction2(parameters), this.moveSelection2(parameters), this.ignoreAirBlocks(parameters), this.copyEntities(parameters), this.copyBiomes(parameters), this.mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _regen(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "regenerateChunk", Player.class, LocalSession.class, EditSession.class, Region.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.regenerateChunk(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "deform", Player.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.deform(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.expression(parameters), this.useRawCoords(parameters), this.offset(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _hollow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "hollow", Player.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.hollow(this.player(parameters), this.editSession(parameters), this.region(parameters), this.thickness3(parameters), this.pattern4(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "forest", Player.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.forest(this.player(parameters), this.editSession(parameters), this.region(parameters), this.type(parameters), this.density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _flora(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, "flora", Player.class, EditSession.class, Region.class, Double.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            int result = this.containerInstance.flora(this.player(parameters), this.editSession(parameters), this.region(parameters), this.density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private int thickness3(CommandParameters parameters) {
        return this.thicknessPart3.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private int thickness(CommandParameters parameters) {
        return this.thicknessPart.value(parameters).asSingle(integer_Key);
    }

    private double density(CommandParameters parameters) {
        return this.densityPart.value(parameters).asSingle(double_Key);
    }

    private Pattern to(CommandParameters parameters) {
        return this.toPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern replace(CommandParameters parameters) {
        return this.replacePart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern pattern3(CommandParameters parameters) {
        return this.patternPart3.value(parameters).asSingle(pattern_Key);
    }

    private boolean copyBiomes(CommandParameters parameters) {
        return this.copyBiomesPart.in(parameters);
    }

    private List<String> expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asMultiple(string_Key);
    }

    private Mask from(CommandParameters parameters) {
        return this.fromPart.value(parameters).asSingle(mask_Key);
    }

    private boolean moveSelection(CommandParameters parameters) {
        return this.moveSelectionPart.in(parameters);
    }

    private int count2(CommandParameters parameters) {
        return this.countPart2.value(parameters).asSingle(integer_Key);
    }

    private boolean ignoreAirBlocks(CommandParameters parameters) {
        return this.ignoreAirBlocksPart.in(parameters);
    }

    private int iterations(CommandParameters parameters) {
        return this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private Mask mask2(CommandParameters parameters) {
        return this.maskPart2.value(parameters).asSingle(mask_Key);
    }

    private Pattern pattern2(CommandParameters parameters) {
        return this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private int thickness2(CommandParameters parameters) {
        return this.thicknessPart2.value(parameters).asSingle(integer_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return this.typePart.value(parameters).asSingle(treeType_Key);
    }

    private boolean copyEntities(CommandParameters parameters) {
        return this.copyEntitiesPart.in(parameters);
    }

    private boolean moveSelection2(CommandParameters parameters) {
        return this.moveSelectionPart2.in(parameters);
    }

    private Region region(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(region_selection_Key, "region", parameters.injectedValue(region_selection_Key));
    }

    private BlockVector3 direction(CommandParameters parameters) {
        return this.directionPart.value(parameters).asSingle(blockVector3_directionIncludeDiagonalstrue_Key);
    }

    private EditSession editSession(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(editSession_Key, "editSession", parameters.injectedValue(editSession_Key));
    }

    private int count(CommandParameters parameters) {
        return this.countPart.value(parameters).asSingle(integer_Key);
    }

    private boolean useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private BlockVector3 direction2(CommandParameters parameters) {
        return this.directionPart2.value(parameters).asSingle(blockVector3_directionIncludeDiagonalstrue_Key);
    }

    private Mask mask(CommandParameters parameters) {
        return this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private Pattern pattern4(CommandParameters parameters) {
        return this.patternPart4.value(parameters).asSingle(pattern_Key);
    }

    private boolean shell(CommandParameters parameters) {
        return this.shellPart.in(parameters);
    }

    private boolean offset(CommandParameters parameters) {
        return this.offsetPart.in(parameters);
    }
}

