/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.GroundFunction;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.generator.FloraGenerator;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.NoiseFilter2D;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.LayerVisitor;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.convolution.GaussianKernel;
import com.sk89q.worldedit.math.convolution.HeightMap;
import com.sk89q.worldedit.math.convolution.HeightMapFilter;
import com.sk89q.worldedit.math.noise.RandomNoise;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import java.util.List;
import org.enginehub.piston.annotation.Command;

public class RegionCommands {
    @Command(name="/set", desc="Sets all the blocks in the region")
    @CommandPermissions(value={"worldedit.region.set"})
    @Logging(value=Logging.LogMode.REGION)
    public int set(Player player, EditSession editSession, @Selection Region region, Pattern pattern) {
        BlockReplace set = new BlockReplace(editSession, pattern);
        RegionVisitor visitor = new RegionVisitor(region, set);
        Operations.completeBlindly(visitor);
        ArrayList messages = Lists.newArrayList();
        visitor.addStatusMessages(messages);
        if (messages.isEmpty()) {
            player.print("Operation completed.");
        } else {
            player.print("Operation completed (" + Joiner.on((String)", ").join((Iterable)messages) + ").");
        }
        return visitor.getAffected();
    }

    @Command(name="/line", desc="Draws a line segment between cuboid selection corners", descFooter="Can only be used with a cuboid selection")
    @CommandPermissions(value={"worldedit.region.line"})
    @Logging(value=Logging.LogMode.REGION)
    public int line(Player player, EditSession editSession, @Selection Region region, Pattern pattern, int thickness, boolean shell) throws WorldEditException {
        if (!(region instanceof CuboidRegion)) {
            player.printError("//line only works with cuboid selections");
            return 0;
        }
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        CuboidRegion cuboidregion = (CuboidRegion)region;
        BlockVector3 pos1 = cuboidregion.getPos1();
        BlockVector3 pos2 = cuboidregion.getPos2();
        int blocksChanged = editSession.drawLine(pattern, pos1, pos2, thickness, !shell);
        player.print(blocksChanged + " block(s) have been changed.");
        return blocksChanged;
    }

    @Command(name="/curve", desc="Draws a spline through selected points", descFooter="Can only be used with a convex polyhedral selection")
    @CommandPermissions(value={"worldedit.region.curve"})
    @Logging(value=Logging.LogMode.REGION)
    public int curve(Player player, EditSession editSession, @Selection Region region, Pattern pattern, int thickness, boolean shell) throws WorldEditException {
        if (!(region instanceof ConvexPolyhedralRegion)) {
            player.printError("//curve only works with convex polyhedral selections");
            return 0;
        }
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        ConvexPolyhedralRegion cpregion = (ConvexPolyhedralRegion)region;
        ArrayList<BlockVector3> vectors = new ArrayList<BlockVector3>(cpregion.getVertices());
        int blocksChanged = editSession.drawSpline(pattern, vectors, 0.0, 0.0, 0.0, 10.0, thickness, !shell);
        player.print(blocksChanged + " block(s) have been changed.");
        return blocksChanged;
    }

    @Command(name="/replace", aliases={"/re", "/rep"}, desc="Replace all blocks in the selection with another")
    @CommandPermissions(value={"worldedit.region.replace"})
    @Logging(value=Logging.LogMode.REGION)
    public int replace(Player player, EditSession editSession, @Selection Region region, Mask from, Pattern to) throws WorldEditException {
        if (from == null) {
            from = new ExistingBlockMask(editSession);
        }
        int affected = editSession.replaceBlocks(region, from, to);
        player.print(affected + " block(s) have been replaced.");
        return affected;
    }

    @Command(name="/overlay", desc="Set a block on top of blocks in the region")
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    public int overlay(Player player, EditSession editSession, @Selection Region region, Pattern pattern) throws WorldEditException {
        int affected = editSession.overlayCuboidBlocks(region, pattern);
        player.print(affected + " block(s) have been overlaid.");
        return affected;
    }

    @Command(name="/center", aliases={"/middle"}, desc="Set the center block(s)")
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.region.center"})
    public int center(Player player, EditSession editSession, @Selection Region region, Pattern pattern) throws WorldEditException {
        int affected = editSession.center(region, pattern);
        player.print("Center set (" + affected + " block(s) changed)");
        return affected;
    }

    @Command(name="/naturalize", desc="3 layers of dirt on top then rock below")
    @CommandPermissions(value={"worldedit.region.naturalize"})
    @Logging(value=Logging.LogMode.REGION)
    public int naturalize(Player player, EditSession editSession, @Selection Region region) throws WorldEditException {
        int affected = editSession.naturalizeCuboidBlocks(region);
        player.print(affected + " block(s) have been made to look more natural.");
        return affected;
    }

    @Command(name="/walls", desc="Build the four sides of the selection")
    @CommandPermissions(value={"worldedit.region.walls"})
    @Logging(value=Logging.LogMode.REGION)
    public int walls(Player player, EditSession editSession, @Selection Region region, Pattern pattern) throws WorldEditException {
        int affected = editSession.makeWalls(region, pattern);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="/faces", aliases={"/outline"}, desc="Build the walls, ceiling, and floor of a selection")
    @CommandPermissions(value={"worldedit.region.faces"})
    @Logging(value=Logging.LogMode.REGION)
    public int faces(Player player, EditSession editSession, @Selection Region region, Pattern pattern) throws WorldEditException {
        int affected = editSession.makeCuboidFaces(region, pattern);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="/smooth", desc="Smooth the elevation in the selection", descFooter="Example: '//smooth 1 grass_block,dirt,stone' would only smooth natural surface terrain.")
    @CommandPermissions(value={"worldedit.region.smooth"})
    @Logging(value=Logging.LogMode.REGION)
    public int smooth(Player player, EditSession editSession, @Selection Region region, int iterations, Mask mask) throws WorldEditException {
        HeightMap heightMap = new HeightMap(editSession, region, mask);
        HeightMapFilter filter = new HeightMapFilter(new GaussianKernel(5, 1.0));
        int affected = heightMap.applyFilter(filter, iterations);
        player.print("Terrain's height map smoothed. " + affected + " block(s) changed.");
        return affected;
    }

    @Command(name="/move", desc="Move the contents of the selection")
    @CommandPermissions(value={"worldedit.region.move"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public int move(Player player, EditSession editSession, LocalSession session, @Selection Region region, int count, @Direction(includeDiagonals=true) BlockVector3 direction, Pattern replace, boolean moveSelection, boolean ignoreAirBlocks, boolean copyEntities, boolean copyBiomes, Mask mask) throws WorldEditException {
        CommandUtil.checkCommandArgument(count >= 1, "Count must be >= 1");
        Mask combinedMask = ignoreAirBlocks ? (mask == null ? new ExistingBlockMask(editSession) : new MaskIntersection(mask, new ExistingBlockMask(editSession))) : mask;
        int affected = editSession.moveRegion(region, direction, count, copyEntities, copyBiomes, combinedMask, replace);
        if (moveSelection) {
            try {
                region.shift(direction.multiply(count));
                session.getRegionSelector(player.getWorld()).learnChanges();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
        }
        player.print(affected + " block(s) moved.");
        return affected;
    }

    @Command(name="/stack", desc="Repeat the contents of the selection")
    @CommandPermissions(value={"worldedit.region.stack"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public int stack(Player player, EditSession editSession, LocalSession session, @Selection Region region, int count, @Direction(includeDiagonals=true) BlockVector3 direction, boolean moveSelection, boolean ignoreAirBlocks, boolean copyEntities, boolean copyBiomes, Mask mask) throws WorldEditException {
        Mask combinedMask = ignoreAirBlocks ? (mask == null ? new ExistingBlockMask(editSession) : new MaskIntersection(mask, new ExistingBlockMask(editSession))) : mask;
        int affected = editSession.stackCuboidRegion(region, direction, count, copyEntities, copyBiomes, combinedMask);
        if (moveSelection) {
            try {
                BlockVector3 size = region.getMaximumPoint().subtract(region.getMinimumPoint());
                BlockVector3 shiftVector = direction.toVector3().multiply((double)count * (Math.abs(direction.dot(size)) + 1.0)).toBlockPoint();
                region.shift(shiftVector);
                session.getRegionSelector(player.getWorld()).learnChanges();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
        }
        player.print(affected + " block(s) changed. Undo with //undo");
        return affected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="/regen", desc="Regenerates the contents of the selection", descFooter="This command might affect things outside the selection,\nif they are within the same chunk.")
    @CommandPermissions(value={"worldedit.regen"})
    @Logging(value=Logging.LogMode.REGION)
    public void regenerateChunk(Player player, LocalSession session, EditSession editSession, @Selection Region region) throws WorldEditException {
        Mask mask = session.getMask();
        try {
            session.setMask(null);
            player.getWorld().regenerate(region, editSession);
        }
        finally {
            session.setMask(mask);
        }
        player.print("Region regenerated.");
    }

    @Command(name="/deform", desc="Deforms a selected region with an expression", descFooter="The expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. See also https://tinyurl.com/weexpr")
    @CommandPermissions(value={"worldedit.region.deform"})
    @Logging(value=Logging.LogMode.ALL)
    public int deform(Player player, LocalSession session, EditSession editSession, @Selection Region region, List<String> expression, boolean useRawCoords, boolean offset) throws WorldEditException {
        Vector3 unit;
        Vector3 zero;
        if (useRawCoords) {
            zero = Vector3.ZERO;
            unit = Vector3.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player).toVector3();
            unit = Vector3.ONE;
        } else {
            Vector3 min = region.getMinimumPoint().toVector3();
            Vector3 max = region.getMaximumPoint().toVector3();
            unit = max.subtract(zero = max.add(min).divide(2.0));
            if (unit.getX() == 0.0) {
                unit = unit.withX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.withY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.withZ(1.0);
            }
        }
        try {
            int affected = editSession.deformRegion(region, zero, unit, String.join((CharSequence)" ", expression), session.getTimeout());
            player.findFreePosition();
            player.print(affected + " block(s) have been deformed.");
            return affected;
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
            return 0;
        }
    }

    @Command(name="/hollow", desc="Hollows out the object contained in this selection", descFooter="Thickness is measured in manhattan distance.")
    @CommandPermissions(value={"worldedit.region.hollow"})
    @Logging(value=Logging.LogMode.REGION)
    public int hollow(Player player, EditSession editSession, @Selection Region region, int thickness, Pattern pattern) throws WorldEditException {
        CommandUtil.checkCommandArgument(thickness >= 0, "Thickness must be >= 0");
        int affected = editSession.hollowOutRegion(region, thickness, pattern);
        player.print(affected + " block(s) have been changed.");
        return affected;
    }

    @Command(name="/forest", desc="Make a forest within the region")
    @CommandPermissions(value={"worldedit.region.forest"})
    @Logging(value=Logging.LogMode.REGION)
    public int forest(Player player, EditSession editSession, @Selection Region region, TreeGenerator.TreeType type, double density) throws WorldEditException {
        CommandUtil.checkCommandArgument(0.0 <= density && density <= 100.0, "Density must be in [0, 100]");
        int affected = editSession.makeForest(region, density / 100.0, type);
        player.print(affected + " trees created.");
        return affected;
    }

    @Command(name="/flora", desc="Make flora within the region")
    @CommandPermissions(value={"worldedit.region.flora"})
    @Logging(value=Logging.LogMode.REGION)
    public int flora(Player player, EditSession editSession, @Selection Region region, double density) throws WorldEditException {
        CommandUtil.checkCommandArgument(0.0 <= density && density <= 100.0, "Density must be in [0, 100]");
        FloraGenerator generator = new FloraGenerator(editSession);
        GroundFunction ground = new GroundFunction(new ExistingBlockMask(editSession), generator);
        LayerVisitor visitor = new LayerVisitor(Regions.asFlatRegion(region), Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground);
        visitor.setMask(new NoiseFilter2D(new RandomNoise(), density /= 100.0));
        Operations.completeLegacy(visitor);
        int affected = ground.getAffected();
        player.print(affected + " flora created.");
        return affected;
    }
}

