/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GeneralCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class GeneralCommandsRegistration
implements CommandRegistration<GeneralCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<EditSession.ReorderMode> reorderMode_Key = Key.of(EditSession.ReorderMode.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private GeneralCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument limitPart = CommandParts.arg(TranslatableComponent.of("limit"), TextComponent.of("The limit to set")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument limitPart2 = CommandParts.arg(TranslatableComponent.of("limit"), TextComponent.of("The timeout time to set")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fastModePart = CommandParts.arg(TranslatableComponent.of("fastMode"), TextComponent.of("The new fast mode state")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument reorderModePart = CommandParts.arg(TranslatableComponent.of("reorderMode"), TextComponent.of("The reorder mode")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(reorderMode_Key)).build();
    private final CommandArgument drawSelectionPart = CommandParts.arg(TranslatableComponent.of("drawSelection"), TextComponent.of("The new draw selection state")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg(TranslatableComponent.of("mask"), TextComponent.of("The mask to set")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag blocksOnlyPart = CommandParts.flag('b', TextComponent.of("Only search for blocks")).build();
    private final NoArgCommandFlag itemsOnlyPart = CommandParts.flag('i', TextComponent.of("Only search for items")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag('p', TextComponent.of("Page of results to return")).withRequiredArg().argNamed(TranslatableComponent.of("page")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument queryPart = CommandParts.arg(TranslatableComponent.of("query"), TextComponent.of("Search query")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).variable(true).build();

    private GeneralCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static GeneralCommandsRegistration builder() {
        return new GeneralCommandsRegistration();
    }

    public GeneralCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public GeneralCommandsRegistration containerInstance(GeneralCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public GeneralCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public GeneralCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("/limit", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Modify block change limit"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.limitPart));
            b.action(this::_limit);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "limit", Player.class, LocalSession.class, Integer.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/timeout", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Modify evaluation timeout time."));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.limitPart2));
            b.action(this::_timeout);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "timeout", Player.class, LocalSession.class, Integer.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/fast", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Toggle fast mode"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.fastModePart));
            b.action(this::_fast);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "fast", Player.class, LocalSession.class, Boolean.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/reorder", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Sets the reorder mode of WorldEdit"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.reorderModePart));
            b.action(this::_reorder);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "reorderMode", Player.class, LocalSession.class, EditSession.ReorderMode.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/drawsel", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Toggle drawing the current selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.drawSelectionPart));
            b.action(this::_drawsel);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "drawSelection", Player.class, LocalSession.class, Boolean.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gmask", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/gmask"));
            b.description(TextComponent.of("Set the global mask"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.maskPart));
            b.action(this::gmask);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "gmask", Player.class, LocalSession.class, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggleplace", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/toggleplace"));
            b.description(TextComponent.of("Switch between your position and pos1 for placement"));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::toggleplace);
        });
        this.commandManager.register("searchitem", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"/searchitem", (Object)"/l", (Object)"/search"));
            b.description(TextComponent.of("Search for an item"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.blocksOnlyPart, (Object)this.itemsOnlyPart, (Object)this.pagePart, (Object)this.queryPart));
            b.action(this::searchitem);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "searchItem", Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _limit(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "limit", Player.class, LocalSession.class, Integer.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.limit(this.player(parameters), this.session(parameters), this.limit(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _timeout(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "timeout", Player.class, LocalSession.class, Integer.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.timeout(this.player(parameters), this.session(parameters), this.limit2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _fast(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "fast", Player.class, LocalSession.class, Boolean.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.fast(this.player(parameters), this.session(parameters), this.fastMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _reorder(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "reorderMode", Player.class, LocalSession.class, EditSession.ReorderMode.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.reorderMode(this.player(parameters), this.session(parameters), this.reorderMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _drawsel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "drawSelection", Player.class, LocalSession.class, Boolean.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.drawSelection(this.player(parameters), this.session(parameters), this.drawSelection(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int gmask(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "gmask", Player.class, LocalSession.class, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.gmask(this.player(parameters), this.session(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int toggleplace(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "togglePlace", Player.class, LocalSession.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.togglePlace(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int searchitem(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, "searchItem", Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.searchItem(this.actor(parameters), this.blocksOnly(parameters), this.itemsOnly(parameters), this.page(parameters), this.query(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private Boolean fastMode(CommandParameters parameters) {
        return this.fastModePart.value(parameters).asSingle(boolean_Key);
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private boolean blocksOnly(CommandParameters parameters) {
        return this.blocksOnlyPart.in(parameters);
    }

    private List<String> query(CommandParameters parameters) {
        return this.queryPart.value(parameters).asMultiple(string_Key);
    }

    private Integer limit(CommandParameters parameters) {
        return this.limitPart.value(parameters).asSingle(integer_Key);
    }

    private int page(CommandParameters parameters) {
        return this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private EditSession.ReorderMode reorderMode(CommandParameters parameters) {
        return this.reorderModePart.value(parameters).asSingle(reorderMode_Key);
    }

    private Boolean drawSelection(CommandParameters parameters) {
        return this.drawSelectionPart.value(parameters).asSingle(boolean_Key);
    }

    private Integer limit2(CommandParameters parameters) {
        return this.limitPart2.value(parameters).asSingle(integer_Key);
    }

    private Actor actor(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(actor_Key, "actor", parameters.injectedValue(actor_Key));
    }

    private Mask mask(CommandParameters parameters) {
        return this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private boolean itemsOnly(CommandParameters parameters) {
        return this.itemsOnlyPart.in(parameters);
    }
}

