/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.paperlib.environments;

import com.sk89q.worldedit.bukkit.paperlib.features.asyncchunks.AsyncChunks;
import com.sk89q.worldedit.bukkit.paperlib.features.asyncchunks.AsyncChunksSync;
import com.sk89q.worldedit.bukkit.paperlib.features.asyncteleport.AsyncTeleport;
import com.sk89q.worldedit.bukkit.paperlib.features.asyncteleport.AsyncTeleportSync;
import com.sk89q.worldedit.bukkit.paperlib.features.blockstatesnapshot.BlockStateSnapshot;
import com.sk89q.worldedit.bukkit.paperlib.features.blockstatesnapshot.BlockStateSnapshotBeforeSnapshots;
import com.sk89q.worldedit.bukkit.paperlib.features.blockstatesnapshot.BlockStateSnapshotNoOption;
import com.sk89q.worldedit.bukkit.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import com.sk89q.worldedit.bukkit.paperlib.features.chunkisgenerated.ChunkIsGenerated;
import com.sk89q.worldedit.bukkit.paperlib.features.chunkisgenerated.ChunkIsGeneratedApiExists;
import com.sk89q.worldedit.bukkit.paperlib.features.chunkisgenerated.ChunkIsGeneratedUnknown;
import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Environment {
    private int minecraftVersion;
    private int minecraftPatchVersion;
    protected AsyncChunks asyncChunksHandler = new AsyncChunksSync();
    protected AsyncTeleport asyncTeleportHandler = new AsyncTeleportSync();
    protected ChunkIsGenerated isGeneratedHandler = new ChunkIsGeneratedUnknown();
    protected BlockStateSnapshot blockStateSnapshotHandler;

    public Environment() {
        Pattern versionPattern = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?\\)");
        Matcher matcher = versionPattern.matcher(Bukkit.getVersion());
        int version = 0;
        int patchVersion = 0;
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            try {
                version = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (matchResult.groupCount() >= 3) {
                try {
                    patchVersion = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.minecraftVersion = version;
        this.minecraftPatchVersion = patchVersion;
        if (this.isVersion(13, 1)) {
            this.isGeneratedHandler = new ChunkIsGeneratedApiExists();
        }
        this.blockStateSnapshotHandler = !this.isVersion(12) ? new BlockStateSnapshotBeforeSnapshots() : new BlockStateSnapshotNoOption();
    }

    public abstract String getName();

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen) {
        return this.asyncChunksHandler.getChunkAtAsync(world, x, z, gen);
    }

    public CompletableFuture<Boolean> teleport(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.asyncTeleportHandler.teleportAsync(entity, location, cause);
    }

    public boolean isChunkGenerated(World world, int x, int z) {
        return this.isGeneratedHandler.isChunkGenerated(world, x, z);
    }

    public BlockStateSnapshotResult getBlockState(Block block, boolean useSnapshot) {
        return this.blockStateSnapshotHandler.getBlockState(block, useSnapshot);
    }

    public boolean isVersion(int minor) {
        return this.isVersion(minor, 0);
    }

    public boolean isVersion(int minor, int patch) {
        return this.minecraftVersion > minor || this.minecraftVersion >= minor && this.minecraftPatchVersion >= patch;
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getMinecraftPatchVersion() {
        return this.minecraftPatchVersion;
    }

    public boolean isSpigot() {
        return false;
    }

    public boolean isPaper() {
        return false;
    }
}

