/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.google.common.base.Preconditions;
import com.sk89q.jchronic.Chronic;
import com.sk89q.jchronic.Options;
import com.sk89q.jchronic.utils.Span;
import com.sk89q.jchronic.utils.Time;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.InvalidToolBindException;
import com.sk89q.worldedit.command.tool.NavigationWand;
import com.sk89q.worldedit.command.tool.SelectionWand;
import com.sk89q.worldedit.command.tool.SinglePickaxe;
import com.sk89q.worldedit.command.tool.Tool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.internal.cui.CUIRegion;
import com.sk89q.worldedit.internal.cui.SelectionShapeEvent;
import com.sk89q.worldedit.internal.cui.ServerCUIHandler;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.RegionSelectorType;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.snapshot.Snapshot;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class LocalSession {
    public static transient int MAX_HISTORY_SIZE = 15;
    private transient LocalConfiguration config;
    private final transient AtomicBoolean dirty = new AtomicBoolean();
    private transient int failedCuiAttempts = 0;
    private transient RegionSelector selector = new CuboidRegionSelector();
    private transient boolean placeAtPos1 = false;
    private transient LinkedList<EditSession> history = new LinkedList();
    private transient int historyPointer = 0;
    private transient ClipboardHolder clipboard;
    private transient boolean superPickaxe = false;
    private transient BlockTool pickaxeMode = new SinglePickaxe();
    private transient Map<ItemType, Tool> tools = new HashMap<ItemType, Tool>();
    private transient int maxBlocksChanged = -1;
    private transient int maxTimeoutTime;
    private transient boolean useInventory;
    private transient Snapshot snapshot;
    private transient boolean hasCUISupport = false;
    private transient int cuiVersion = -1;
    private transient boolean fastMode = false;
    private transient Mask mask;
    private transient ZoneId timezone = ZoneId.systemDefault();
    private transient BlockVector3 cuiTemporaryBlock;
    private transient EditSession.ReorderMode reorderMode = EditSession.ReorderMode.MULTI_STAGE;
    private transient List<Countable<BlockState>> lastDistribution;
    private String lastScript;
    private RegionSelectorType defaultSelector;
    private boolean useServerCUI = false;
    private String wandItem;
    private String navWandItem;

    public LocalSession() {
    }

    public LocalSession(@Nullable LocalConfiguration config) {
        this.config = config;
    }

    public void setConfiguration(LocalConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public void postLoad() {
        if (this.defaultSelector != null) {
            this.selector = this.defaultSelector.createSelector();
        }
    }

    public boolean isDirty() {
        return this.dirty.get();
    }

    private void setDirty() {
        this.dirty.set(true);
    }

    public boolean compareAndResetDirty() {
        return this.dirty.compareAndSet(true, false);
    }

    public ZoneId getTimeZone() {
        return this.timezone;
    }

    public void setTimezone(ZoneId timezone) {
        Preconditions.checkNotNull((Object)timezone);
        this.timezone = timezone;
    }

    public void clearHistory() {
        this.history.clear();
        this.historyPointer = 0;
    }

    public void remember(EditSession editSession) {
        Preconditions.checkNotNull((Object)editSession);
        if (editSession.size() == 0) {
            return;
        }
        while (this.historyPointer < this.history.size()) {
            this.history.remove(this.historyPointer);
        }
        this.history.add(editSession);
        while (this.history.size() > MAX_HISTORY_SIZE) {
            this.history.remove(0);
        }
        this.historyPointer = this.history.size();
    }

    public EditSession undo(@Nullable BlockBag newBlockBag, Player player) {
        Preconditions.checkNotNull((Object)player);
        --this.historyPointer;
        if (this.historyPointer >= 0) {
            EditSession editSession = this.history.get(this.historyPointer);
            try (EditSession newEditSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(editSession.getWorld(), -1, newBlockBag, player);){
                newEditSession.enableStandardMode();
                newEditSession.setReorderMode(this.reorderMode);
                newEditSession.setFastMode(this.fastMode);
                if (newEditSession.getSurvivalExtent() != null) {
                    newEditSession.getSurvivalExtent().setStripNbt(!player.hasPermission("worldedit.setnbt"));
                }
                editSession.undo(newEditSession);
            }
            return editSession;
        }
        this.historyPointer = 0;
        return null;
    }

    public EditSession redo(@Nullable BlockBag newBlockBag, Player player) {
        Preconditions.checkNotNull((Object)player);
        if (this.historyPointer < this.history.size()) {
            EditSession editSession = this.history.get(this.historyPointer);
            try (EditSession newEditSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(editSession.getWorld(), -1, newBlockBag, player);){
                newEditSession.enableStandardMode();
                newEditSession.setReorderMode(this.reorderMode);
                newEditSession.setFastMode(this.fastMode);
                if (newEditSession.getSurvivalExtent() != null) {
                    newEditSession.getSurvivalExtent().setStripNbt(!player.hasPermission("worldedit.setnbt"));
                }
                editSession.redo(newEditSession);
            }
            ++this.historyPointer;
            return editSession;
        }
        return null;
    }

    public RegionSelectorType getDefaultRegionSelector() {
        return this.defaultSelector;
    }

    public void setDefaultRegionSelector(RegionSelectorType defaultSelector) {
        Preconditions.checkNotNull((Object)((Object)defaultSelector));
        this.defaultSelector = defaultSelector;
        this.setDirty();
    }

    public RegionSelector getRegionSelector(World world) {
        Preconditions.checkNotNull((Object)world);
        if (this.selector.getWorld() == null || !this.selector.getWorld().equals(world)) {
            this.selector.setWorld(world);
            this.selector.clear();
        }
        return this.selector;
    }

    public void setRegionSelector(World world, RegionSelector selector) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)selector);
        selector.setWorld(world);
        this.selector = selector;
    }

    public boolean isSelectionDefined(World world) {
        Preconditions.checkNotNull((Object)world);
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            return false;
        }
        return this.selector.isDefined();
    }

    public Region getSelection(World world) throws IncompleteRegionException {
        Preconditions.checkNotNull((Object)world);
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            throw new IncompleteRegionException();
        }
        return this.selector.getRegion();
    }

    public World getSelectionWorld() {
        return this.selector.getIncompleteRegion().getWorld();
    }

    public ClipboardHolder getClipboard() throws EmptyClipboardException {
        if (this.clipboard == null) {
            throw new EmptyClipboardException();
        }
        return this.clipboard;
    }

    public void setClipboard(@Nullable ClipboardHolder clipboard) {
        this.clipboard = clipboard;
    }

    @Deprecated
    public boolean isToolControlEnabled() {
        return true;
    }

    @Deprecated
    public void setToolControl(boolean toolControl) {
    }

    public int getBlockChangeLimit() {
        return this.maxBlocksChanged;
    }

    public void setBlockChangeLimit(int maxBlocksChanged) {
        this.maxBlocksChanged = maxBlocksChanged;
    }

    public int getTimeout() {
        return this.maxTimeoutTime;
    }

    public void setTimeout(int timeout) {
        this.maxTimeoutTime = timeout;
    }

    public boolean hasSuperPickAxe() {
        return this.superPickaxe;
    }

    public void enableSuperPickAxe() {
        this.superPickaxe = true;
    }

    public void disableSuperPickAxe() {
        this.superPickaxe = false;
    }

    public boolean toggleSuperPickAxe() {
        this.superPickaxe = !this.superPickaxe;
        return this.superPickaxe;
    }

    public BlockVector3 getPlacementPosition(Player player) throws IncompleteRegionException {
        Preconditions.checkNotNull((Object)player);
        if (!this.placeAtPos1) {
            return player.getBlockIn().toVector().toBlockPoint();
        }
        return this.selector.getPrimaryPosition();
    }

    public boolean togglePlacementPosition() {
        this.placeAtPos1 = !this.placeAtPos1;
        return this.placeAtPos1;
    }

    @Nullable
    public BlockBag getBlockBag(Player player) {
        Preconditions.checkNotNull((Object)player);
        if (!this.useInventory) {
            return null;
        }
        return player.getInventoryBlockBag();
    }

    @Nullable
    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(@Nullable Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public BlockTool getSuperPickaxe() {
        return this.pickaxeMode;
    }

    public void setSuperPickaxe(BlockTool tool) {
        Preconditions.checkNotNull((Object)tool);
        this.pickaxeMode = tool;
    }

    @Nullable
    public Tool getTool(ItemType item) {
        return this.tools.get(item);
    }

    public BrushTool getBrushTool(ItemType item) throws InvalidToolBindException {
        Tool tool = this.getTool(item);
        if (!(tool instanceof BrushTool)) {
            tool = new BrushTool("worldedit.brush.sphere");
            this.setTool(item, tool);
        }
        return (BrushTool)tool;
    }

    public void setTool(ItemType item, @Nullable Tool tool) throws InvalidToolBindException {
        if (item.hasBlockType()) {
            throw new InvalidToolBindException(item, "Blocks can't be used");
        }
        if (tool instanceof SelectionWand) {
            this.wandItem = item.getId();
            this.setDirty();
        } else if (tool instanceof NavigationWand) {
            this.navWandItem = item.getId();
            this.setDirty();
        }
        this.tools.put(item, tool);
    }

    public boolean isUsingInventory() {
        return this.useInventory;
    }

    public void setUseInventory(boolean useInventory) {
        this.useInventory = useInventory;
    }

    @Nullable
    public String getLastScript() {
        return this.lastScript;
    }

    public void setLastScript(@Nullable String lastScript) {
        this.lastScript = lastScript;
        this.setDirty();
    }

    public void tellVersion(Actor player) {
    }

    public boolean shouldUseServerCUI() {
        return this.useServerCUI;
    }

    public void setUseServerCUI(boolean useServerCUI) {
        this.useServerCUI = useServerCUI;
        this.setDirty();
    }

    public void updateServerCUI(Actor actor) {
        if (!actor.isPlayer()) {
            return;
        }
        if (!this.config.serverSideCUI) {
            return;
        }
        Player player = (Player)actor;
        if (!this.useServerCUI || this.hasCUISupport) {
            if (this.cuiTemporaryBlock != null) {
                player.sendFakeBlock(this.cuiTemporaryBlock, null);
                this.cuiTemporaryBlock = null;
            }
            return;
        }
        BaseBlock block = ServerCUIHandler.createStructureBlock(player);
        if (block != null) {
            Object tags = block.getNbtData().getValue();
            BlockVector3 tempCuiTemporaryBlock = BlockVector3.at(((IntTag)tags.get("x")).getValue(), ((IntTag)tags.get("y")).getValue(), ((IntTag)tags.get("z")).getValue());
            if (this.cuiTemporaryBlock != null && !tempCuiTemporaryBlock.equals(this.cuiTemporaryBlock)) {
                player.sendFakeBlock(this.cuiTemporaryBlock, null);
            }
            this.cuiTemporaryBlock = tempCuiTemporaryBlock;
            player.sendFakeBlock(this.cuiTemporaryBlock, block);
        } else if (this.cuiTemporaryBlock != null) {
            player.sendFakeBlock(this.cuiTemporaryBlock, null);
            this.cuiTemporaryBlock = null;
        }
    }

    public void dispatchCUIEvent(Actor actor, CUIEvent event) {
        Preconditions.checkNotNull((Object)actor);
        Preconditions.checkNotNull((Object)event);
        if (this.hasCUISupport) {
            actor.dispatchCUIEvent(event);
        } else if (this.useServerCUI) {
            this.updateServerCUI(actor);
        }
    }

    public void dispatchCUISetup(Actor actor) {
        if (this.selector != null) {
            this.dispatchCUISelection(actor);
        }
    }

    public void dispatchCUISelection(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        if (!this.hasCUISupport && this.useServerCUI) {
            this.updateServerCUI(actor);
            return;
        }
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                actor.dispatchCUIEvent(new SelectionShapeEvent(tempSel.getLegacyTypeID()));
                tempSel.describeLegacyCUI(this, actor);
            } else {
                actor.dispatchCUIEvent(new SelectionShapeEvent(tempSel.getTypeID()));
                tempSel.describeCUI(this, actor);
            }
        }
    }

    public void describeCUI(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        if (!this.hasCUISupport) {
            return;
        }
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                tempSel.describeLegacyCUI(this, actor);
            } else {
                tempSel.describeCUI(this, actor);
            }
        }
    }

    public void handleCUIInitializationMessage(String text, Actor actor) {
        Preconditions.checkNotNull((Object)text);
        if (this.hasCUISupport || this.failedCuiAttempts > 3) {
            return;
        }
        String[] split = text.split("\\|", 2);
        if (split.length > 1 && split[0].equalsIgnoreCase("v")) {
            int version;
            if (split[1].length() > 4) {
                ++this.failedCuiAttempts;
                return;
            }
            try {
                version = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                WorldEdit.logger.warn("Error while reading CUI init message: " + e.getMessage());
                ++this.failedCuiAttempts;
                return;
            }
            this.setCUISupport(true);
            this.setCUIVersion(version);
            this.dispatchCUISelection(actor);
        }
    }

    public boolean hasCUISupport() {
        return this.hasCUISupport;
    }

    public void setCUISupport(boolean support) {
        this.hasCUISupport = support;
    }

    public int getCUIVersion() {
        return this.cuiVersion;
    }

    public void setCUIVersion(int cuiVersion) {
        this.cuiVersion = cuiVersion;
    }

    @Nullable
    public Calendar detectDate(String input) {
        Preconditions.checkNotNull((Object)input);
        TimeZone tz = TimeZone.getTimeZone(this.getTimeZone());
        Time.setTimeZone(tz);
        Options opt = new Options();
        opt.setNow(Calendar.getInstance(tz));
        Span date = Chronic.parse(input, opt);
        if (date == null) {
            return null;
        }
        return date.getBeginCalendar();
    }

    public EditSession createEditSession(Player player) {
        Preconditions.checkNotNull((Object)player);
        BlockBag blockBag = this.getBlockBag(player);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(player.isPlayer() ? player.getWorld() : null, this.getBlockChangeLimit(), blockBag, player);
        Request.request().setEditSession(editSession);
        editSession.setFastMode(this.fastMode);
        editSession.setReorderMode(this.reorderMode);
        editSession.setMask(this.mask);
        if (editSession.getSurvivalExtent() != null) {
            editSession.getSurvivalExtent().setStripNbt(!player.hasPermission("worldedit.setnbt"));
        }
        return editSession;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public EditSession.ReorderMode getReorderMode() {
        return this.reorderMode;
    }

    public void setReorderMode(EditSession.ReorderMode reorderMode) {
        this.reorderMode = reorderMode;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public String getWandItem() {
        return this.wandItem;
    }

    public String getNavWandItem() {
        return this.navWandItem;
    }

    public List<Countable<BlockState>> getLastDistribution() {
        return this.lastDistribution == null ? null : Collections.unmodifiableList(this.lastDistribution);
    }

    public void setLastDistribution(List<Countable<BlockState>> dist) {
        this.lastDistribution = dist;
    }
}

