/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.ess3.api.IUser;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class LocationUtil {
    private static final Set<Material> WATER_TYPES = EnumUtil.getAllMatching(Material.class, "WATER", "FLOWING_WATER");
    private static final Set<Material> HOLLOW_MATERIALS = new HashSet<Material>();
    private static final Set<Material> TRANSPARENT_MATERIALS = new HashSet<Material>();
    public static final int RADIUS = 3;
    public static final Vector3D[] VOLUME;

    public static void setIsWaterSafe(boolean isWaterSafe) {
        if (isWaterSafe) {
            HOLLOW_MATERIALS.addAll(WATER_TYPES);
        } else {
            HOLLOW_MATERIALS.removeAll(WATER_TYPES);
        }
    }

    public static ItemStack convertBlockToItem(Block block) {
        return new ItemStack(block.getType(), 1);
    }

    public static Location getTarget(LivingEntity entity) throws Exception {
        Block block = null;
        try {
            block = entity.getTargetBlock(TRANSPARENT_MATERIALS, 300);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (block == null) {
            throw new Exception("Not targeting a block");
        }
        return block.getLocation();
    }

    public static boolean isBlockAboveAir(World world, int x, int y, int z) {
        return y > world.getMaxHeight() || HOLLOW_MATERIALS.contains(world.getBlockAt(x, y - 1, z).getType());
    }

    public static boolean isBlockUnsafeForUser(IUser user, World world, int x, int y, int z) {
        if (user.getBase().isOnline() && world.equals(user.getBase().getWorld()) && (user.getBase().getGameMode() == GameMode.CREATIVE || user.getBase().getGameMode() == GameMode.SPECTATOR || user.isGodModeEnabled()) && user.getBase().getAllowFlight()) {
            return false;
        }
        if (LocationUtil.isBlockDamaging(world, x, y, z)) {
            return true;
        }
        return LocationUtil.isBlockAboveAir(world, x, y, z);
    }

    public static boolean isBlockUnsafe(World world, int x, int y, int z) {
        return LocationUtil.isBlockDamaging(world, x, y, z) || LocationUtil.isBlockAboveAir(world, x, y, z);
    }

    public static boolean isBlockDamaging(World world, int x, int y, int z) {
        Block below = world.getBlockAt(x, y - 1, z);
        switch (below.getType()) {
            case LAVA: 
            case FIRE: {
                return true;
            }
        }
        if (MaterialUtil.isBed(below.getType())) {
            return true;
        }
        try {
            if (below.getType() == Material.valueOf((String)"FLOWING_LAVA")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Material PORTAL = EnumUtil.getMaterial("NETHER_PORTAL", "PORTAL");
        if (world.getBlockAt(x, y, z).getType() == PORTAL) {
            return true;
        }
        return !HOLLOW_MATERIALS.contains(world.getBlockAt(x, y, z).getType()) || !HOLLOW_MATERIALS.contains(world.getBlockAt(x, y + 1, z).getType());
    }

    public static Location getRoundedDestination(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = (int)Math.round(loc.getY());
        int z = loc.getBlockZ();
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, loc.getYaw(), loc.getPitch());
    }

    @Deprecated
    public static Location getSafeDestination(IUser user, Location loc) throws Exception {
        return LocationUtil.getSafeDestination(null, user, loc);
    }

    public static Location getSafeDestination(IEssentials ess, IUser user, Location loc) throws Exception {
        if (user.getBase().isOnline() && loc.getWorld().equals(user.getBase().getWorld()) && (user.getBase().getGameMode() == GameMode.CREATIVE || user.isGodModeEnabled()) && user.getBase().getAllowFlight()) {
            if (LocationUtil.shouldFly(loc)) {
                user.getBase().setFlying(true);
            }
            if (ess == null || ess.getSettings().isTeleportToCenterLocation()) {
                return LocationUtil.getRoundedDestination(loc);
            }
            return loc;
        }
        return LocationUtil.getSafeDestination(loc);
    }

    public static Location getSafeDestination(Location loc) throws Exception {
        if (loc == null || loc.getWorld() == null) {
            throw new Exception(I18n.tl("destinationNotSet", new Object[0]));
        }
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = (int)Math.round(loc.getY());
        int z = loc.getBlockZ();
        int origX = x;
        int origY = y;
        int origZ = z;
        while (LocationUtil.isBlockAboveAir(world, x, y, z)) {
            if (--y >= 0) continue;
            y = origY;
            break;
        }
        if (LocationUtil.isBlockUnsafe(world, x, y, z)) {
            x = Math.round(loc.getX()) == (long)origX ? x - 1 : x + 1;
            z = Math.round(loc.getZ()) == (long)origZ ? z - 1 : z + 1;
        }
        int i = 0;
        while (LocationUtil.isBlockUnsafe(world, x, y, z)) {
            if (++i >= VOLUME.length) {
                x = origX;
                y = origY + 3;
                z = origZ;
                break;
            }
            x = origX + LocationUtil.VOLUME[i].x;
            y = origY + LocationUtil.VOLUME[i].y;
            z = origZ + LocationUtil.VOLUME[i].z;
        }
        while (LocationUtil.isBlockUnsafe(world, x, y, z)) {
            if (++y < world.getMaxHeight()) continue;
            ++x;
            break;
        }
        while (LocationUtil.isBlockUnsafe(world, x, y, z)) {
            if (--y > 1) continue;
            y = world.getHighestBlockYAt(++x, z);
            if (x - 48 <= loc.getBlockX()) continue;
            throw new Exception(I18n.tl("holeInFloor", new Object[0]));
        }
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, loc.getYaw(), loc.getPitch());
    }

    public static boolean shouldFly(Location loc) {
        int y;
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int count = 0;
        for (y = (int)Math.round(loc.getY()); LocationUtil.isBlockUnsafe(world, x, y, z) && y > -1; --y) {
            if (++count <= 2) continue;
            return true;
        }
        return y < 0;
    }

    static {
        for (Material mat : Material.values()) {
            if (!mat.isTransparent()) continue;
            HOLLOW_MATERIALS.add(mat);
        }
        TRANSPARENT_MATERIALS.addAll(HOLLOW_MATERIALS);
        TRANSPARENT_MATERIALS.addAll(WATER_TYPES);
        ArrayList<Vector3D> pos = new ArrayList<Vector3D>();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    pos.add(new Vector3D(x, y, z));
                }
            }
        }
        pos.sort(Comparator.comparingInt(a -> a.x * a.x + a.y * a.y + a.z * a.z));
        VOLUME = pos.toArray(new Vector3D[0]);
    }

    public static class Vector3D {
        public int x;
        public int y;
        public int z;

        Vector3D(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

