/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IUser;
import org.bukkit.ChatColor;

public class FormatUtil {
    private static final Set<ChatColor> COLORS = EnumSet.of(ChatColor.BLACK, new ChatColor[]{ChatColor.DARK_BLUE, ChatColor.DARK_GREEN, ChatColor.DARK_AQUA, ChatColor.DARK_RED, ChatColor.DARK_PURPLE, ChatColor.GOLD, ChatColor.GRAY, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.GREEN, ChatColor.AQUA, ChatColor.RED, ChatColor.LIGHT_PURPLE, ChatColor.YELLOW, ChatColor.WHITE});
    private static final Set<ChatColor> FORMATS = EnumSet.of(ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.UNDERLINE, ChatColor.ITALIC, ChatColor.RESET);
    private static final Set<ChatColor> MAGIC = EnumSet.of(ChatColor.MAGIC);
    private static final Pattern STRIP_ALL_PATTERN = Pattern.compile("\u00a7+([0-9a-fk-orA-FK-OR])");
    private static final Pattern REPLACE_ALL_PATTERN = Pattern.compile("(&)?&([0-9a-fk-orA-FK-OR])");
    private static final Pattern LOGCOLOR_PATTERN = Pattern.compile("\\x1B\\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]");
    private static final Pattern URL_PATTERN = Pattern.compile("((?:(?:https?)://)?[\\w-_\\.]{2,})\\.([a-zA-Z]{2,3}(?:/\\S+)?)");
    public static final Pattern IPPATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public static String stripFormat(String input) {
        if (input == null) {
            return null;
        }
        return ChatColor.stripColor((String)input);
    }

    public static String stripEssentialsFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(input, REPLACE_ALL_PATTERN);
    }

    public static String formatMessage(IUser user, String permBase, String input) {
        if (input == null) {
            return null;
        }
        String message = FormatUtil.formatString(user, permBase, input);
        if (!user.isAuthorized(permBase + ".url")) {
            message = FormatUtil.blockURL(message);
        }
        return message;
    }

    public static String replaceFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.replaceColor(input, EnumSet.allOf(ChatColor.class));
    }

    static String replaceColor(String input, Set<ChatColor> supported) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = REPLACE_ALL_PATTERN.matcher(input);
        block0: while (matcher.find()) {
            boolean isEscaped;
            boolean bl = isEscaped = matcher.group(1) != null;
            if (!isEscaped) {
                char code = matcher.group(2).toLowerCase(Locale.ROOT).charAt(0);
                for (ChatColor color : supported) {
                    if (color.getChar() != code) continue;
                    matcher.appendReplacement(builder, "\u00a7$2");
                    continue block0;
                }
            }
            matcher.appendReplacement(builder, "&$2");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    static String stripColor(String input, Set<ChatColor> strip) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = STRIP_ALL_PATTERN.matcher(input);
        block0: while (matcher.find()) {
            char code = matcher.group(1).toLowerCase(Locale.ROOT).charAt(0);
            for (ChatColor color : strip) {
                if (color.getChar() != code) continue;
                matcher.appendReplacement(builder, "");
                continue block0;
            }
            matcher.appendReplacement(builder, "$0");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String formatString(IUser user, String permBase, String message) {
        if (message == null) {
            return null;
        }
        EnumSet<ChatColor> supported = EnumSet.noneOf(ChatColor.class);
        if (user.isAuthorized(permBase + ".color")) {
            supported.addAll(COLORS);
        }
        if (user.isAuthorized(permBase + ".format")) {
            supported.addAll(FORMATS);
        }
        if (user.isAuthorized(permBase + ".magic")) {
            supported.addAll(MAGIC);
        }
        for (ChatColor chatColor : ChatColor.values()) {
            String node;
            String colorName = chatColor.name();
            if (chatColor == ChatColor.MAGIC) {
                colorName = "obfuscated";
            }
            if (!user.isPermissionSet(node = permBase + "." + colorName.toLowerCase(Locale.ROOT))) continue;
            if (user.isAuthorized(node)) {
                supported.add(chatColor);
                continue;
            }
            supported.remove(chatColor);
        }
        EnumSet<ChatColor> strip = EnumSet.complementOf(supported);
        if (!supported.isEmpty()) {
            message = FormatUtil.replaceColor(message, supported);
        }
        if (!strip.isEmpty()) {
            message = FormatUtil.stripColor(message, strip);
        }
        return message;
    }

    public static String stripLogColorFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(input, LOGCOLOR_PATTERN);
    }

    static String stripColor(String input, Pattern pattern) {
        return pattern.matcher(input).replaceAll("");
    }

    public static String lastCode(String input) {
        int pos = input.lastIndexOf(167);
        if (pos == -1 || pos + 1 == input.length()) {
            return "";
        }
        return input.substring(pos, pos + 2);
    }

    static String blockURL(String input) {
        if (input == null) {
            return null;
        }
        String text = URL_PATTERN.matcher(input).replaceAll("$1 $2");
        while (URL_PATTERN.matcher(text).find()) {
            text = URL_PATTERN.matcher(text).replaceAll("$1 $2");
        }
        return text;
    }

    public static boolean validIP(String ipAddress) {
        return IPPATTERN.matcher(ipAddress).matches();
    }
}

