/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.utils.MaterialUtil;
import java.util.Set;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class SignPlayerListener
implements Listener {
    private final transient IEssentials ess;

    public SignPlayerListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onSignPlayerInteract(PlayerInteractEvent event) {
        Block block;
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (event.isCancelled() && event.getAction() == Action.RIGHT_CLICK_AIR) {
            Block targetBlock;
            block11: {
                targetBlock = null;
                try {
                    targetBlock = event.getPlayer().getTargetBlock((Set)null, 5);
                }
                catch (IllegalStateException ex) {
                    if (!this.ess.getSettings().isDebug()) break block11;
                    this.ess.getLogger().log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            block = targetBlock;
        } else {
            block = event.getClickedBlock();
        }
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        if (MaterialUtil.isSign(mat)) {
            String csign = ((Sign)block.getState()).getLine(0);
            for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
                if (!csign.equalsIgnoreCase(sign.getSuccessName(this.ess))) continue;
                sign.onSignInteract(block, event.getPlayer(), this.ess);
                event.setCancelled(true);
                return;
            }
        } else {
            for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
                if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockInteract(block, event.getPlayer(), this.ess)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

