/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.perm.impl;

import com.earth2me.essentials.perm.impl.SuperpermsHandler;
import java.util.Arrays;
import java.util.List;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public abstract class AbstractVaultHandler
extends SuperpermsHandler {
    protected static Permission perms = null;
    protected static Chat chat = null;

    private boolean setupProviders() {
        try {
            Class.forName("net.milkbowl.vault.permission.Permission");
            Class.forName("net.milkbowl.vault.chat.Chat");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        RegisteredServiceProvider permsProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)permsProvider.getProvider();
        RegisteredServiceProvider chatProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
        chat = (Chat)chatProvider.getProvider();
        return perms != null && chat != null;
    }

    @Override
    public String getGroup(Player base) {
        return perms.getPrimaryGroup(base);
    }

    @Override
    public List<String> getGroups(Player base) {
        return Arrays.asList(perms.getPlayerGroups(base));
    }

    @Override
    public boolean inGroup(Player base, String group) {
        return perms.playerInGroup(base, group);
    }

    @Override
    public String getPrefix(Player base) {
        String playerPrefix = chat.getPlayerPrefix(base);
        if (playerPrefix == null) {
            String playerGroup = perms.getPrimaryGroup(base);
            return chat.getGroupPrefix(base.getWorld().getName(), playerGroup);
        }
        return playerPrefix;
    }

    @Override
    public String getSuffix(Player base) {
        String playerSuffix = chat.getPlayerSuffix(base);
        if (playerSuffix == null) {
            String playerGroup = perms.getPrimaryGroup(base);
            return chat.getGroupSuffix(base.getWorld().getName(), playerGroup);
        }
        return playerSuffix;
    }

    boolean canLoad() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        try {
            return this.setupProviders();
        }
        catch (Throwable t) {
            return false;
        }
    }
}

