/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.items;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.items.AbstractItemDb;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;

public class FlatItemDb
extends AbstractItemDb {
    protected static final Logger LOGGER = Logger.getLogger("Essentials");
    private static Gson gson = new Gson();
    private final transient Map<String, ItemData> items = new HashMap<String, ItemData>();
    private final transient Map<String, String> itemAliases = new HashMap<String, String>();
    private final transient Set<String> allAliases = new HashSet<String>();
    private transient ManagedFile file = null;

    public FlatItemDb(IEssentials ess) {
        super(ess);
    }

    @Override
    public void reloadConfig() {
        if (this.file == null) {
            this.file = new ManagedFile("items.json", this.ess);
        }
        this.rebuild();
        LOGGER.info(String.format("Loaded %s items from items.json.", this.listNames().size()));
    }

    private void rebuild() {
        this.reset();
        String json = this.file.getLines().stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining());
        this.loadJSON(String.join((CharSequence)"\n", json));
        this.ready = true;
    }

    private void reset() {
        this.ready = false;
        this.items.clear();
        this.itemAliases.clear();
        this.allAliases.clear();
    }

    private void loadJSON(String source) {
        JsonObject map = new JsonParser().parse(source).getAsJsonObject();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            boolean valid = false;
            if (element.isJsonObject()) {
                ItemData data = (ItemData)gson.fromJson(element, ItemData.class);
                this.items.put(key, data);
                valid = true;
            } else {
                try {
                    String target = element.getAsString();
                    this.itemAliases.put(key, target);
                    valid = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (valid) {
                this.allAliases.add(key);
                continue;
            }
            LOGGER.warning(String.format("Failed to add item: \"%s\": %s", key, element.toString()));
        }
    }

    @Override
    public ItemStack get(String id, boolean useResolvers) throws Exception {
        ItemStack resolved;
        if (useResolvers && (resolved = this.tryResolvers(id)) != null) {
            return resolved;
        }
        String[] split = (id = id.toLowerCase()).split(":");
        ItemData data = this.getByName(split[0]);
        if (data == null) {
            throw new Exception(I18n.tl("unknownItemName", id));
        }
        Material material = data.getMaterial();
        if (!material.isItem()) {
            throw new Exception(I18n.tl("unableToSpawnItem", id));
        }
        ItemStack stack = new ItemStack(material);
        stack.setAmount(material.getMaxStackSize());
        PotionData potionData = data.getPotionData();
        ItemMeta meta = stack.getItemMeta();
        if (potionData != null && meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionData(potionData);
        }
        if (split.length > 1 && meta instanceof Damageable) {
            Damageable damageMeta = (Damageable)meta;
            damageMeta.setDamage(Integer.parseInt(split[1]));
        }
        stack.setItemMeta(meta);
        EntityType entity = data.getEntity();
        if (entity != null && material.toString().contains("SPAWNER")) {
            this.ess.getSpawnerProvider().setEntityType(stack, entity);
        }
        return stack;
    }

    private ItemData getByName(String name) {
        if (this.items.containsKey(name = name.toLowerCase())) {
            return this.items.get(name);
        }
        if (this.itemAliases.containsKey(name)) {
            return this.items.get(this.itemAliases.get(name));
        }
        return null;
    }

    @Override
    public List<String> nameList(ItemStack item) {
        ArrayList<String> names = new ArrayList<String>();
        String primaryName = this.name(item);
        names.add(primaryName);
        for (Map.Entry<String, String> entry : this.itemAliases.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(primaryName)) continue;
            names.add(entry.getKey());
        }
        return names;
    }

    @Override
    public String name(ItemStack item) {
        ItemData data = this.lookup(item);
        for (Map.Entry<String, ItemData> entry : this.items.entrySet()) {
            if (!entry.getValue().equals(data)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    @Deprecated
    public int getLegacyId(Material material) {
        throw new UnsupportedOperationException("Legacy IDs aren't supported on this version.");
    }

    private ItemData lookup(ItemStack item) {
        Material type = item.getType();
        if (MaterialUtil.isPotion(type) && item.getItemMeta() instanceof PotionMeta) {
            PotionData potion = ((PotionMeta)item.getItemMeta()).getBasePotionData();
            return new ItemData(type, potion);
        }
        if (type.toString().contains("SPAWNER")) {
            EntityType entity = this.ess.getSpawnerProvider().getEntityType(item);
            return new ItemData(type, entity);
        }
        return new ItemData(type);
    }

    @Override
    public Collection<String> listNames() {
        HashSet<String> names = new HashSet<String>(this.allAliases);
        names.addAll(this.getResolverNames());
        return names;
    }

    public static class ItemData {
        private Material material;
        private String[] fallbacks = null;
        private PotionData potionData = null;
        private EntityType entity = null;

        ItemData(Material material) {
            this.material = material;
        }

        ItemData(Material material, PotionData potionData) {
            this.material = material;
            this.potionData = potionData;
        }

        ItemData(Material material, EntityType entity) {
            this.material = material;
            this.entity = entity;
        }

        public int hashCode() {
            return 31 * this.material.hashCode() ^ this.potionData.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ItemData)) {
                return false;
            }
            ItemData that = (ItemData)o;
            return this.getMaterial() == that.getMaterial() && this.potionDataEquals(that) && this.entityEquals(that);
        }

        public Material getMaterial() {
            if (this.material == null && this.fallbacks != null) {
                this.material = EnumUtil.getMaterial(this.fallbacks);
                this.fallbacks = null;
            }
            return this.material;
        }

        public PotionData getPotionData() {
            return this.potionData;
        }

        public EntityType getEntity() {
            return this.entity;
        }

        private boolean potionDataEquals(ItemData o) {
            if (this.potionData == null && o.getPotionData() == null) {
                return true;
            }
            if (this.potionData != null && o.getPotionData() != null) {
                return this.potionData.equals((Object)o.getPotionData());
            }
            return false;
        }

        private boolean entityEquals(ItemData o) {
            if (this.entity == null && o.getEntity() == null) {
                return true;
            }
            if (this.entity != null && o.getEntity() != null) {
                return this.entity.equals((Object)o.getEntity());
            }
            return false;
        }
    }
}

