/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FloatUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtppos
extends EssentialsCommand {
    public Commandtppos() {
        super("tppos");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        World w;
        double y;
        double x;
        if (args.length < 3) {
            throw new NotEnoughArgumentsException();
        }
        double d = args[0].startsWith("~") ? user.getLocation().getX() + (double)(args[0].length() > 1 ? Integer.parseInt(args[0].substring(1)) : 0) : (x = (double)Integer.parseInt(args[0]));
        double d2 = args[1].startsWith("~") ? user.getLocation().getY() + (double)(args[1].length() > 1 ? Integer.parseInt(args[1].substring(1)) : 0) : (y = (double)Integer.parseInt(args[1]));
        double z = args[2].startsWith("~") ? user.getLocation().getZ() + (double)(args[2].length() > 1 ? Integer.parseInt(args[2].substring(1)) : 0) : (double)Integer.parseInt(args[2]);
        Location loc = new Location(user.getWorld(), x, y, z, user.getLocation().getYaw(), user.getLocation().getPitch());
        if (args.length == 4) {
            w = this.ess.getWorld(args[3]);
            if (user.getWorld() != w && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + w.getName())) {
                throw new Exception(I18n.tl("noPerm", "essentials.worlds." + w.getName()));
            }
            loc.setWorld(w);
        }
        if (args.length > 4) {
            loc.setYaw((FloatUtil.parseFloat(args[3]) + 360.0f) % 360.0f);
            loc.setPitch(FloatUtil.parseFloat(args[4]));
        }
        if (args.length > 5) {
            w = this.ess.getWorld(args[5]);
            if (user.getWorld() != w && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + w.getName())) {
                throw new Exception(I18n.tl("noPerm", "essentials.worlds." + w.getName()));
            }
            loc.setWorld(w);
        }
        if (x > 3.0E7 || y > 3.0E7 || z > 3.0E7 || x < -3.0E7 || y < -3.0E7 || z < -3.0E7) {
            throw new NotEnoughArgumentsException(I18n.tl("teleportInvalidLocation", new Object[0]));
        }
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor(user);
        user.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        user.getTeleport().teleport(loc, charge, PlayerTeleportEvent.TeleportCause.COMMAND);
        throw new NoChargeException();
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        double y;
        double x;
        if (args.length < 4) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, args, 0, true, false);
        double d = args[1].startsWith("~") ? user.getLocation().getX() + (double)(args[1].length() > 1 ? Integer.parseInt(args[1].substring(1)) : 0) : (x = (double)Integer.parseInt(args[1]));
        double d2 = args[2].startsWith("~") ? user.getLocation().getY() + (double)(args[2].length() > 1 ? Integer.parseInt(args[2].substring(1)) : 0) : (y = (double)Integer.parseInt(args[2]));
        double z = args[3].startsWith("~") ? user.getLocation().getZ() + (double)(args[3].length() > 1 ? Integer.parseInt(args[3].substring(1)) : 0) : (double)Integer.parseInt(args[3]);
        Location loc = new Location(user.getWorld(), x, y, z, user.getLocation().getYaw(), user.getLocation().getPitch());
        if (args.length == 5) {
            loc.setWorld(this.ess.getWorld(args[4]));
        }
        if (args.length > 5) {
            loc.setYaw((FloatUtil.parseFloat(args[4]) + 360.0f) % 360.0f);
            loc.setPitch(FloatUtil.parseFloat(args[5]));
        }
        if (args.length > 6) {
            loc.setWorld(this.ess.getWorld(args[6]));
        }
        if (x > 3.0E7 || y > 3.0E7 || z > 3.0E7 || x < -3.0E7 || y < -3.0E7 || z < -3.0E7) {
            throw new NotEnoughArgumentsException(I18n.tl("teleportInvalidLocation", new Object[0]));
        }
        sender.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        user.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        user.getTeleport().teleport(loc, null, PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1 || args.length == 2 || args.length == 3) {
            return Lists.newArrayList((Object[])new String[]{"~0"});
        }
        if (args.length == 4 || args.length == 5) {
            return Lists.newArrayList((Object[])new String[]{"0"});
        }
        if (args.length == 6) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                worlds.add(world.getName());
            }
            return worlds;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2 || args.length == 3 || args.length == 4) {
            return Lists.newArrayList((Object[])new String[]{"~0"});
        }
        if (args.length == 5 || args.length == 6) {
            return Lists.newArrayList((Object[])new String[]{"0"});
        }
        if (args.length == 7) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                worlds.add(world.getName());
            }
            return worlds;
        }
        return Collections.emptyList();
    }
}

