/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpall
extends EssentialsCommand {
    public Commandtpall() {
        super("tpall");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            if (sender.isPlayer()) {
                this.teleportAllPlayers(server, sender, this.ess.getUser(sender.getPlayer()));
                return;
            }
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, sender, args, 0);
        this.teleportAllPlayers(server, sender, target);
    }

    private void teleportAllPlayers(Server server, CommandSource sender, User target) {
        sender.sendMessage(I18n.tl("teleportAll", new Object[0]));
        Location loc = target.getLocation();
        for (User player : this.ess.getOnlineUsers()) {
            if (target == player || sender.equals(target.getBase()) && target.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !target.isAuthorized("essentials.worlds." + target.getWorld().getName())) continue;
            try {
                player.getTeleport().now(loc, false, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
            catch (Exception ex) {
                this.ess.showError(sender, ex, this.getName());
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

