/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import net.ess3.api.IUser;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpaccept
extends EssentialsCommand {
    public Commandtpaccept() {
        super("tpaccept");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        User requester;
        try {
            requester = this.ess.getUser(user.getTeleportRequest());
        }
        catch (Exception ex) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (!requester.getBase().isOnline()) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (user.isTpRequestHere() && (!requester.isAuthorized("essentials.tpahere") && !requester.isAuthorized("essentials.tpaall") || user.getWorld() != requester.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + user.getWorld().getName()))) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (!user.isTpRequestHere() && (!requester.isAuthorized("essentials.tpa") || user.getWorld() != requester.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + requester.getWorld().getName()))) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (args.length > 0 && !requester.getName().contains(args[0])) {
            throw new Exception(I18n.tl("noPendingRequest", new Object[0]));
        }
        if (!user.hasOutstandingTeleportRequest()) {
            user.requestTeleport(null, false);
            throw new Exception(I18n.tl("requestTimedOut", new Object[0]));
        }
        Trade charge = new Trade(this.getName(), this.ess);
        user.sendMessage(I18n.tl("requestAccepted", new Object[0]));
        requester.sendMessage(I18n.tl("requestAcceptedFrom", user.getDisplayName()));
        try {
            if (user.isTpRequestHere()) {
                Location loc = user.getTpRequestLocation();
                Teleport teleport = requester.getTeleport();
                teleport.setTpType(Teleport.TeleportType.TPA);
                teleport.teleportPlayer((IUser)user, user.getTpRequestLocation(), charge, PlayerTeleportEvent.TeleportCause.COMMAND);
                requester.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            } else {
                Teleport teleport = requester.getTeleport();
                teleport.setTpType(Teleport.TeleportType.TPA);
                teleport.teleport(user.getBase(), charge, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
        }
        catch (Exception ex) {
            user.sendMessage(I18n.tl("pendingTeleportCancelled", new Object[0]));
            this.ess.showError(requester.getSource(), ex, commandLabel);
        }
        user.requestTeleport(null, false);
        throw new NoChargeException();
    }
}

