/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import net.ess3.api.events.TPARequestEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandtpaall
extends EssentialsCommand {
    public Commandtpaall() {
        super("tpaall");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            if (sender.isPlayer()) {
                this.teleportAAllPlayers(server, sender, this.ess.getUser(sender.getPlayer()));
                return;
            }
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, sender, args, 0);
        this.teleportAAllPlayers(server, sender, target);
    }

    private void teleportAAllPlayers(Server server, CommandSource sender, User target) {
        sender.sendMessage(I18n.tl("teleportAAll", new Object[0]));
        for (User player : this.ess.getOnlineUsers()) {
            if (target == player || !player.isTeleportEnabled() || sender.equals(target.getBase()) && target.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !target.isAuthorized("essentials.worlds." + target.getWorld().getName())) continue;
            try {
                TPARequestEvent tpaEvent = new TPARequestEvent(sender, player, true);
                this.ess.getServer().getPluginManager().callEvent((Event)tpaEvent);
                if (tpaEvent.isCancelled()) {
                    sender.sendMessage(I18n.tl("teleportRequestCancelled", player.getDisplayName()));
                    continue;
                }
                player.requestTeleport(target, true);
                player.sendMessage(I18n.tl("teleportHereRequest", target.getDisplayName()));
                player.sendMessage(I18n.tl("typeTpaccept", new Object[0]));
                if (this.ess.getSettings().getTpaAcceptCancellation() == 0L) continue;
                player.sendMessage(I18n.tl("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation()));
            }
            catch (Exception ex) {
                this.ess.showError(sender, ex, this.getName());
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

