/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import net.ess3.api.events.TPARequestEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpa
extends EssentialsCommand {
    public Commandtpa() {
        super("tpa");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User player = this.getPlayer(server, user, args, 0);
        if (user.getName().equalsIgnoreCase(player.getName())) {
            throw new NotEnoughArgumentsException();
        }
        if (!player.isTeleportEnabled()) {
            throw new Exception(I18n.tl("teleportDisabled", player.getDisplayName()));
        }
        if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + player.getWorld().getName())) {
            throw new Exception(I18n.tl("noPerm", "essentials.worlds." + player.getWorld().getName()));
        }
        if (user.getConfigUUID().equals(player.getTeleportRequest()) && player.hasOutstandingTeleportRequest() && !player.isTpRequestHere()) {
            throw new Exception(I18n.tl("requestSentAlready", player.getDisplayName()));
        }
        if (player.isAutoTeleportEnabled() && !player.isIgnoredPlayer(user)) {
            Trade charge = new Trade(this.getName(), this.ess);
            Teleport teleport = user.getTeleport();
            teleport.setTpType(Teleport.TeleportType.TPA);
            teleport.teleport(player.getBase(), charge, PlayerTeleportEvent.TeleportCause.COMMAND);
            player.sendMessage(I18n.tl("requestAcceptedAuto", user.getDisplayName()));
            user.sendMessage(I18n.tl("requestAcceptedFromAuto", player.getDisplayName()));
            return;
        }
        if (!player.isIgnoredPlayer(user)) {
            TPARequestEvent tpaEvent = new TPARequestEvent(user.getSource(), player, false);
            this.ess.getServer().getPluginManager().callEvent((Event)tpaEvent);
            if (tpaEvent.isCancelled()) {
                throw new Exception(I18n.tl("teleportRequestCancelled", player.getDisplayName()));
            }
            player.requestTeleport(user, false);
            player.sendMessage(I18n.tl("teleportRequest", user.getDisplayName()));
            player.sendMessage(I18n.tl("typeTpaccept", new Object[0]));
            player.sendMessage(I18n.tl("typeTpdeny", new Object[0]));
            if (this.ess.getSettings().getTpaAcceptCancellation() != 0L) {
                player.sendMessage(I18n.tl("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation()));
            }
        }
        user.sendMessage(I18n.tl("requestSent", player.getDisplayName()));
        if (user.isAuthorized("essentials.tpacancel")) {
            user.sendMessage(I18n.tl("typeTpacancel", new Object[0]));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

