/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.WorldNameComparator;
import com.earth2me.essentials.utils.DescParseTickFormat;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Server;
import org.bukkit.World;

public class Commandtime
extends EssentialsCommand {
    public Commandtime() {
        super("time");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        long ticks;
        String setTime;
        boolean add = false;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.remove("set") && !argList.isEmpty() && NumberUtil.isInt((String)argList.get(0))) {
            argList.set(0, (String)argList.get(0) + "t");
        }
        if (argList.remove("add") && !argList.isEmpty() && NumberUtil.isInt((String)argList.get(0))) {
            add = true;
            argList.set(0, (String)argList.get(0) + "t");
        }
        String[] validArgs = argList.toArray(new String[argList.size()]);
        String worldSelector = null;
        if (validArgs.length == 2) {
            worldSelector = validArgs[1];
        }
        Set<World> worlds = this.getWorlds(server, sender, worldSelector);
        if (validArgs.length == 0) {
            if (commandLabel.equalsIgnoreCase("day") || commandLabel.equalsIgnoreCase("eday")) {
                setTime = "day";
            } else {
                if (!commandLabel.equalsIgnoreCase("night") && !commandLabel.equalsIgnoreCase("enight")) {
                    this.getWorldsTime(sender, worlds);
                    throw new NoChargeException();
                }
                setTime = "night";
            }
        } else {
            setTime = validArgs[0];
        }
        User user = this.ess.getUser(sender.getPlayer());
        if (user != null && !user.isAuthorized("essentials.time.set")) {
            throw new Exception(I18n.tl("timeSetPermission", new Object[0]));
        }
        try {
            ticks = DescParseTickFormat.parse(setTime);
        }
        catch (NumberFormatException e) {
            throw new NotEnoughArgumentsException(e);
        }
        this.setWorldsTime(sender, worlds, ticks, add);
    }

    private void getWorldsTime(CommandSource sender, Collection<World> worlds) {
        if (worlds.size() == 1) {
            Iterator<World> iter = worlds.iterator();
            sender.sendMessage(DescParseTickFormat.format(iter.next().getTime()));
            return;
        }
        for (World world : worlds) {
            sender.sendMessage(I18n.tl("timeWorldCurrent", world.getName(), DescParseTickFormat.format(world.getTime())));
        }
    }

    private void setWorldsTime(CommandSource sender, Collection<World> worlds, long ticks, boolean add) throws Exception {
        User user = this.ess.getUser(sender.getPlayer());
        for (World world : worlds) {
            if (this.canUpdateWorld(user, world)) continue;
            throw new Exception(I18n.tl("timeSetWorldPermission", user.getWorld().getName()));
        }
        for (World world : worlds) {
            long time = world.getTime();
            if (!add) {
                time -= time % 24000L;
            }
            world.setTime(time + (long)(add ? 0 : 24000) + ticks);
        }
        StringBuilder output = new StringBuilder();
        for (World world : worlds) {
            if (output.length() > 0) {
                output.append(", ");
            }
            output.append(world.getName());
        }
        sender.sendMessage(I18n.tl("timeWorldSet", DescParseTickFormat.format(ticks), output.toString()));
    }

    private Set<World> getWorlds(Server server, CommandSource sender, String selector) throws Exception {
        TreeSet<World> worlds = new TreeSet<World>(new WorldNameComparator());
        if (selector == null) {
            if (sender.isPlayer()) {
                User user = this.ess.getUser(sender.getPlayer());
                worlds.add(user.getWorld());
            } else {
                worlds.addAll(server.getWorlds());
            }
            return worlds;
        }
        World world = server.getWorld(selector);
        if (world != null) {
            worlds.add(world);
        } else if (selector.equalsIgnoreCase("*") || selector.equalsIgnoreCase("all")) {
            worlds.addAll(server.getWorlds());
        } else {
            throw new Exception(I18n.tl("invalidWorld", new Object[0]));
        }
        return worlds;
    }

    private boolean canUpdateAll(User user) {
        return !this.ess.getSettings().isWorldTimePermissions() || user == null || user.isAuthorized("essentials.time.world.all");
    }

    private boolean canUpdateWorld(User user, World world) {
        return this.canUpdateAll(user) || user.isAuthorized("essentials.time.world." + this.normalizeWorldName(world));
    }

    private String normalizeWorldName(World world) {
        return world.getName().toLowerCase().replaceAll("\\s+", "_");
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        User user = this.ess.getUser(sender.getPlayer());
        if (args.length == 1) {
            if (user == null || user.isAuthorized("essentials.time.set")) {
                return Lists.newArrayList((Object[])new String[]{"set", "add"});
            }
            return Collections.emptyList();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            return Lists.newArrayList((Object[])new String[]{"sunrise", "day", "morning", "noon", "afternoon", "sunset", "night", "midnight"});
        }
        if (args.length == 3 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("add"))) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                if (user != null && !user.isAuthorized("essentials.time.world." + this.normalizeWorldName(world))) continue;
                worlds.add(world.getName());
            }
            if (user == null || user.isAuthorized("essentials.time.world.all")) {
                worlds.add("*");
            }
            return worlds;
        }
        return Collections.emptyList();
    }
}

