/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.StringUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.IUser;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandrepair
extends EssentialsCommand {
    public Commandrepair() {
        super("repair");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1 || args[0].equalsIgnoreCase("hand") || !user.isAuthorized("essentials.repair.all")) {
            this.repairHand(user);
        } else if (args[0].equalsIgnoreCase("all")) {
            Trade charge = new Trade("repair-all", this.ess);
            charge.isAffordableFor(user);
            this.repairAll(user);
            charge.charge(user);
        } else {
            throw new NotEnoughArgumentsException();
        }
    }

    public void repairHand(User user) throws Exception {
        ItemStack item = user.getItemInHand();
        if (item == null || item.getType().isBlock() || item.getDurability() == 0) {
            throw new Exception(I18n.tl("repairInvalidType", new Object[0]));
        }
        if (!(item.getEnchantments().isEmpty() || this.ess.getSettings().getRepairEnchanted() || user.isAuthorized("essentials.repair.enchanted"))) {
            throw new Exception(I18n.tl("repairEnchanted", new Object[0]));
        }
        String itemName = item.getType().toString().toLowerCase(Locale.ENGLISH);
        Trade charge = this.getCharge(item.getType());
        charge.isAffordableFor(user);
        this.repairItem(item);
        charge.charge(user);
        user.getBase().updateInventory();
        user.sendMessage(I18n.tl("repair", itemName.replace('_', ' ')));
    }

    public void repairAll(User user) throws Exception {
        ArrayList<String> repaired = new ArrayList<String>();
        this.repairItems(user.getBase().getInventory().getContents(), user, repaired);
        if (user.isAuthorized("essentials.repair.armor")) {
            this.repairItems(user.getBase().getInventory().getArmorContents(), user, repaired);
        }
        user.getBase().updateInventory();
        if (repaired.isEmpty()) {
            throw new Exception(I18n.tl("repairNone", new Object[0]));
        }
        user.sendMessage(I18n.tl("repair", StringUtil.joinList(repaired)));
    }

    private void repairItem(ItemStack item) throws Exception {
        Material material = item.getType();
        if (material.isBlock() || material.getMaxDurability() < 1) {
            throw new Exception(I18n.tl("repairInvalidType", new Object[0]));
        }
        if (item.getDurability() == 0) {
            throw new Exception(I18n.tl("repairAlreadyFixed", new Object[0]));
        }
        item.setDurability((short)0);
    }

    private void repairItems(ItemStack[] items, IUser user, List<String> repaired) throws Exception {
        for (ItemStack item : items) {
            if (item == null || item.getType().isBlock() || item.getDurability() == 0) continue;
            String itemName = item.getType().toString().toLowerCase(Locale.ENGLISH);
            Trade charge = this.getCharge(item.getType());
            try {
                charge.isAffordableFor(user);
            }
            catch (ChargeException ex) {
                user.sendMessage(ex.getMessage());
                continue;
            }
            if (!item.getEnchantments().isEmpty() && !this.ess.getSettings().getRepairEnchanted() && !user.isAuthorized("essentials.repair.enchanted")) continue;
            try {
                this.repairItem(item);
            }
            catch (Exception e) {
                continue;
            }
            try {
                charge.charge(user);
            }
            catch (ChargeException ex) {
                user.sendMessage(ex.getMessage());
            }
            repaired.add(itemName.replace('_', ' '));
        }
    }

    private Trade getCharge(Material material) {
        String itemName = material.toString().toLowerCase(Locale.ENGLISH);
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
            int itemId = material.getId();
            return new Trade("repair-" + itemName.replace('_', '-'), new Trade("repair-" + itemId, new Trade("repair-item", this.ess), this.ess), this.ess);
        }
        return new Trade("repair-" + itemName.replace('_', '-'), new Trade("repair-item", this.ess), this.ess);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"hand"});
            if (user.isAuthorized("essentials.repair.all")) {
                options.add("all");
            }
            return options;
        }
        return Collections.emptyList();
    }
}

