/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandpowertool
extends EssentialsCommand {
    public Commandpowertool() {
        super("powertool");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        String command = Commandpowertool.getFinalArg(args, 0);
        ItemStack itemStack = user.getBase().getItemInHand();
        this.powertool(server, user.getSource(), user, commandLabel, itemStack, command);
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 3) {
            throw new Exception("When running from console, usage is: /" + commandLabel + " <player> <itemid> <command>");
        }
        User user = this.getPlayer(server, args, 0, true, true);
        ItemStack itemStack = this.ess.getItemDb().get(args[1]);
        String command = Commandpowertool.getFinalArg(args, 2);
        this.powertool(server, sender, user, commandLabel, itemStack, command);
    }

    protected void powertool(Server server, CommandSource sender, User user, String commandLabel, ItemStack itemStack, String command) throws Exception {
        if (command != null && command.equalsIgnoreCase("d:")) {
            user.clearAllPowertools();
            sender.sendMessage(I18n.tl("powerToolClearAll", new Object[0]));
            return;
        }
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new Exception(I18n.tl("powerToolAir", new Object[0]));
        }
        String itemName = itemStack.getType().toString().toLowerCase(Locale.ENGLISH).replaceAll("_", " ");
        List<String> powertools = user.getPowertool(itemStack);
        if (command != null && !command.isEmpty()) {
            if (command.equalsIgnoreCase("l:")) {
                if (powertools == null || powertools.isEmpty()) {
                    throw new Exception(I18n.tl("powerToolListEmpty", itemName));
                }
                sender.sendMessage(I18n.tl("powerToolList", StringUtil.joinList(powertools), itemName));
                throw new NoChargeException();
            }
            if (command.startsWith("r:")) {
                if (!powertools.contains(command = command.substring(2))) {
                    throw new Exception(I18n.tl("powerToolNoSuchCommandAssigned", command, itemName));
                }
                powertools.remove(command);
                sender.sendMessage(I18n.tl("powerToolRemove", command, itemName));
            } else {
                if (command.startsWith("a:")) {
                    if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.powertool.append")) {
                        throw new Exception(I18n.tl("noPerm", "essentials.powertool.append"));
                    }
                    if (powertools.contains(command = command.substring(2))) {
                        throw new Exception(I18n.tl("powerToolAlreadySet", command, itemName));
                    }
                } else if (powertools != null && !powertools.isEmpty()) {
                    powertools.clear();
                } else {
                    powertools = new ArrayList<String>();
                }
                powertools.add(command);
                sender.sendMessage(I18n.tl("powerToolAttach", StringUtil.joinList(powertools), itemName));
            }
        } else {
            if (powertools != null) {
                powertools.clear();
            }
            sender.sendMessage(I18n.tl("powerToolRemoveAll", itemName));
        }
        if (!user.arePowerToolsEnabled()) {
            user.setPowerToolsEnabled(true);
            user.sendMessage(I18n.tl("powerToolsEnabled", new Object[0]));
        }
        user.setPowertool(itemStack, powertools);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"d:", "c:", "l:"});
            if (user.isAuthorized("essentials.powertool.append")) {
                for (String command : this.getCommands(server)) {
                    options.add("a:" + command);
                }
            }
            try {
                ItemStack itemStack = user.getBase().getItemInHand();
                List<String> powertools = user.getPowertool(itemStack);
                for (String tool : powertools) {
                    options.add("r:" + tool);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
        if (args[0].startsWith("a:")) {
            return this.tabCompleteCommand(user.getSource(), server, args[0].substring(2), args, 1);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return this.getItems();
        }
        if (args.length == 3) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"d:", "c:", "l:"});
            for (String command : this.getCommands(server)) {
                options.add("a:" + command);
            }
            try {
                User user = this.getPlayer(server, args, 0, true, true);
                ItemStack itemStack = this.ess.getItemDb().get(args[1]);
                List<String> powertools = user.getPowertool(itemStack);
                for (String tool : powertools) {
                    options.add("r:" + tool);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
        if (args[2].startsWith("a:")) {
            return this.tabCompleteCommand(sender, server, args[2].substring(2), args, 3);
        }
        return Collections.emptyList();
    }
}

