/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Server;

public class Commandpay
extends EssentialsLoopCommand {
    BigDecimal amount;
    boolean informToConfirm;

    public Commandpay() {
        super("pay");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.informToConfirm = false;
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        if (args[1].contains("-")) {
            throw new Exception(I18n.tl("payMustBePositive", new Object[0]));
        }
        String stringAmount = args[1].replaceAll("[^0-9\\.]", "");
        if (stringAmount.length() < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.amount = new BigDecimal(stringAmount);
        if (this.amount.compareTo(this.ess.getSettings().getMinimumPayAmount()) < 0) {
            throw new Exception(I18n.tl("minimumPayAmount", NumberUtil.displayCurrencyExactly(this.ess.getSettings().getMinimumPayAmount(), this.ess)));
        }
        this.loopOnlinePlayers(server, user.getSource(), false, user.isAuthorized("essentials.pay.multiple"), args[0], args);
        if (this.informToConfirm) {
            String cmd = "/" + commandLabel + " " + StringUtil.joinList(" ", (Object[])args);
            user.sendMessage(I18n.tl("confirmPayment", NumberUtil.displayCurrency(this.amount, this.ess), cmd));
        }
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User player, String[] args) throws ChargeException {
        User user = this.ess.getUser(sender.getPlayer());
        try {
            if (!player.isAcceptingPay()) {
                sender.sendMessage(I18n.tl("notAcceptingPay", player.getDisplayName()));
                return;
            }
            if (user.isPromptingPayConfirm() && !this.amount.equals(user.getConfirmingPayments().get(player))) {
                if (!this.informToConfirm) {
                    user.getConfirmingPayments().clear();
                    this.informToConfirm = true;
                }
                user.getConfirmingPayments().put(player, this.amount);
                return;
            }
            user.payUser(player, this.amount);
            user.getConfirmingPayments().remove(player);
            Trade.log("Command", "Pay", "Player", user.getName(), new Trade(this.amount, this.ess), player.getName(), new Trade(this.amount, this.ess), user.getLocation(), this.ess);
        }
        catch (MaxMoneyException ex) {
            sender.sendMessage(I18n.tl("maxMoney", new Object[0]));
            try {
                user.setMoney(user.getMoney().add(this.amount));
            }
            catch (MaxMoneyException maxMoneyException) {}
        }
        catch (Exception e) {
            sender.sendMessage(e.getMessage());
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{this.ess.getSettings().getMinimumPayAmount().toString()});
        }
        return Collections.emptyList();
    }
}

