/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Server;

public class Commandmail
extends EssentialsCommand {
    private static int mailsPerMinute = 0;
    private static long timestamp = 0L;

    public Commandmail() {
        super("mail");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length >= 1 && "read".equalsIgnoreCase(args[0])) {
            List<String> mail = user.getMails();
            if (mail.isEmpty()) {
                user.sendMessage(I18n.tl("noMail", new Object[0]));
                throw new NoChargeException();
            }
            SimpleTextInput input = new SimpleTextInput(mail);
            TextPager pager = new TextPager(input);
            pager.showPage(args.length > 1 ? args[1] : null, null, commandLabel + " " + args[0], user.getSource());
            user.sendMessage(I18n.tl("mailClear", new Object[0]));
            return;
        }
        if (args.length >= 3 && "send".equalsIgnoreCase(args[0])) {
            if (!user.isAuthorized("essentials.mail.send")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.send"));
            }
            if (user.isMuted()) {
                throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            }
            User u = this.getPlayer(server, args[1], true, true);
            if (u == null) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            String mail = I18n.tl("mailFormat", user.getName(), FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 2)))));
            if (mail.length() > 1000) {
                throw new Exception(I18n.tl("mailTooLong", new Object[0]));
            }
            if (!u.isIgnoredPlayer(user)) {
                if (Math.abs(System.currentTimeMillis() - timestamp) > 60000L) {
                    timestamp = System.currentTimeMillis();
                    mailsPerMinute = 0;
                }
                if (++mailsPerMinute > this.ess.getSettings().getMailsPerMinute()) {
                    throw new Exception(I18n.tl("mailDelay", this.ess.getSettings().getMailsPerMinute()));
                }
                u.addMail(I18n.tl("mailMessage", mail));
            }
            user.sendMessage(I18n.tl("mailSentTo", u.getDisplayName(), u.getName()));
            user.sendMessage(mail);
            return;
        }
        if (args.length > 1 && "sendall".equalsIgnoreCase(args[0])) {
            if (!user.isAuthorized("essentials.mail.sendall")) {
                throw new Exception(I18n.tl("noPerm", "essentials.mail.sendall"));
            }
            this.ess.runTaskAsynchronously(new SendAll(I18n.tl("mailFormat", user.getName(), FormatUtil.formatMessage(user, "essentials.mail", StringUtil.sanitizeString(FormatUtil.stripFormat(Commandmail.getFinalArg(args, 1)))))));
            user.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 1 && "clear".equalsIgnoreCase(args[0])) {
            if (user.getMails() == null || user.getMails().isEmpty()) {
                user.sendMessage(I18n.tl("noMail", new Object[0]));
                throw new NoChargeException();
            }
            user.setMails(null);
            user.sendMessage(I18n.tl("mailCleared", new Object[0]));
            return;
        }
        throw new NotEnoughArgumentsException();
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length >= 1 && "read".equalsIgnoreCase(args[0])) {
            throw new Exception(I18n.tl("onlyPlayers", commandLabel + " read"));
        }
        if (args.length >= 1 && "clear".equalsIgnoreCase(args[0])) {
            throw new Exception(I18n.tl("onlyPlayers", commandLabel + " clear"));
        }
        if (args.length >= 3 && "send".equalsIgnoreCase(args[0])) {
            User u = this.getPlayer(server, args[1], true, true);
            if (u == null) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[1]));
            }
            u.addMail(I18n.tl("mailFormat", "Server", FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 2))));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 2 && "sendall".equalsIgnoreCase(args[0])) {
            this.ess.runTaskAsynchronously(new SendAll(I18n.tl("mailFormat", "Server", FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 1)))));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        if (args.length >= 2) {
            User u = this.getPlayer(server, args[0], true, true);
            if (u == null) {
                throw new Exception(I18n.tl("playerNeverOnServer", args[0]));
            }
            u.addMail(I18n.tl("mailFormat", "Server", FormatUtil.replaceFormat(Commandmail.getFinalArg(args, 1))));
            sender.sendMessage(I18n.tl("mailSent", new Object[0]));
            return;
        }
        throw new NotEnoughArgumentsException();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"read", "clear"});
            if (user.isAuthorized("essentials.mail.send")) {
                options.add("send");
            }
            if (user.isAuthorized("essentials.mail.sendall")) {
                options.add("sendall");
            }
            return options;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("send") && user.isAuthorized("essentials.mail.send")) {
            return this.getPlayers(server, user);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("read")) {
            List<String> mail = user.getMails();
            int pages = mail.size() / 9 + (mail.size() % 9 > 0 ? 1 : 0);
            if (pages == 0) {
                return Lists.newArrayList((Object[])new String[]{"0"});
            }
            ArrayList options = Lists.newArrayList((Object[])new String[]{"1"});
            if (pages > 1) {
                options.add(String.valueOf(pages));
            }
            return options;
        }
        if (args.length > 2 && args[0].equalsIgnoreCase("send") && user.isAuthorized("essentials.mail.send") || args.length > 1 && args[0].equalsIgnoreCase("sendall") && user.isAuthorized("essentials.mail.sendall")) {
            return null;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"send", "sendall"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("send")) {
            return this.getPlayers(server, sender);
        }
        if (args.length > 2 && args[0].equalsIgnoreCase("send") || args.length > 1 && args[0].equalsIgnoreCase("sendall")) {
            return null;
        }
        return Collections.emptyList();
    }

    private class SendAll
    implements Runnable {
        String message;

        public SendAll(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            for (UUID userid : Commandmail.this.ess.getUserMap().getAllUniqueUsers()) {
                User user = Commandmail.this.ess.getUserMap().getUser(userid);
                if (user == null) continue;
                user.addMail(this.message);
            }
        }
    }
}

