/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;

public class Commandlightning
extends EssentialsLoopCommand {
    int power = 5;

    public Commandlightning() {
        super("lightning");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (sender.isPlayer()) {
            User user = this.ess.getUser(sender.getPlayer());
            if (args.length < 1 || user != null && !user.isAuthorized("essentials.lightning.others")) {
                user.getWorld().strikeLightning(user.getBase().getTargetBlock((Set)null, 600).getLocation());
                return;
            }
        }
        if (args.length > 1) {
            try {
                this.power = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.loopOnlinePlayers(server, sender, true, true, args[0], null);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User matchUser, String[] args) {
        sender.sendMessage(I18n.tl("lightningUse", matchUser.getDisplayName()));
        LightningStrike strike = matchUser.getBase().getWorld().strikeLightningEffect(matchUser.getBase().getLocation());
        if (!matchUser.isGodModeEnabled()) {
            matchUser.getBase().damage((double)this.power, (Entity)strike);
        }
        if (this.ess.getSettings().warnOnSmite()) {
            matchUser.sendMessage(I18n.tl("lightningSmited", new Object[0]));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (!user.isAuthorized("essentials.lightning.others")) {
            return Collections.emptyList();
        }
        return super.getTabCompleteOptions(server, user, commandLabel, args);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{Integer.toString(this.power)});
        }
        return Collections.emptyList();
    }
}

