/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.InventoryWorkaround;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Commanditem
extends EssentialsCommand {
    public Commanditem() {
        super("item");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        ItemStack stack = this.ess.getItemDb().get(args[0]);
        String itemname = stack.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        if (!user.canSpawnItem(stack.getType()).booleanValue()) {
            throw new Exception(I18n.tl("cantSpawnItem", itemname));
        }
        try {
            if (args.length > 1 && Integer.parseInt(args[1]) > 0) {
                stack.setAmount(Integer.parseInt(args[1]));
            } else if (this.ess.getSettings().getDefaultStackSize() > 0) {
                stack.setAmount(this.ess.getSettings().getDefaultStackSize());
            } else if (this.ess.getSettings().getOversizedStackSize() > 0 && user.isAuthorized("essentials.oversizedstacks")) {
                stack.setAmount(this.ess.getSettings().getOversizedStackSize());
            }
        }
        catch (NumberFormatException e) {
            throw new NotEnoughArgumentsException();
        }
        MetaItemStack metaStack = new MetaItemStack(stack);
        if (!metaStack.canSpawn(this.ess)) {
            throw new Exception(I18n.tl("unableToSpawnItem", itemname));
        }
        if (args.length > 2) {
            boolean allowUnsafe = this.ess.getSettings().allowUnsafeEnchantments() && user.isAuthorized("essentials.enchantments.allowunsafe");
            metaStack.parseStringMeta(user.getSource(), allowUnsafe, args, 2, this.ess);
            stack = metaStack.getItemStack();
        }
        if (stack.getType() == Material.AIR) {
            throw new Exception(I18n.tl("cantSpawnItem", "Air"));
        }
        String displayName = stack.getType().toString().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        user.sendMessage(I18n.tl("itemSpawn", stack.getAmount(), displayName));
        if (user.isAuthorized("essentials.oversizedstacks")) {
            InventoryWorkaround.addOversizedItems((Inventory)user.getBase().getInventory(), this.ess.getSettings().getOversizedStackSize(), stack);
        } else {
            InventoryWorkaround.addItems((Inventory)user.getBase().getInventory(), stack);
        }
        user.getBase().updateInventory();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getItems();
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "64"});
        }
        if (args.length == 3) {
            return Lists.newArrayList((Object[])new String[]{"0"});
        }
        return Collections.emptyList();
    }
}

