/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Server;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class Commandfirework
extends EssentialsCommand {
    public Commandfirework() {
        super("firework");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ItemStack stack = user.getItemInHand();
        if (!MaterialUtil.isFirework(stack.getType())) throw new Exception(I18n.tl("holdFirework", new Object[0]));
        if (args.length <= 0) throw new NotEnoughArgumentsException();
        if (args[0].equalsIgnoreCase("clear")) {
            FireworkMeta fmeta = (FireworkMeta)stack.getItemMeta();
            fmeta.clearEffects();
            stack.setItemMeta((ItemMeta)fmeta);
            user.sendMessage(I18n.tl("fireworkEffectsCleared", new Object[0]));
            return;
        }
        if (args.length > 1 && (args[0].equalsIgnoreCase("power") || args[0].equalsIgnoreCase("p"))) {
            FireworkMeta fmeta = (FireworkMeta)stack.getItemMeta();
            try {
                int power = Integer.parseInt(args[1]);
                fmeta.setPower(power > 3 ? 4 : power);
            }
            catch (NumberFormatException e) {
                throw new Exception(I18n.tl("invalidFireworkFormat", args[1], args[0]));
            }
            stack.setItemMeta((ItemMeta)fmeta);
            return;
        }
        if ((args[0].equalsIgnoreCase("fire") || args[0].equalsIgnoreCase("f")) && user.isAuthorized("essentials.firework.fire")) {
            int amount = 1;
            boolean direction = false;
            if (args.length > 1) {
                if (NumberUtil.isInt(args[1])) {
                    int serverLimit = this.ess.getSettings().getSpawnMobLimit();
                    amount = Integer.parseInt(args[1]);
                    if (amount > serverLimit) {
                        amount = serverLimit;
                        user.sendMessage(I18n.tl("mobSpawnLimit", new Object[0]));
                    }
                } else {
                    direction = true;
                }
            }
            for (int i = 0; i < amount; ++i) {
                Firework firework = (Firework)user.getWorld().spawnEntity(user.getLocation(), EntityType.FIREWORK);
                FireworkMeta fmeta = (FireworkMeta)stack.getItemMeta();
                if (direction) {
                    Vector vector = user.getBase().getEyeLocation().getDirection().multiply(0.07);
                    if (fmeta.getPower() > 1) {
                        fmeta.setPower(1);
                    }
                    firework.setVelocity(vector);
                }
                firework.setFireworkMeta(fmeta);
            }
            return;
        } else {
            MetaItemStack mStack = new MetaItemStack(stack);
            for (String arg : args) {
                try {
                    mStack.addFireworkMeta(user.getSource(), true, arg, this.ess);
                }
                catch (Exception e) {
                    user.sendMessage(I18n.tl("fireworkSyntax", new Object[0]));
                    throw e;
                }
            }
            if (mStack.isValidFirework()) {
                FireworkMeta fmeta = (FireworkMeta)mStack.getItemStack().getItemMeta();
                FireworkEffect effect = mStack.getFireworkBuilder().build();
                if (fmeta.getEffects().size() > 0 && !user.isAuthorized("essentials.firework.multiple")) {
                    throw new Exception(I18n.tl("multipleCharges", new Object[0]));
                }
                fmeta.addEffect(effect);
                stack.setItemMeta((ItemMeta)fmeta);
                return;
            } else {
                user.sendMessage(I18n.tl("fireworkSyntax", new Object[0]));
                throw new Exception(I18n.tl("fireworkColor", new Object[0]));
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            if (args[0].startsWith("color:")) {
                String prefix = args[0].contains(",") ? args[0].substring(0, args[0].lastIndexOf(44) + 1) : "color:";
                for (DyeColor color : DyeColor.values()) {
                    options.add(prefix + color.name().toLowerCase() + ",");
                }
                return options;
            }
            options.add("clear");
            options.add("power");
            options.add("color:");
            if (user.isAuthorized("essentials.firework.fire")) {
                options.add("fire");
            }
            return options;
        }
        if (args.length == 2) {
            if (args[0].equals("power")) {
                return Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"});
            }
            if (args[0].equals("fire")) {
                return Lists.newArrayList((Object[])new String[]{"1"});
            }
            if (args[0].startsWith("color:")) {
                ArrayList options = Lists.newArrayList();
                if (!args[1].startsWith("fade:")) {
                    args[1] = "fade:";
                }
                String prefix = args[1].contains(",") ? args[1].substring(0, args[1].lastIndexOf(44) + 1) : "fade:";
                for (DyeColor color : DyeColor.values()) {
                    options.add(prefix + color.name().toLowerCase() + ",");
                }
                return options;
            }
            return Collections.emptyList();
        }
        if (args.length == 3 && args[0].startsWith("color:")) {
            return Lists.newArrayList((Object[])new String[]{"shape:star", "shape:ball", "shape:large", "shape:creeper", "shape:burst"});
        }
        if (args.length == 4 && args[0].startsWith("color:")) {
            return Lists.newArrayList((Object[])new String[]{"effect:trail", "effect:twinkle", "effect:trail,twinkle", "effect:twinkle,trail"});
        }
        return Collections.emptyList();
    }
}

