/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Server;

public class Commandeco
extends EssentialsLoopCommand {
    EcoCommands cmd;
    BigDecimal amount;

    public Commandeco() {
        super("eco");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        BigDecimal startingBalance = this.ess.getSettings().getStartingBalance();
        try {
            this.cmd = EcoCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH));
            this.amount = this.cmd == EcoCommands.RESET ? startingBalance : new BigDecimal(args[2].replaceAll("[^0-9\\.]", ""));
        }
        catch (Exception ex) {
            throw new NotEnoughArgumentsException(ex);
        }
        this.loopOfflinePlayers(server, sender, false, true, args[1], args);
        if (this.cmd == EcoCommands.RESET || this.cmd == EcoCommands.SET) {
            if (args[1].contentEquals("**")) {
                server.broadcastMessage(I18n.tl("resetBalAll", NumberUtil.displayCurrency(this.amount, this.ess)));
            } else if (args[1].contentEquals("*")) {
                server.broadcastMessage(I18n.tl("resetBal", NumberUtil.displayCurrency(this.amount, this.ess)));
            }
        }
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User player, String[] args) throws NotEnoughArgumentsException, ChargeException, MaxMoneyException {
        switch (this.cmd) {
            case GIVE: {
                player.giveMoney(this.amount, sender);
                break;
            }
            case TAKE: {
                this.take(this.amount, player, sender);
                break;
            }
            case RESET: 
            case SET: {
                this.set(this.amount, player, sender);
            }
        }
    }

    private void take(BigDecimal amount, User player, CommandSource sender) throws ChargeException {
        BigDecimal money = player.getMoney();
        BigDecimal minBalance = this.ess.getSettings().getMinMoney();
        if (money.subtract(amount).compareTo(minBalance) >= 0) {
            player.takeMoney(amount, sender);
        } else if (sender == null) {
            try {
                player.setMoney(minBalance);
            }
            catch (MaxMoneyException maxMoneyException) {
                // empty catch block
            }
            player.sendMessage(I18n.tl("takenFromAccount", NumberUtil.displayCurrency(player.getMoney(), this.ess)));
        } else {
            throw new ChargeException(I18n.tl("insufficientFunds", new Object[0]));
        }
    }

    private void set(BigDecimal amount, User player, CommandSource sender) throws MaxMoneyException {
        boolean aboveMax;
        BigDecimal minBalance = this.ess.getSettings().getMinMoney();
        BigDecimal maxBalance = this.ess.getSettings().getMaxMoney();
        boolean underMinimum = amount.compareTo(minBalance) < 0;
        boolean bl = aboveMax = amount.compareTo(maxBalance) > 0;
        player.setMoney(underMinimum ? minBalance : (aboveMax ? maxBalance : amount));
        player.sendMessage(I18n.tl("setBal", NumberUtil.displayCurrency(player.getMoney(), this.ess)));
        if (sender != null) {
            sender.sendMessage(I18n.tl("setBalOthers", player.getDisplayName(), NumberUtil.displayCurrency(player.getMoney(), this.ess)));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            for (EcoCommands command : EcoCommands.values()) {
                options.add(command.name().toLowerCase(Locale.ENGLISH));
            }
            return options;
        }
        if (args.length == 2) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 3 && !args[0].equalsIgnoreCase(EcoCommands.RESET.name())) {
            if (args[0].equalsIgnoreCase(EcoCommands.SET.name())) {
                return Lists.newArrayList((Object[])new String[]{"0", this.ess.getSettings().getStartingBalance().toString()});
            }
            return Lists.newArrayList((Object[])new String[]{"1", "10", "100", "1000"});
        }
        return Collections.emptyList();
    }

    private static enum EcoCommands {
        GIVE,
        TAKE,
        SET,
        RESET;

    }
}

