/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Server;

public class Commandbalancetop
extends EssentialsCommand {
    private static final int CACHETIME = 120000;
    public static final int MINUSERS = 50;
    private static final SimpleTextInput cache = new SimpleTextInput();
    private static long cacheage = 0L;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Commandbalancetop() {
        super("balancetop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        boolean force;
        int page;
        block12: {
            page = 0;
            force = false;
            if (args.length > 0) {
                try {
                    page = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException ex) {
                    if (!args[0].equalsIgnoreCase("force") || sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.balancetop.force")) break block12;
                    force = true;
                }
            }
        }
        if (!force && lock.readLock().tryLock()) {
            try {
                if (cacheage > System.currentTimeMillis() - 120000L) {
                    Commandbalancetop.outputCache(sender, commandLabel, page);
                    return;
                }
                if (this.ess.getUserMap().getUniqueUsers() > 50) {
                    sender.sendMessage(I18n.tl("orderBalances", this.ess.getUserMap().getUniqueUsers()));
                }
            }
            finally {
                lock.readLock().unlock();
            }
            this.ess.runTaskAsynchronously(new Viewer(sender, commandLabel, page, force));
        } else {
            if (this.ess.getUserMap().getUniqueUsers() > 50) {
                sender.sendMessage(I18n.tl("orderBalances", this.ess.getUserMap().getUniqueUsers()));
            }
            this.ess.runTaskAsynchronously(new Viewer(sender, commandLabel, page, force));
        }
    }

    private static void outputCache(CommandSource sender, String command, int page) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cacheage);
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        sender.sendMessage(I18n.tl("balanceTop", format.format(cal.getTime())));
        new TextPager(cache).showPage(Integer.toString(page), null, "balancetop", sender);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"1"});
            if (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.balancetop.force")) {
                options.add("force");
            }
            return options;
        }
        return Collections.emptyList();
    }

    private class Viewer
    implements Runnable {
        private final transient CommandSource sender;
        private final transient int page;
        private final transient boolean force;
        private final transient String commandLabel;

        public Viewer(CommandSource sender, String commandLabel, int page, boolean force) {
            this.sender = sender;
            this.page = page;
            this.force = force;
            this.commandLabel = commandLabel;
        }

        @Override
        public void run() {
            lock.readLock().lock();
            try {
                if (!this.force && cacheage > System.currentTimeMillis() - 120000L) {
                    Commandbalancetop.outputCache(this.sender, this.commandLabel, this.page);
                    return;
                }
            }
            finally {
                lock.readLock().unlock();
            }
            Commandbalancetop.this.ess.runTaskAsynchronously(new Calculator(new Viewer(this.sender, this.commandLabel, this.page, false), this.force));
        }
    }

    private class Calculator
    implements Runnable {
        private final transient Viewer viewer;
        private final boolean force;

        public Calculator(Viewer viewer, boolean force) {
            this.viewer = viewer;
            this.force = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            lock.writeLock().lock();
            try {
                if (this.force || cacheage <= System.currentTimeMillis() - 120000L) {
                    cache.getLines().clear();
                    HashMap<String, BigDecimal> balances = new HashMap<String, BigDecimal>();
                    BigDecimal totalMoney = BigDecimal.ZERO;
                    if (Commandbalancetop.this.ess.getSettings().isEcoDisabled()) {
                        if (Commandbalancetop.this.ess.getSettings().isDebug()) {
                            Commandbalancetop.this.ess.getLogger().info("Internal economy functions disabled, aborting baltop.");
                        }
                    } else {
                        for (UUID u : Commandbalancetop.this.ess.getUserMap().getAllUniqueUsers()) {
                            User user = Commandbalancetop.this.ess.getUserMap().getUser(u);
                            if (user == null || !Commandbalancetop.this.ess.getSettings().isNpcsInBalanceRanking() && user.isNPC() || user.isAuthorized("essentials.balancetop.exclude")) continue;
                            BigDecimal bigDecimal = user.getMoney();
                            user.updateMoneyCache(bigDecimal);
                            totalMoney = totalMoney.add(bigDecimal);
                            String name = user.isHidden() ? user.getName() : user.getDisplayName();
                            balances.put(name, bigDecimal);
                        }
                    }
                    ArrayList sortedEntries = new ArrayList(balances.entrySet());
                    Collections.sort(sortedEntries, new Comparator<Map.Entry<String, BigDecimal>>(){

                        @Override
                        public int compare(Map.Entry<String, BigDecimal> entry1, Map.Entry<String, BigDecimal> entry2) {
                            return entry2.getValue().compareTo(entry1.getValue());
                        }
                    });
                    cache.getLines().add(I18n.tl("serverTotal", NumberUtil.displayCurrency(totalMoney, Commandbalancetop.this.ess)));
                    int pos = 1;
                    for (Map.Entry entry : sortedEntries) {
                        cache.getLines().add(pos + ". " + (String)entry.getKey() + ", " + NumberUtil.displayCurrency((BigDecimal)entry.getValue(), Commandbalancetop.this.ess));
                        ++pos;
                    }
                    cacheage = System.currentTimeMillis();
                }
            }
            finally {
                lock.writeLock().unlock();
            }
            Commandbalancetop.this.ess.runTaskAsynchronously(this.viewer);
        }
    }
}

