/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;

public class Commandafk
extends EssentialsCommand {
    public Commandafk() {
        super("afk");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length > 0 && user.isAuthorized("essentials.afk.others")) {
            String message;
            User afkUser = user;
            try {
                afkUser = this.getPlayer(server, user, args, 0);
                message = args.length > 1 ? Commandafk.getFinalArg(args, 1) : null;
            }
            catch (PlayerNotFoundException e) {
                if (args.length == 1) {
                    throw e;
                }
                message = Commandafk.getFinalArg(args, 0);
            }
            this.toggleAfk(user, afkUser, message);
        } else {
            String message = args.length > 0 ? Commandafk.getFinalArg(args, 0) : null;
            this.toggleAfk(user, user, message);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length <= 0) {
            throw new NotEnoughArgumentsException();
        }
        User afkUser = this.getPlayer(server, args, 0, true, false);
        String message = args.length > 1 ? Commandafk.getFinalArg(args, 1) : null;
        this.toggleAfk(null, afkUser, message);
    }

    private void toggleAfk(User sender, User user, String message) throws Exception {
        if (message != null && sender != null) {
            if (sender.isMuted()) {
                throw new Exception(sender.hasMuteReason() ? I18n.tl("voiceSilencedReason", sender.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            }
            if (!sender.isAuthorized("essentials.afk.message")) {
                throw new Exception(I18n.tl("noPermToAFKMessage", new Object[0]));
            }
        }
        user.setDisplayNick();
        String msg = "";
        if (!user.toggleAfk()) {
            if (!user.isHidden()) {
                msg = I18n.tl("userIsNotAway", user.getDisplayName());
            }
            user.updateActivity(false);
        } else {
            if (!user.isHidden()) {
                msg = message != null ? I18n.tl("userIsAwayWithMessage", user.getDisplayName(), message) : I18n.tl("userIsAway", user.getDisplayName());
            }
            user.setAfkMessage(message);
        }
        if (!msg.isEmpty()) {
            this.ess.broadcastMessage(user, msg);
        }
        user.setDisplayNick();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1 && user.isAuthorized("essentials.afk.others")) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

