/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.api;

import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public interface IItemDb {
    default public ItemStack get(String name, int quantity) throws Exception {
        ItemStack stack = this.get(name.toLowerCase(Locale.ENGLISH));
        stack.setAmount(quantity);
        return stack;
    }

    public ItemStack get(String var1) throws Exception;

    default public String names(ItemStack item) {
        List<String> nameList = this.nameList(item);
        if (nameList.size() > 15) {
            nameList = nameList.subList(0, 14);
        }
        return StringUtil.joinList(", ", nameList);
    }

    public List<String> nameList(ItemStack var1);

    public String name(ItemStack var1);

    public List<ItemStack> getMatching(User var1, String[] var2) throws Exception;

    public String serialize(ItemStack var1);

    public Collection<String> listNames();

    @Deprecated
    default public Material getFromLegacyId(int id) {
        return this.getFromLegacy(id, (byte)0);
    }

    @Deprecated
    public int getLegacyId(Material var1) throws Exception;

    default public Material getFromLegacy(String item) {
        String[] split = item.split(":");
        if (!NumberUtil.isInt(split[0])) {
            return null;
        }
        int id = Integer.parseInt(split[0]);
        byte damage = 0;
        if (split.length > 1 && NumberUtil.isInt(split[1])) {
            damage = Byte.parseByte(split[1]);
        }
        return this.getFromLegacy(id, damage);
    }

    default public Material getFromLegacy(int id, byte damage) {
        return MaterialUtil.convertFromLegacy(id, damage);
    }

    public boolean isReady();
}

