/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.UUIDMap;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.entity.Player;

public class UserMap
extends CacheLoader<String, User>
implements IConf {
    private final transient IEssentials ess;
    private final transient ConcurrentSkipListSet<UUID> keys = new ConcurrentSkipListSet();
    private final transient ConcurrentSkipListMap<String, UUID> names = new ConcurrentSkipListMap();
    private final transient ConcurrentSkipListMap<UUID, ArrayList<String>> history = new ConcurrentSkipListMap();
    private UUIDMap uuidMap;
    private final transient Cache<String, User> users;
    private static boolean legacy = false;
    private final Pattern validUserPattern = Pattern.compile("^[a-zA-Z0-9_]{2,16}$");
    private static Method getLegacy;

    public UserMap(IEssentials ess) {
        this.ess = ess;
        this.uuidMap = new UUIDMap(ess);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        int maxCount = ess.getSettings().getMaxUserCacheCount();
        try {
            cacheBuilder.maximumSize((long)maxCount);
        }
        catch (NoSuchMethodError nsme) {
            legacy = true;
            this.legacyMaximumSize(cacheBuilder, maxCount);
        }
        cacheBuilder.softValues();
        this.users = !legacy ? cacheBuilder.build((CacheLoader)this) : this.legacyBuild(cacheBuilder);
    }

    private void loadAllUsersAsync(final IEssentials ess) {
        ess.runTaskAsynchronously(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cache cache = UserMap.this.users;
                synchronized (cache) {
                    File userdir = new File(ess.getDataFolder(), "userdata");
                    if (!userdir.exists()) {
                        return;
                    }
                    UserMap.this.keys.clear();
                    UserMap.this.users.invalidateAll();
                    for (String string : userdir.list()) {
                        if (!string.endsWith(".yml")) continue;
                        String name = string.substring(0, string.length() - 4);
                        try {
                            UserMap.this.keys.add(UUID.fromString(name));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    UserMap.this.uuidMap.loadAllUsers(UserMap.this.names, UserMap.this.history);
                }
            }
        });
    }

    public boolean userExists(UUID uuid) {
        return this.keys.contains(uuid);
    }

    public User getUser(String name) {
        try {
            String sanitizedName = StringUtil.safeString(name);
            if (this.names.containsKey(sanitizedName)) {
                UUID uuid = this.names.get(sanitizedName);
                return this.getUser(uuid);
            }
            File userFile = this.getUserFileFromString(sanitizedName);
            if (userFile.exists()) {
                this.ess.getLogger().info("Importing user " + name + " to usermap.");
                User user = new User(new OfflinePlayer(sanitizedName, this.ess.getServer()), this.ess);
                this.trackUUID(user.getBase().getUniqueId(), user.getName(), true);
                return user;
            }
            return null;
        }
        catch (UncheckedExecutionException ex) {
            return null;
        }
    }

    public User getUser(UUID uuid) {
        try {
            if (!legacy) {
                return (User)((LoadingCache)this.users).get((Object)uuid.toString());
            }
            return this.legacyCacheGet(uuid);
        }
        catch (ExecutionException ex) {
            return null;
        }
        catch (UncheckedExecutionException ex) {
            return null;
        }
    }

    public void trackUUID(UUID uuid, String name, boolean replace) {
        if (uuid != null) {
            this.keys.add(uuid);
            if (name != null && name.length() > 0) {
                String keyName;
                String string = keyName = this.ess.getSettings().isSafeUsermap() ? StringUtil.safeString(name) : name;
                if (!this.names.containsKey(keyName)) {
                    this.names.put(keyName, uuid);
                    this.uuidMap.writeUUIDMap();
                } else if (!this.names.get(keyName).equals(uuid)) {
                    if (replace) {
                        this.ess.getLogger().info("Found new UUID for " + name + ". Replacing " + this.names.get(keyName).toString() + " with " + uuid.toString());
                        this.names.put(keyName, uuid);
                        this.uuidMap.writeUUIDMap();
                    } else if (this.ess.getSettings().isDebug()) {
                        this.ess.getLogger().info("Found old UUID for " + name + " (" + uuid.toString() + "). Not adding to usermap.");
                    }
                }
            }
        }
    }

    public User load(String stringUUID) throws Exception {
        UUID uuid = UUID.fromString(stringUUID);
        Player player = this.ess.getServer().getPlayer(uuid);
        if (player != null) {
            User user = new User(player, this.ess);
            this.trackUUID(uuid, user.getName(), true);
            return user;
        }
        File userFile = this.getUserFileFromID(uuid);
        if (userFile.exists()) {
            player = new OfflinePlayer(uuid, this.ess.getServer());
            User user = new User(player, this.ess);
            ((OfflinePlayer)player).setName(user.getLastAccountName());
            this.trackUUID(uuid, user.getName(), false);
            return user;
        }
        throw new Exception("User not found!");
    }

    @Override
    public void reloadConfig() {
        this.getUUIDMap().forceWriteUUIDMap();
        this.loadAllUsersAsync(this.ess);
    }

    public void invalidateAll() {
        this.users.invalidateAll();
    }

    public void removeUser(String name) {
        if (this.names == null) {
            this.ess.getLogger().warning("Name collection is null, cannot remove user.");
            return;
        }
        UUID uuid = this.names.get(name);
        if (uuid != null) {
            this.keys.remove(uuid);
            this.users.invalidate((Object)uuid.toString());
        }
        this.names.remove(name);
        this.names.remove(StringUtil.safeString(name));
    }

    public Set<UUID> getAllUniqueUsers() {
        return Collections.unmodifiableSet(this.keys);
    }

    public int getUniqueUsers() {
        return this.keys.size();
    }

    protected ConcurrentSkipListMap<String, UUID> getNames() {
        return this.names;
    }

    protected ConcurrentSkipListMap<UUID, ArrayList<String>> getHistory() {
        return this.history;
    }

    public List<String> getUserHistory(UUID uuid) {
        return this.history.get(uuid);
    }

    public UUIDMap getUUIDMap() {
        return this.uuidMap;
    }

    private File getUserFileFromID(UUID uuid) {
        File userFolder = new File(this.ess.getDataFolder(), "userdata");
        return new File(userFolder, uuid.toString() + ".yml");
    }

    public File getUserFileFromString(String name) {
        File userFolder = new File(this.ess.getDataFolder(), "userdata");
        return new File(userFolder, StringUtil.sanitizeFileName(name) + ".yml");
    }

    public User getUserFromBukkit(String name) {
        UUID uuid;
        name = StringUtil.safeString(name);
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().warning("Using potentially blocking Bukkit UUID lookup for: " + name);
        }
        if (name == null || !this.validUserPattern.matcher(name).matches()) {
            return null;
        }
        org.bukkit.OfflinePlayer offlinePlayer = this.ess.getServer().getOfflinePlayer(name);
        if (offlinePlayer == null) {
            return null;
        }
        try {
            uuid = offlinePlayer.getUniqueId();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return null;
        }
        if (UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)).equals(uuid)) {
            return null;
        }
        this.names.put(name, uuid);
        return this.getUser(uuid);
    }

    private User legacyCacheGet(UUID uuid) {
        if (getLegacy == null) {
            Class<?> usersClass = this.users.getClass();
            for (Method m : usersClass.getDeclaredMethods()) {
                if (!m.getName().equals("get")) continue;
                getLegacy = m;
                getLegacy.setAccessible(true);
                break;
            }
        }
        try {
            return (User)getLegacy.invoke(this.users, uuid.toString());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private void legacyMaximumSize(CacheBuilder builder, int maxCount) {
        try {
            Method maxSizeLegacy = builder.getClass().getDeclaredMethod("maximumSize", Integer.TYPE);
            maxSizeLegacy.setAccessible(true);
            maxSizeLegacy.invoke((Object)builder, maxCount);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Cache<String, User> legacyBuild(CacheBuilder builder) {
        Cache legacyUsers;
        Method build = null;
        for (Method method : builder.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("build")) continue;
            build = method;
            break;
        }
        try {
            assert (build != null);
            build.setAccessible(true);
            legacyUsers = (Cache)build.invoke((Object)builder, this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            legacyUsers = null;
        }
        return legacyUsers;
    }
}

