/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.utils.EnumUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.ess3.nms.refl.ReflUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Villager;

public class MobCompat {
    public static final EntityType LLAMA = EnumUtil.getEntityType("LLAMA");
    public static final EntityType PARROT = EnumUtil.getEntityType("PARROT");
    public static final EntityType TROPICAL_FISH = EnumUtil.getEntityType("TROPICAL_FISH");
    public static final EntityType PANDA = EnumUtil.getEntityType("PANDA");
    public static final EntityType TRADER_LLAMA = EnumUtil.getEntityType("TRADER_LLAMA");
    public static final EntityType CAT = EnumUtil.getEntityType("CAT", "OCELOT");
    private static Class catClass = ReflUtil.getClassCached("org.bukkit.entity.Cat");
    private static Class catTypeClass = ReflUtil.getClassCached("org.bukkit.entity.Cat.Type");
    private static Method catSetTypeMethod = catClass == null || catTypeClass == null ? null : ReflUtil.getMethodCached(catClass, "setCatType", catTypeClass);
    private static Class villagerCareerClass = ReflUtil.getClassCached("org.bukkit.entity.Villager.Career");
    private static Method villagerSetCareerMethod = villagerCareerClass == null ? null : ReflUtil.getMethodCached(Villager.class, "setCareer", villagerCareerClass);

    private static boolean isNewCat() {
        return catClass != null && catTypeClass != null && catSetTypeMethod != null;
    }

    public static void setCatType(Entity entity, CatType type) {
        if (MobCompat.isNewCat()) {
            try {
                catSetTypeMethod.invoke((Object)entity, EnumUtil.valueOf(catTypeClass, type.catTypeName));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            ((Ocelot)entity).setCatType(Ocelot.Type.valueOf((String)type.ocelotTypeName));
        }
    }

    private static boolean isCareerVillager() {
        return villagerCareerClass != null && villagerSetCareerMethod != null;
    }

    public static void setVillagerProfession(Entity entity, VillagerProfession profession) {
        if (!MobCompat.isCareerVillager()) {
            ((Villager)entity).setProfession(profession.asEnum());
        } else {
            ((Villager)entity).setProfession(profession.asEnum());
            try {
                villagerSetCareerMethod.invoke((Object)entity, EnumUtil.valueOf(villagerCareerClass, profession.oldCareer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setVillagerType(Entity entity, String type) {
        Class<?> typeEnum = ReflUtil.getClassCached("org.bukkit.entity.Villager.Type");
        if (typeEnum == null) {
            return;
        }
        Method villagerSetTypeMethod = ReflUtil.getMethodCached(Villager.class, "setVillagerType", typeEnum);
        try {
            villagerSetTypeMethod.invoke((Object)entity, EnumUtil.valueOf(typeEnum, type));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLlamaColor(Entity entity, String color) {
        Class<?> llamaClass = ReflUtil.getClassCached("org.bukkit.entity.Llama");
        if (llamaClass == null) {
            return;
        }
        Class<?> colorEnum = ReflUtil.getClassCached("org.bukkit.entity.Llama.Color");
        Method setVariantMethod = ReflUtil.getMethodCached(llamaClass, "setColor");
        try {
            setVariantMethod.invoke((Object)entity, EnumUtil.valueOf(colorEnum, color));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setParrotVariant(Entity entity, String variant) {
        Class<?> parrotClass = ReflUtil.getClassCached("org.bukkit.entity.Parrot");
        if (parrotClass == null) {
            return;
        }
        Class<?> variantEnum = ReflUtil.getClassCached("org.bukkit.entity.Parrot.Variant");
        Method setVariantMethod = ReflUtil.getMethodCached(parrotClass, "setVariant");
        try {
            setVariantMethod.invoke((Object)entity, EnumUtil.valueOf(variantEnum, variant));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setTropicalFishPattern(Entity entity, String pattern) {
        Class<?> tropicalFishClass = ReflUtil.getClassCached("org.bukkit.entity.TropicalFish");
        if (tropicalFishClass == null) {
            return;
        }
        Class<?> patternEnum = ReflUtil.getClassCached("org.bukkit.entity.TropicalFish.Pattern");
        Method setPatternMethod = ReflUtil.getMethodCached(tropicalFishClass, "setPattern");
        try {
            setPatternMethod.invoke((Object)entity, EnumUtil.valueOf(patternEnum, pattern));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMooshroomVariant(Entity entity, String variant) {
        Class<?> mushroomCowClass = ReflUtil.getClassCached("org.bukkit.entity.MushroomCow");
        Class<?> variantEnum = ReflUtil.getClassCached("org.bukkit.entity.MushroomCow.Variant");
        if (mushroomCowClass == null || variantEnum == null) {
            return;
        }
        Method setVariantMethod = ReflUtil.getMethodCached(mushroomCowClass, "setVariant");
        try {
            setVariantMethod.invoke((Object)entity, EnumUtil.valueOf(variantEnum, variant));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setPandaGene(Entity entity, String gene, boolean mainGene) {
        Class<?> pandaClass = ReflUtil.getClassCached("org.bukkit.entity.Panda");
        if (pandaClass == null) {
            return;
        }
        Class<?> geneEnum = ReflUtil.getClassCached("org.bukkit.entity.Panda.Gene");
        Method setGeneMethod = mainGene ? ReflUtil.getMethodCached(pandaClass, "setMainGene") : ReflUtil.getMethodCached(pandaClass, "setHiddenGene");
        try {
            setGeneMethod.invoke((Object)entity, EnumUtil.valueOf(geneEnum, gene));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum VillagerProfession {
        NONE("FARMER", "FARMER", "NONE"),
        ARMORER("BLACKSMITH", "ARMORER"),
        BUTCHER("FARMER", "BUTCHER"),
        CARTOGRAPHER("LIBRARIAN", "CARTOGRAPHER"),
        CLERIC("PRIEST", "CLERIC"),
        FARMER("FARMER", "FARMER"),
        FISHERMAN("FARMER", "FISHERMAN"),
        FLETCHER("FARMER", "FLETCHER"),
        LEATHERWORKER("BUTCHER", "LEATHERWORKER"),
        LIBRARIAN("LIBRARIAN", "LIBRARIAN"),
        MASON(null, null, "MASON"),
        NITWIT("NITWIT", "NITWIT"),
        SHEPHERD("FARMER", "SHEPHERD"),
        TOOLSMITH("BLACKSMITH", "TOOL_SMITH", "TOOLSMITH"),
        WEAPONSMITH("BLACKSMITH", "WEAPON_SMITH", "WEAPONSMITH");

        private String oldProfession;
        private String oldCareer;
        private String newProfession;

        private VillagerProfession(String oldProfession, String career) {
            this.oldProfession = oldProfession;
            this.oldCareer = career;
            this.newProfession = career;
        }

        private VillagerProfession(String oldProfession, String oldCareer, String newProfession) {
            this.oldProfession = oldProfession;
            this.oldCareer = oldCareer;
            this.newProfession = newProfession;
        }

        private Villager.Profession asEnum() {
            return EnumUtil.valueOf(Villager.Profession.class, this.newProfession, this.oldProfession);
        }
    }

    public static enum CatType {
        SIAMESE("SIAMESE", "SIAMESE_CAT"),
        WHITE("WHITE", "SIAMESE_CAT"),
        RED("RED", "RED_CAT"),
        TABBY("TABBY", "RED_CAT"),
        TUXEDO("BLACK", "BLACK_CAT"),
        BRITISH_SHORTHAIR("BRITISH_SHORTHAIR", "SIAMESE_CAT"),
        CALICO("CALICO", "RED_CAT"),
        PERSIAN("PERSIAN", "RED_CAT"),
        RAGDOLL("RAGDOLL", "SIAMESE_CAT"),
        JELLIE("JELLIE", "SIAMESE_CAT"),
        BLACK("ALL_BLACK", "BLACK_CAT");

        private final String catTypeName;
        private final String ocelotTypeName;

        private CatType(String catTypeName, String ocelotTypeName) {
            this.catTypeName = catTypeName;
            this.ocelotTypeName = ocelotTypeName;
        }
    }
}

