/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.TextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class EssentialsPlayerListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient IEssentials ess;

    public EssentialsPlayerListener(IEssentials parent) {
        this.ess = parent;
    }

    public void registerEvents() {
        this.ess.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.ess);
        if (EssentialsPlayerListener.isEntityPickupEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PickupListener1_12(), (Plugin)this.ess);
        } else {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new PickupListenerPre1_12(), (Plugin)this.ess);
        }
        if (EssentialsPlayerListener.isCommandSendEvent()) {
            this.ess.getServer().getPluginManager().registerEvents((Listener)new CommandSendListener(), (Plugin)this.ess);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        this.updateCompass(user);
        user.setDisplayNick();
        if (this.ess.getSettings().isTeleportInvulnerability()) {
            user.enableInvulnerabilityAfterTeleport();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isMuted()) {
            event.setCancelled(true);
            user.sendMessage(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            LOGGER.info(I18n.tl("mutedUserSpeaks", user.getName(), event.getMessage()));
        }
        try {
            Iterator it = event.getRecipients().iterator();
            while (it.hasNext()) {
                User u = this.ess.getUser((Player)it.next());
                if (!u.isIgnoredPlayer(user)) continue;
                it.remove();
            }
        }
        catch (UnsupportedOperationException ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Ignore could not block chat due to custom chat plugin event.", ex);
            }
            this.ess.getLogger().info("Ignore could not block chat due to custom chat plugin event.");
        }
        user.updateActivityOnInteract(true);
        user.setDisplayNick();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        if (!this.ess.getSettings().cancelAfkOnMove() && !this.ess.getSettings().getFreezeAfkPlayers()) {
            event.getHandlers().unregister((Listener)this);
            if (this.ess.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Unregistering move listener");
            }
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user.isAfk() && this.ess.getSettings().getFreezeAfkPlayers()) {
            Location from = event.getFrom();
            Location origTo = event.getTo();
            Location to = origTo.clone();
            if (origTo.getY() >= (double)(from.getBlockY() + 1)) {
                user.updateActivityOnMove(true);
                return;
            }
            to.setX(from.getX());
            to.setY(from.getY());
            to.setZ(from.getZ());
            try {
                event.setTo(LocationUtil.getSafeDestination(to));
            }
            catch (Exception ex) {
                event.setTo(to);
            }
            return;
        }
        Location afk = user.getAfkPosition();
        if (afk == null || !event.getTo().getWorld().equals(afk.getWorld()) || afk.distanceSquared(event.getTo()) > 9.0) {
            user.updateActivityOnMove(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (this.ess.getSettings().allowSilentJoinQuit() && user.isAuthorized("essentials.silentquit")) {
            event.setQuitMessage(null);
        } else if (this.ess.getSettings().isCustomQuitMessage() && event.getQuitMessage() != null) {
            Player player = event.getPlayer();
            String msg = this.ess.getSettings().getCustomQuitMessage().replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()).replace("{ONLINE}", NumberFormat.getInstance().format(this.ess.getOnlinePlayers().size()));
            event.setQuitMessage(msg.isEmpty() ? null : msg);
        }
        user.startTransaction();
        if (this.ess.getSettings().removeGodOnDisconnect() && user.isGodModeEnabled()) {
            user.setGodModeEnabled(false);
        }
        if (user.isVanished()) {
            user.setVanished(false);
        }
        user.setLogoutLocation();
        if (user.isRecipeSee()) {
            user.getBase().getOpenInventory().getTopInventory().clear();
        }
        for (HumanEntity viewer : user.getBase().getInventory().getViewers()) {
            User uviewer;
            if (!(viewer instanceof Player) || !(uviewer = this.ess.getUser((Player)viewer)).isInvSee()) continue;
            uviewer.getBase().closeInventory();
        }
        user.updateActivity(false);
        if (!user.isHidden()) {
            user.setLastLogout(System.currentTimeMillis());
        }
        user.stopTransaction();
        user.dispose();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(final PlayerJoinEvent event) {
        final String joinMessage = event.getJoinMessage();
        this.ess.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                EssentialsPlayerListener.this.delayedJoin(event.getPlayer(), joinMessage);
            }
        });
        if (this.ess.getSettings().allowSilentJoinQuit() || this.ess.getSettings().isCustomJoinMessage()) {
            event.setJoinMessage(null);
        }
    }

    public void delayedJoin(final Player player, final String message) {
        if (!player.isOnline()) {
            return;
        }
        this.ess.getBackup().onPlayerJoin();
        User dUser = this.ess.getUser(player);
        dUser.startTransaction();
        if (dUser.isNPC()) {
            dUser.setNPC(false);
        }
        final long currentTime = System.currentTimeMillis();
        dUser.checkMuteTimeout(currentTime);
        dUser.updateActivity(false);
        dUser.stopTransaction();
        class DelayJoinTask
        implements Runnable {
            DelayJoinTask() {
            }

            @Override
            public void run() {
                User user = EssentialsPlayerListener.this.ess.getUser(player);
                if (!user.getBase().isOnline()) {
                    return;
                }
                user.startTransaction();
                user.setLastAccountName(user.getBase().getName());
                user.setLastLogin(currentTime);
                user.setDisplayNick();
                EssentialsPlayerListener.this.updateCompass(user);
                if (!EssentialsPlayerListener.this.ess.getVanishedPlayersNew().isEmpty() && !user.isAuthorized("essentials.vanish.see")) {
                    for (String p : EssentialsPlayerListener.this.ess.getVanishedPlayersNew()) {
                        Player toVanish = EssentialsPlayerListener.this.ess.getServer().getPlayerExact(p);
                        if (toVanish == null || !toVanish.isOnline()) continue;
                        user.getBase().hidePlayer(toVanish);
                        if (!EssentialsPlayerListener.this.ess.getSettings().isDebug()) continue;
                        EssentialsPlayerListener.this.ess.getLogger().info("Hiding vanished player: " + p);
                    }
                }
                if (user.isAuthorized("essentials.sleepingignored")) {
                    user.getBase().setSleepingIgnored(true);
                }
                if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit() && (user.isAuthorized("essentials.silentjoin") || user.isAuthorized("essentials.silentjoin.vanish"))) {
                    if (user.isAuthorized("essentials.silentjoin.vanish")) {
                        user.setVanished(true);
                    }
                } else if (message != null) {
                    if (EssentialsPlayerListener.this.ess.getSettings().isCustomJoinMessage()) {
                        String msg = EssentialsPlayerListener.this.ess.getSettings().getCustomJoinMessage().replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()).replace("{UNIQUE}", NumberFormat.getInstance().format(EssentialsPlayerListener.this.ess.getUserMap().getUniqueUsers())).replace("{ONLINE}", NumberFormat.getInstance().format(EssentialsPlayerListener.this.ess.getOnlinePlayers().size()));
                        if (!msg.isEmpty()) {
                            EssentialsPlayerListener.this.ess.getServer().broadcastMessage(msg);
                        }
                    } else if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit()) {
                        EssentialsPlayerListener.this.ess.getServer().broadcastMessage(message);
                    }
                }
                int motdDelay = EssentialsPlayerListener.this.ess.getSettings().getMotdDelay() / 50;
                1DelayJoinTask.DelayMotdTask motdTask = new 1DelayJoinTask.DelayMotdTask(user);
                if (motdDelay > 0) {
                    EssentialsPlayerListener.this.ess.scheduleSyncDelayedTask(motdTask, motdDelay);
                } else {
                    motdTask.run();
                }
                if (!EssentialsPlayerListener.this.ess.getSettings().isCommandDisabled("mail") && user.isAuthorized("essentials.mail")) {
                    List<String> mail = user.getMails();
                    if (mail.isEmpty()) {
                        if (EssentialsPlayerListener.this.ess.getSettings().isNotifyNoNewMail()) {
                            user.sendMessage(I18n.tl("noNewMail", new Object[0]));
                        }
                    } else {
                        user.notifyOfMail();
                    }
                }
                if (user.isAuthorized("essentials.fly.safelogin")) {
                    user.getBase().setFallDistance(0.0f);
                    if (LocationUtil.shouldFly(user.getLocation())) {
                        user.getBase().setAllowFlight(true);
                        user.getBase().setFlying(true);
                        if (EssentialsPlayerListener.this.ess.getSettings().isSendFlyEnableOnJoin()) {
                            user.getBase().sendMessage(I18n.tl("flyMode", I18n.tl("enabled", new Object[0]), user.getDisplayName()));
                        }
                    }
                }
                if (!user.isAuthorized("essentials.speed")) {
                    user.getBase().setFlySpeed(0.1f);
                    user.getBase().setWalkSpeed(0.2f);
                }
                if (user.isSocialSpyEnabled() && !user.isAuthorized("essentials.socialspy")) {
                    user.setSocialSpyEnabled(false);
                    EssentialsPlayerListener.this.ess.getLogger().log(Level.INFO, "Set socialspy to false for {0} because they had it enabled without permission.", user.getName());
                }
                if (user.isGodModeEnabled() && !user.isAuthorized("essentials.god")) {
                    user.setGodModeEnabled(false);
                    EssentialsPlayerListener.this.ess.getLogger().log(Level.INFO, "Set god mode to false for {0} because they had it enabled without permission.", user.getName());
                }
                user.setConfirmingClearCommand(null);
                user.getConfirmingPayments().clear();
                user.stopTransaction();
            }

            class 1DelayJoinTask.DelayMotdTask
            implements Runnable {
                private User user;

                public 1DelayJoinTask.DelayMotdTask(User user) {
                    this.user = user;
                }

                @Override
                public void run() {
                    IText input;
                    IText tempInput = null;
                    if (!EssentialsPlayerListener.this.ess.getSettings().isCommandDisabled("motd")) {
                        try {
                            tempInput = new TextInput(this.user.getSource(), "motd", true, EssentialsPlayerListener.this.ess);
                        }
                        catch (IOException ex) {
                            if (EssentialsPlayerListener.this.ess.getSettings().isDebug()) {
                                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                            }
                            LOGGER.log(Level.WARNING, ex.getMessage());
                        }
                    }
                    if ((input = tempInput) != null && !input.getLines().isEmpty() && this.user.isAuthorized("essentials.motd")) {
                        KeywordReplacer output = new KeywordReplacer(input, this.user.getSource(), EssentialsPlayerListener.this.ess);
                        TextPager pager = new TextPager(output, true);
                        pager.showPage("1", null, "motd", this.user.getSource());
                    }
                }
            }
        }
        this.ess.scheduleSyncDelayedTask(new DelayJoinTask());
    }

    private void updateCompass(User user) {
        if (this.ess.getSettings().isCompassTowardsHomePerm() && !user.isAuthorized("essentials.home.compass")) {
            return;
        }
        Location loc = user.getHome(user.getLocation());
        if (loc == null) {
            loc = user.getBase().getBedSpawnLocation();
        }
        if (loc != null) {
            user.getBase().setCompassTarget(loc);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerLoginBanned(PlayerLoginEvent event) {
        switch (event.getResult()) {
            case KICK_BANNED: {
                BanEntry banEntry = this.ess.getServer().getBanList(BanList.Type.NAME).getBanEntry(event.getPlayer().getName());
                if (banEntry != null) {
                    Date banExpiry = banEntry.getExpiration();
                    if (banExpiry != null) {
                        String expiry = DateUtil.formatDateDiff(banExpiry.getTime());
                        event.setKickMessage(I18n.tl("tempbanJoin", expiry, banEntry.getReason()));
                        break;
                    }
                    event.setKickMessage(I18n.tl("banJoin", banEntry.getReason()));
                    break;
                }
                banEntry = this.ess.getServer().getBanList(BanList.Type.IP).getBanEntry(event.getAddress().getHostAddress());
                if (banEntry == null) break;
                event.setKickMessage(I18n.tl("banIpJoin", banEntry.getReason()));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerLogin(PlayerLoginEvent event) {
        switch (event.getResult()) {
            case KICK_FULL: {
                User kfuser = this.ess.getUser(event.getPlayer());
                if (kfuser.isAuthorized("essentials.joinfullserver")) {
                    event.allow();
                    return;
                }
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, I18n.tl("serverFull", new Object[0]));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        boolean backListener = this.ess.getSettings().registerBackInListener();
        boolean teleportInvulnerability = this.ess.getSettings().isTeleportInvulnerability();
        if (backListener || teleportInvulnerability) {
            User user = this.ess.getUser(event.getPlayer());
            if (backListener && (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND)) {
                user.setLastLocation();
            }
            if (teleportInvulnerability && (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND)) {
                user.enableInvulnerabilityAfterTeleport();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerEggThrow(PlayerEggThrowEvent event) {
        ItemStack stack;
        User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(stack = new ItemStack(Material.EGG, 1))) {
            user.getBase().getInventory().addItem(new ItemStack[]{stack});
            user.getBase().updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        final User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(new ItemStack(event.getBucket()))) {
            event.getItemStack().setType(event.getBucket());
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    user.getBase().updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        User user;
        Player player = event.getPlayer();
        String cmd = event.getMessage().toLowerCase(Locale.ENGLISH).split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        PluginCommand pluginCommand = this.ess.getServer().getPluginCommand(cmd);
        if (!(!this.ess.getSettings().getSocialSpyCommands().contains(cmd) && !this.ess.getSettings().getSocialSpyCommands().contains("*") || pluginCommand != null && (pluginCommand.getName().equals("msg") || pluginCommand.getName().equals("r")) || (user = this.ess.getUser(player)).isAuthorized("essentials.chat.spy.exempt"))) {
            for (User user2 : this.ess.getOnlineUsers()) {
                if (!user2.isSocialSpyEnabled() || player.equals(user2.getBase())) continue;
                if (user.isMuted() && this.ess.getSettings().getSocialSpyListenMutedPlayers()) {
                    user2.sendMessage(I18n.tl("socialSpyMutedPrefix", new Object[0]) + player.getDisplayName() + ": " + event.getMessage());
                    continue;
                }
                user2.sendMessage(I18n.tl("socialSpyPrefix", new Object[0]) + player.getDisplayName() + ": " + event.getMessage());
            }
        }
        if (this.ess.getUser(player).isMuted() && (this.ess.getSettings().getMuteCommands().contains(cmd) || this.ess.getSettings().getMuteCommands().contains("*"))) {
            event.setCancelled(true);
            player.sendMessage(I18n.tl("voiceSilenced", new Object[0]));
            LOGGER.info(I18n.tl("mutedUserSpeaks", player.getName(), event.getMessage()));
            return;
        }
        boolean broadcast = true;
        boolean update = true;
        if (pluginCommand != null) {
            switch (pluginCommand.getName()) {
                case "afk": {
                    update = false;
                }
                case "vanish": {
                    broadcast = false;
                }
            }
        }
        User user3 = this.ess.getUser(player);
        if (update) {
            user3.updateActivityOnInteract(broadcast);
        }
        if (this.ess.getSettings().isCommandCooldownsEnabled() && pluginCommand != null && !user3.isAuthorized("essentials.commandcooldowns.bypass")) {
            Map.Entry<Pattern, Long> cooldownEntry;
            int argStartIndex = event.getMessage().indexOf(" ");
            String args = argStartIndex == -1 ? "" : " " + event.getMessage().substring(argStartIndex);
            String fullCommand = pluginCommand.getName() + args;
            boolean cooldownFound = false;
            for (Map.Entry<Pattern, Long> entry : new HashMap<Pattern, Long>(user3.getCommandCooldowns()).entrySet()) {
                if (entry.getValue() <= System.currentTimeMillis()) {
                    user3.clearCommandCooldown(entry.getKey());
                    continue;
                }
                if (!entry.getKey().matcher(fullCommand).matches() || entry.getValue() <= System.currentTimeMillis()) continue;
                String commandCooldownTime = DateUtil.formatDateDiff(entry.getValue());
                user3.sendMessage(I18n.tl("commandCooldown", commandCooldownTime));
                cooldownFound = true;
                event.setCancelled(true);
                break;
            }
            if (!cooldownFound && (cooldownEntry = this.ess.getSettings().getCommandCooldownEntry(fullCommand)) != null) {
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info("Applying " + cooldownEntry.getValue() + "ms cooldown on /" + fullCommand + " for" + user3.getName() + ".");
                }
                Date expiry = new Date(System.currentTimeMillis() + cooldownEntry.getValue());
                user3.addCommandCooldown(cooldownEntry.getKey(), expiry, this.ess.getSettings().isCommandCooldownPersistent(fullCommand));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangedWorldFlyReset(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.getBase().getGameMode() != GameMode.CREATIVE && !user.getBase().getGameMode().name().equals("SPECTATOR") && !user.isAuthorized("essentials.fly")) {
            user.getBase().setFallDistance(0.0f);
            user.getBase().setAllowFlight(false);
        }
        if (!user.isAuthorized("essentials.speed")) {
            user.getBase().setFlySpeed(0.1f);
            user.getBase().setWalkSpeed(0.2f);
        } else {
            if ((double)user.getBase().getFlySpeed() > this.ess.getSettings().getMaxFlySpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                user.getBase().setFlySpeed((float)this.ess.getSettings().getMaxFlySpeed());
            } else {
                user.getBase().setFlySpeed(user.getBase().getFlySpeed() * 0.99999f);
            }
            if ((double)user.getBase().getWalkSpeed() > this.ess.getSettings().getMaxWalkSpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                user.getBase().setWalkSpeed((float)this.ess.getSettings().getMaxWalkSpeed());
            } else {
                user.getBase().setWalkSpeed(user.getBase().getWalkSpeed() * 0.99999f);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        String newWorld = event.getPlayer().getLocation().getWorld().getName();
        user.setDisplayNick();
        this.updateCompass(user);
        if (this.ess.getSettings().getNoGodWorlds().contains(newWorld) && user.isGodModeEnabledRaw()) {
            user.sendMessage(I18n.tl("noGodWorldWarning", new Object[0]));
        }
        if (!user.getWorld().getName().equals(newWorld)) {
            user.sendMessage(I18n.tl("currentWorld", newWorld));
        }
        if (user.isVanished()) {
            user.setVanished(user.isAuthorized("essentials.vanish"));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean updateActivity = true;
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                User player;
                if (event.isCancelled() || !MaterialUtil.isBed(event.getClickedBlock().getType()) || !this.ess.getSettings().getUpdateBedAtDaytime() || !(player = this.ess.getUser(event.getPlayer())).isAuthorized("essentials.sethome.bed") || !player.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL)) break;
                player.getBase().setBedSpawnLocation(event.getClickedBlock().getLocation());
                player.sendMessage(I18n.tl("bedSet", player.getLocation().getWorld().getName(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
                break;
            }
            case LEFT_CLICK_AIR: {
                User user;
                if (event.getPlayer().isFlying() && (user = this.ess.getUser(event.getPlayer())).isFlyClickJump()) {
                    this.useFlyClickJump(user);
                    break;
                }
            }
            case LEFT_CLICK_BLOCK: {
                User user;
                if (event.getItem() == null || event.getItem().getType() == Material.AIR || !(user = this.ess.getUser(event.getPlayer())).hasPowerTools() || !user.arePowerToolsEnabled() || !this.usePowertools(user, event.getItem().getType())) break;
                event.setCancelled(true);
                break;
            }
            case PHYSICAL: {
                updateActivity = false;
            }
        }
        if (updateActivity) {
            this.ess.getUser(event.getPlayer()).updateActivityOnInteract(true);
        }
    }

    private void useFlyClickJump(final User user) {
        block2: {
            try {
                final Location otarget = LocationUtil.getTarget((LivingEntity)user.getBase());
                class DelayedClickJumpTask
                implements Runnable {
                    DelayedClickJumpTask() {
                    }

                    @Override
                    public void run() {
                        Location loc = user.getLocation();
                        loc.setX(otarget.getX());
                        loc.setZ(otarget.getZ());
                        while (LocationUtil.isBlockDamaging(loc.getWorld(), loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ())) {
                            loc.setY(loc.getY() + 1.0);
                        }
                        PaperLib.teleportAsync((Entity)user.getBase(), loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }
                }
                this.ess.scheduleSyncDelayedTask(new DelayedClickJumpTask());
            }
            catch (Exception ex) {
                if (!this.ess.getSettings().isDebug()) break block2;
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private boolean usePowertools(final User user, Material material) {
        List<String> commandList = user.getPowertool(material);
        if (commandList == null || commandList.isEmpty()) {
            return false;
        }
        boolean used = false;
        for (final String command : commandList) {
            if (command.contains("{player}")) continue;
            if (command.startsWith("c:")) {
                used = true;
                user.getBase().chat(command.substring(2));
                continue;
            }
            used = true;
            class PowerToolUseTask
            implements Runnable {
                PowerToolUseTask() {
                }

                @Override
                public void run() {
                    user.getBase().chat("/" + command);
                    LOGGER.log(Level.INFO, String.format("[PT] %s issued server command: /%s", user.getName(), command));
                }
            }
            this.ess.scheduleSyncDelayedTask(new PowerToolUseTask());
        }
        return used;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        User user;
        Inventory clickedInventory;
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (event.getRawSlot() < 0) {
            clickedInventory = null;
        } else {
            Inventory inventory = clickedInventory = event.getRawSlot() < top.getSize() ? top : event.getView().getBottomInventory();
        }
        if (type == InventoryType.PLAYER) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            InventoryHolder invHolder = top.getHolder();
            if (invHolder != null && invHolder instanceof HumanEntity) {
                User invOwner = this.ess.getUser((Player)invHolder);
                if (user.isInvSee() && (!user.isAuthorized("essentials.invsee.modify") || invOwner.isAuthorized("essentials.invsee.preventmodify") || !invOwner.getBase().isOnline())) {
                    event.setCancelled(true);
                    refreshPlayer = user.getBase();
                }
            }
        } else if (type == InventoryType.ENDER_CHEST) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            if (user.isEnderSee() && !user.isAuthorized("essentials.enderchest.modify")) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.WORKBENCH) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            if (user.isRecipeSee()) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            InventoryHolder invHolder = top.getHolder();
            if (invHolder != null && invHolder instanceof HumanEntity && user.isInvSee()) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (clickedInventory != null && clickedInventory.getType() == InventoryType.PLAYER && this.ess.getSettings().isDirectHatAllowed() && event.getClick() == ClickType.LEFT && event.getSlot() == 39 && event.getCursor().getType() != Material.AIR && event.getCursor().getType().getMaxDurability() == 0 && !MaterialUtil.isSkull(event.getCursor().getType()) && this.ess.getUser(event.getWhoClicked()).isAuthorized("essentials.hat") && !this.ess.getUser(event.getWhoClicked()).isAuthorized("essentials.hat.prevent-type." + event.getCursor().getType().name().toLowerCase())) {
            event.setCancelled(true);
            PlayerInventory inv = (PlayerInventory)clickedInventory;
            ItemStack head = inv.getHelmet();
            inv.setHelmet(event.getCursor());
            event.setCursor(head);
        }
        if (refreshPlayer != null) {
            final Player player = refreshPlayer;
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    player.updateInventory();
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        InventoryHolder invHolder;
        User user;
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.PLAYER) {
            user = this.ess.getUser((Player)event.getPlayer());
            user.setInvSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.ENDER_CHEST) {
            user = this.ess.getUser((Player)event.getPlayer());
            user.setEnderSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.WORKBENCH) {
            user = this.ess.getUser((Player)event.getPlayer());
            if (user.isRecipeSee()) {
                user.setRecipeSee(false);
                event.getView().getTopInventory().clear();
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9 && (invHolder = top.getHolder()) != null && invHolder instanceof HumanEntity) {
            User user2 = this.ess.getUser((Player)event.getPlayer());
            user2.setInvSee(false);
            refreshPlayer = user2.getBase();
        }
        if (refreshPlayer != null) {
            final Player player = refreshPlayer;
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    player.updateInventory();
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        user.updateActivityOnInteract(true);
    }

    private static boolean isEntityPickupEvent() {
        try {
            Class.forName("org.bukkit.event.entity.EntityPickupItemEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static boolean isCommandSendEvent() {
        try {
            Class.forName("org.bukkit.event.player.PlayerCommandSendEvent");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private final class CommandSendListener
    implements Listener {
        private CommandSendListener() {
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onCommandSend(PlayerCommandSendEvent event) {
            User user = EssentialsPlayerListener.this.ess.getUser(event.getPlayer());
            ArrayList removedCmds = new ArrayList(event.getCommands());
            event.getCommands().removeIf(str -> this.shouldHideFromUser((String)str, user));
            if (EssentialsPlayerListener.this.ess.getSettings().isDebug()) {
                removedCmds.removeAll(event.getCommands());
                EssentialsPlayerListener.this.ess.getLogger().info("Removed commands: " + removedCmds.toString());
            }
        }

        private boolean shouldHideFromUser(String commandLabel, User user) {
            PluginCommand command = EssentialsPlayerListener.this.ess.getServer().getPluginCommand(commandLabel);
            return command != null && command.getPlugin() == EssentialsPlayerListener.this.ess && (EssentialsPlayerListener.this.ess.getSettings().isCommandOverridden(commandLabel) || EssentialsPlayerListener.this.ess.getAlternativeCommandsHandler().getAlternative(commandLabel) == null) && !user.isAuthorized(command.getName().equals("r") ? "essentials.msg" : "essentials." + command.getName());
        }
    }

    private final class PickupListener1_12
    implements Listener {
        private PickupListener1_12() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(EntityPickupItemEvent event) {
            if (EssentialsPlayerListener.this.ess.getSettings().getDisableItemPickupWhileAfk() && event.getEntity() instanceof Player && EssentialsPlayerListener.this.ess.getUser((Player)event.getEntity()).isAfk()) {
                event.setCancelled(true);
            }
        }
    }

    private final class PickupListenerPre1_12
    implements Listener {
        private PickupListenerPre1_12() {
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onPlayerPickupItem(PlayerPickupItemEvent event) {
            if (EssentialsPlayerListener.this.ess.getSettings().getDisableItemPickupWhileAfk() && EssentialsPlayerListener.this.ess.getUser(event.getPlayer()).isAfk()) {
                event.setCancelled(true);
            }
        }
    }
}

