/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.AlternativeCommandsHandler;
import com.earth2me.essentials.Backup;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.EssentialsBlockListener;
import com.earth2me.essentials.EssentialsEntityListener;
import com.earth2me.essentials.EssentialsPlayerListener;
import com.earth2me.essentials.EssentialsPluginListener;
import com.earth2me.essentials.EssentialsServerListener;
import com.earth2me.essentials.EssentialsTimer;
import com.earth2me.essentials.EssentialsUpgrade;
import com.earth2me.essentials.ExecuteTimer;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.Jails;
import com.earth2me.essentials.Kits;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.Settings;
import com.earth2me.essentials.TNTExplodeListener;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.Worth;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.QuietAbortException;
import com.earth2me.essentials.items.AbstractItemDb;
import com.earth2me.essentials.items.FlatItemDb;
import com.earth2me.essentials.items.LegacyItemDb;
import com.earth2me.essentials.metrics.Metrics;
import com.earth2me.essentials.perm.PermissionsHandler;
import com.earth2me.essentials.register.payment.Methods;
import com.earth2me.essentials.signs.SignBlockListener;
import com.earth2me.essentials.signs.SignEntityListener;
import com.earth2me.essentials.signs.SignPlayerListener;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.Economy;
import net.ess3.api.IEssentials;
import net.ess3.api.IItemDb;
import net.ess3.api.IJails;
import net.ess3.api.ISettings;
import net.ess3.nms.PotionMetaProvider;
import net.ess3.nms.SpawnEggProvider;
import net.ess3.nms.SpawnerProvider;
import net.ess3.nms.flattened.FlatSpawnEggProvider;
import net.ess3.nms.legacy.LegacyPotionMetaProvider;
import net.ess3.nms.legacy.LegacySpawnEggProvider;
import net.ess3.nms.legacy.LegacySpawnerProvider;
import net.ess3.nms.refl.ReflSpawnEggProvider;
import net.ess3.nms.updatedmeta.BasePotionDataProvider;
import net.ess3.nms.updatedmeta.BlockMetaSpawnerProvider;
import net.ess3.nms.v1_8_R1.v1_8_R1SpawnerProvider;
import net.ess3.nms.v1_8_R2.v1_8_R2SpawnerProvider;
import net.ess3.providers.ProviderFactory;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.yaml.snakeyaml.error.YAMLException;

public class Essentials
extends JavaPlugin
implements IEssentials {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private transient ISettings settings;
    private final transient TNTExplodeListener tntListener = new TNTExplodeListener(this);
    private transient Jails jails;
    private transient Warps warps;
    private transient Worth worth;
    private transient List<IConf> confList;
    private transient Backup backup;
    private transient AbstractItemDb itemDb;
    private final transient Methods paymentMethod = new Methods();
    private transient PermissionsHandler permissionsHandler;
    private transient AlternativeCommandsHandler alternativeCommandsHandler;
    private transient UserMap userMap;
    private transient ExecuteTimer execTimer;
    private transient I18n i18n;
    private transient Metrics metrics;
    private transient EssentialsTimer timer;
    private final transient Set<String> vanishedPlayers = new LinkedHashSet<String>();
    private transient Method oldGetOnlinePlayers;
    private transient SpawnerProvider spawnerProvider;
    private transient SpawnEggProvider spawnEggProvider;
    private transient PotionMetaProvider potionMetaProvider;
    private transient Kits kits;

    public Essentials() {
    }

    public Essentials(Server server) {
        super(new JavaPluginLoader(server), new PluginDescriptionFile("Essentials", "", "com.earth2me.essentials.Essentials"), null, null);
    }

    public void forceLoadClasses() {
        try {
            Class.forName(OfflinePlayer.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ISettings getSettings() {
        return this.settings;
    }

    public void setupForTesting(Server server) throws IOException, InvalidDescriptionException {
        File dataFolder = File.createTempFile("essentialstest", "");
        if (!dataFolder.delete()) {
            throw new IOException();
        }
        if (!dataFolder.mkdir()) {
            throw new IOException();
        }
        this.i18n = new I18n(this);
        this.i18n.onEnable();
        this.i18n.updateLocale("en");
        Console.setInstance(this);
        LOGGER.log(Level.INFO, I18n.tl("usingTempFolderForTesting", new Object[0]));
        LOGGER.log(Level.INFO, dataFolder.toString());
        this.settings = new Settings(this);
        this.userMap = new UserMap(this);
        this.permissionsHandler = new PermissionsHandler(this, false);
        Economy.setEss(this);
        this.confList = new ArrayList<IConf>();
        this.jails = new Jails(this);
        this.registerListeners(server.getPluginManager());
        this.kits = new Kits(this);
    }

    public void onEnable() {
        try {
            if (LOGGER != this.getLogger()) {
                LOGGER.setParent(this.getLogger());
            }
            this.execTimer = new ExecuteTimer();
            this.execTimer.start();
            this.i18n = new I18n(this);
            this.i18n.onEnable();
            this.execTimer.mark("I18n1");
            Console.setInstance(this);
            if (!VersionUtil.isServerSupported()) {
                this.getLogger().severe(I18n.tl("serverUnsupported", new Object[0]));
            }
            PluginManager pm = this.getServer().getPluginManager();
            for (Plugin plugin : pm.getPlugins()) {
                if (!plugin.getDescription().getName().startsWith("Essentials") || plugin.getDescription().getVersion().equals(this.getDescription().getVersion()) || plugin.getDescription().getName().equals("EssentialsAntiCheat")) continue;
                this.getLogger().warning(I18n.tl("versionMismatch", plugin.getDescription().getName()));
            }
            for (Method method : Server.class.getDeclaredMethods()) {
                if (!method.getName().endsWith("getOnlinePlayers") || method.getReturnType() != Player[].class) continue;
                this.oldGetOnlinePlayers = method;
                break;
            }
            this.forceLoadClasses();
            try {
                EssentialsUpgrade essentialsUpgrade = new EssentialsUpgrade(this);
                essentialsUpgrade.beforeSettings();
                this.execTimer.mark("Upgrade");
                this.confList = new ArrayList<IConf>();
                this.settings = new Settings(this);
                this.confList.add(this.settings);
                this.execTimer.mark("Settings");
                this.userMap = new UserMap(this);
                this.confList.add(this.userMap);
                this.execTimer.mark("Init(Usermap)");
                this.kits = new Kits(this);
                this.confList.add(this.kits);
                essentialsUpgrade.convertKits();
                this.execTimer.mark("Kits");
                essentialsUpgrade.afterSettings();
                this.execTimer.mark("Upgrade2");
                this.warps = new Warps(this.getServer(), this.getDataFolder());
                this.confList.add(this.warps);
                this.execTimer.mark("Init(Spawn/Warp)");
                this.worth = new Worth(this.getDataFolder());
                this.confList.add(this.worth);
                this.itemDb = this.getItemDbFromConfig();
                this.confList.add(this.itemDb);
                this.execTimer.mark("Init(Worth/ItemDB)");
                this.jails = new Jails(this);
                this.confList.add(this.jails);
                this.execTimer.mark("Init(Jails)");
                this.spawnerProvider = (SpawnerProvider)new ProviderFactory(this.getLogger(), Arrays.asList(BlockMetaSpawnerProvider.class, v1_8_R2SpawnerProvider.class, v1_8_R1SpawnerProvider.class, LegacySpawnerProvider.class), "mob spawner").getProvider();
                this.spawnEggProvider = (SpawnEggProvider)new ProviderFactory(this.getLogger(), Arrays.asList(FlatSpawnEggProvider.class, ReflSpawnEggProvider.class, LegacySpawnEggProvider.class), "spawn egg").getProvider();
                this.potionMetaProvider = (PotionMetaProvider)new ProviderFactory(this.getLogger(), Arrays.asList(BasePotionDataProvider.class, LegacyPotionMetaProvider.class), "potion meta").getProvider();
                this.execTimer.mark("Init(Providers)");
                this.reload();
                ((Settings)this.settings)._lateLoadItemSpawnBlacklist();
            }
            catch (YAMLException yAMLException) {
                if (pm.getPlugin("EssentialsUpdate") != null) {
                    LOGGER.log(Level.SEVERE, I18n.tl("essentialsHelp2", new Object[0]));
                } else {
                    LOGGER.log(Level.SEVERE, I18n.tl("essentialsHelp1", new Object[0]));
                }
                this.handleCrash(yAMLException);
                return;
            }
            this.backup = new Backup(this);
            this.permissionsHandler = new PermissionsHandler(this, this.settings.useBukkitPermissions());
            this.alternativeCommandsHandler = new AlternativeCommandsHandler(this);
            this.timer = new EssentialsTimer(this);
            this.scheduleSyncRepeatingTask(this.timer, 1000L, 50L);
            Economy.setEss(this);
            this.execTimer.mark("RegHandler");
            for (World w : Bukkit.getWorlds()) {
                Essentials.addDefaultBackPermissionsToWorld(w);
            }
            this.metrics = new Metrics(this);
            if (this.metrics.isEnabled()) {
                this.getLogger().info("Starting Metrics. Opt-out using the global bStats config.");
            } else {
                this.getLogger().info("Metrics disabled per bStats config.");
            }
            String string = this.execTimer.end();
            if (this.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Essentials load {0}", string);
            }
        }
        catch (NumberFormatException ex) {
            this.handleCrash(ex);
        }
        catch (Error ex) {
            this.handleCrash(ex);
            throw ex;
        }
    }

    public void saveConfig() {
    }

    private void registerListeners(PluginManager pm) {
        HandlerList.unregisterAll((Plugin)this);
        if (this.getSettings().isDebug()) {
            LOGGER.log(Level.INFO, "Registering Listeners");
        }
        EssentialsPluginListener pluginListener = new EssentialsPluginListener(this);
        pm.registerEvents((Listener)pluginListener, (Plugin)this);
        this.confList.add(pluginListener);
        EssentialsPlayerListener playerListener = new EssentialsPlayerListener(this);
        playerListener.registerEvents();
        EssentialsBlockListener blockListener = new EssentialsBlockListener(this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
        SignBlockListener signBlockListener = new SignBlockListener(this);
        pm.registerEvents((Listener)signBlockListener, (Plugin)this);
        SignPlayerListener signPlayerListener = new SignPlayerListener(this);
        pm.registerEvents((Listener)signPlayerListener, (Plugin)this);
        SignEntityListener signEntityListener = new SignEntityListener(this);
        pm.registerEvents((Listener)signEntityListener, (Plugin)this);
        EssentialsEntityListener entityListener = new EssentialsEntityListener(this);
        pm.registerEvents((Listener)entityListener, (Plugin)this);
        EssentialsWorldListener worldListener = new EssentialsWorldListener(this);
        pm.registerEvents((Listener)worldListener, (Plugin)this);
        EssentialsServerListener serverListener = new EssentialsServerListener(this);
        pm.registerEvents((Listener)serverListener, (Plugin)this);
        pm.registerEvents((Listener)this.tntListener, (Plugin)this);
        this.jails.resetListener();
    }

    public void onDisable() {
        for (User user : this.getOnlineUsers()) {
            if (user.isVanished()) {
                user.setVanished(false);
                user.sendMessage(I18n.tl("unvanishedReload", new Object[0]));
            }
            user.stopTransaction();
        }
        this.cleanupOpenInventories();
        if (this.i18n != null) {
            this.i18n.onDisable();
        }
        if (this.backup != null) {
            this.backup.stopTask();
        }
        Economy.setEss(null);
        Trade.closeLog();
        this.getUserMap().getUUIDMap().shutdown();
        HandlerList.unregisterAll((Plugin)this);
    }

    @Override
    public void reload() {
        Trade.closeLog();
        for (IConf iConf : this.confList) {
            iConf.reloadConfig();
            this.execTimer.mark("Reload(" + iConf.getClass().getSimpleName() + ")");
        }
        this.i18n.updateLocale(this.settings.getLocale());
        PluginManager pm = this.getServer().getPluginManager();
        this.registerListeners(pm);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String commandLabel, String[] args) {
        return this.onTabCompleteEssentials(sender, command, commandLabel, args, Essentials.class.getClassLoader(), "com.earth2me.essentials.commands.Command", "essentials.", null);
    }

    @Override
    public List<String> onTabCompleteEssentials(CommandSender cSender, Command command, String commandLabel, String[] args, ClassLoader classLoader, String commandPath, String permissionPrefix, IEssentialsModule module) {
        PluginCommand pc;
        if (!(this.getSettings().isCommandOverridden(command.getName()) || commandLabel.startsWith("e") && !commandLabel.equalsIgnoreCase(command.getName()) || (pc = this.alternativeCommandsHandler.getAlternative(commandLabel)) == null)) {
            try {
                TabCompleter completer = pc.getTabCompleter();
                if (completer != null) {
                    return completer.onTabComplete(cSender, command, commandLabel, args);
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            IEssentialsCommand cmd;
            User user = null;
            if (cSender instanceof Player) {
                user = this.getUser((Player)cSender);
            }
            CommandSource sender = new CommandSource(cSender);
            if (this.getSettings().isCommandDisabled(commandLabel)) {
                return Collections.emptyList();
            }
            try {
                cmd = (IEssentialsCommand)classLoader.loadClass(commandPath + command.getName()).newInstance();
                cmd.setEssentials(this);
                cmd.setEssentialsModule(module);
            }
            catch (Exception ex) {
                sender.sendMessage(I18n.tl("commandNotLoaded", commandLabel));
                LOGGER.log(Level.SEVERE, I18n.tl("commandNotLoaded", commandLabel), ex);
                return Collections.emptyList();
            }
            if (user != null && !user.isAuthorized(cmd, permissionPrefix)) {
                return Collections.emptyList();
            }
            if (user != null && user.isJailed() && !user.isAuthorized(cmd, "essentials.jail.allow.")) {
                return Collections.emptyList();
            }
            try {
                if (user == null) {
                    return cmd.tabComplete(this.getServer(), sender, commandLabel, command, args);
                }
                return cmd.tabComplete(this.getServer(), user, commandLabel, command, args);
            }
            catch (Exception ex) {
                this.showError(sender, ex, commandLabel);
                LOGGER.log(Level.SEVERE, I18n.tl("commandFailed", commandLabel), ex);
                return Collections.emptyList();
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, I18n.tl("commandFailed", commandLabel), ex);
            return Collections.emptyList();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        return this.onCommandEssentials(sender, command, commandLabel, args, Essentials.class.getClassLoader(), "com.earth2me.essentials.commands.Command", "essentials.", null);
    }

    @Override
    public boolean onCommandEssentials(CommandSender cSender, Command command, String commandLabel, String[] args, ClassLoader classLoader, String commandPath, String permissionPrefix, IEssentialsModule module) {
        PluginCommand pc;
        if (!(this.getSettings().isCommandOverridden(command.getName()) || commandLabel.startsWith("e") && !commandLabel.equalsIgnoreCase(command.getName()) || (pc = this.alternativeCommandsHandler.getAlternative(commandLabel)) == null)) {
            this.alternativeCommandsHandler.executed(commandLabel, pc);
            try {
                return pc.execute(cSender, commandLabel, args);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                cSender.sendMessage(I18n.tl("internalError", new Object[0]));
                return true;
            }
        }
        try {
            IEssentialsCommand cmd;
            User user = null;
            Block bSenderBlock = null;
            if (cSender instanceof Player) {
                user = this.getUser((Player)cSender);
            } else if (cSender instanceof BlockCommandSender) {
                BlockCommandSender bsender = (BlockCommandSender)cSender;
                bSenderBlock = bsender.getBlock();
            }
            if (bSenderBlock != null) {
                if (this.getSettings().logCommandBlockCommands()) {
                    Bukkit.getLogger().log(Level.INFO, "CommandBlock at {0},{1},{2} issued server command: /{3} {4}", new Object[]{bSenderBlock.getX(), bSenderBlock.getY(), bSenderBlock.getZ(), commandLabel, EssentialsCommand.getFinalArg(args, 0)});
                }
            } else if (user == null) {
                Bukkit.getLogger().log(Level.INFO, "{0} issued server command: /{1} {2}", new Object[]{cSender.getName(), commandLabel, EssentialsCommand.getFinalArg(args, 0)});
            }
            CommandSource sender = new CommandSource(cSender);
            if (user != null && !this.getSettings().isCommandDisabled("mail") && !command.getName().equals("mail") && user.isAuthorized("essentials.mail")) {
                user.notifyOfMail();
            }
            if (commandLabel.equalsIgnoreCase("essversion")) {
                sender.sendMessage("This server is running Essentials " + this.getDescription().getVersion());
                return true;
            }
            if (this.getSettings().isCommandDisabled(commandLabel)) {
                return true;
            }
            try {
                cmd = (IEssentialsCommand)classLoader.loadClass(commandPath + command.getName()).newInstance();
                cmd.setEssentials(this);
                cmd.setEssentialsModule(module);
            }
            catch (Exception ex) {
                sender.sendMessage(I18n.tl("commandNotLoaded", commandLabel));
                LOGGER.log(Level.SEVERE, I18n.tl("commandNotLoaded", commandLabel), ex);
                return true;
            }
            if (user != null && !user.isAuthorized(cmd, permissionPrefix)) {
                LOGGER.log(Level.INFO, I18n.tl("deniedAccessCommand", user.getName()));
                user.sendMessage(I18n.tl("noAccessCommand", new Object[0]));
                return true;
            }
            if (user != null && user.isJailed() && !user.isAuthorized(cmd, "essentials.jail.allow.")) {
                if (user.getJailTimeout() > 0L) {
                    user.sendMessage(I18n.tl("playerJailedFor", user.getName(), DateUtil.formatDateDiff(user.getJailTimeout())));
                } else {
                    user.sendMessage(I18n.tl("jailMessage", new Object[0]));
                }
                return true;
            }
            try {
                if (user == null) {
                    cmd.run(this.getServer(), sender, commandLabel, command, args);
                } else {
                    cmd.run(this.getServer(), user, commandLabel, command, args);
                }
                return true;
            }
            catch (NoChargeException ex) {
                return true;
            }
            catch (QuietAbortException ex) {
                return true;
            }
            catch (NotEnoughArgumentsException ex) {
                sender.sendMessage(command.getDescription());
                sender.sendMessage(command.getUsage().replaceAll("<command>", commandLabel));
                if (!ex.getMessage().isEmpty()) {
                    sender.sendMessage(ex.getMessage());
                }
                return true;
            }
            catch (Exception ex) {
                this.showError(sender, ex, commandLabel);
                if (this.settings.isDebug()) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, I18n.tl("commandFailed", commandLabel), ex);
            return true;
        }
    }

    public void cleanupOpenInventories() {
        for (User user : this.getOnlineUsers()) {
            if (user.isRecipeSee()) {
                user.getBase().getOpenInventory().getTopInventory().clear();
                user.getBase().getOpenInventory().close();
                user.setRecipeSee(false);
            }
            if (!user.isInvSee() && !user.isEnderSee()) continue;
            user.getBase().getOpenInventory().close();
            user.setInvSee(false);
            user.setEnderSee(false);
        }
    }

    @Override
    public void showError(CommandSource sender, Throwable exception, String commandLabel) {
        sender.sendMessage(I18n.tl("errorWithMessage", exception.getMessage()));
        if (this.getSettings().isDebug()) {
            LOGGER.log(Level.INFO, I18n.tl("errorCallingCommand", commandLabel), exception);
        }
    }

    @Override
    public BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @Override
    public IJails getJails() {
        return this.jails;
    }

    @Override
    public Warps getWarps() {
        return this.warps;
    }

    @Override
    public Worth getWorth() {
        return this.worth;
    }

    @Override
    public Backup getBackup() {
        return this.backup;
    }

    @Override
    public Kits getKits() {
        return this.kits;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    @Override
    @Deprecated
    public User getUser(Object base) {
        if (base instanceof Player) {
            return this.getUser((Player)base);
        }
        if (base instanceof org.bukkit.OfflinePlayer) {
            return this.getUser(((org.bukkit.OfflinePlayer)base).getUniqueId());
        }
        if (base instanceof UUID) {
            return this.getUser((UUID)base);
        }
        if (base instanceof String) {
            return this.getOfflineUser((String)base);
        }
        return null;
    }

    @Override
    public User getUser(String base) {
        return this.getOfflineUser(base);
    }

    @Override
    public User getUser(UUID base) {
        return this.userMap.getUser(base);
    }

    @Override
    public User getOfflineUser(String name) {
        User user = this.userMap.getUser(name);
        if (user != null && user.getBase() instanceof OfflinePlayer) {
            String lastName = user.getLastAccountName();
            if (lastName != null) {
                ((OfflinePlayer)user.getBase()).setName(lastName);
            } else {
                ((OfflinePlayer)user.getBase()).setName(name);
            }
        }
        return user;
    }

    @Override
    public User getUser(Player base) {
        if (base == null) {
            return null;
        }
        if (this.userMap == null) {
            LOGGER.log(Level.WARNING, "Essentials userMap not initialized");
            return null;
        }
        User user = this.userMap.getUser(base.getUniqueId());
        if (user == null) {
            if (this.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Constructing new userfile from base player {0}", base.getName());
            }
            user = new User(base, this);
        } else {
            user.update(base);
        }
        return user;
    }

    private void handleCrash(Throwable exception) {
        PluginManager pm = this.getServer().getPluginManager();
        LOGGER.log(Level.SEVERE, exception.toString());
        exception.printStackTrace();
        pm.registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOW)
            public void onPlayerJoin(PlayerJoinEvent event) {
                event.getPlayer().sendMessage("Essentials failed to load, read the log file.");
            }
        }, (Plugin)this);
        for (Player player : this.getOnlinePlayers()) {
            player.sendMessage("Essentials failed to load, read the log file.");
        }
        this.setEnabled(false);
    }

    @Override
    public World getWorld(String name) {
        int worldId;
        if (name.matches("[0-9]+") && (worldId = Integer.parseInt(name)) < this.getServer().getWorlds().size()) {
            return (World)this.getServer().getWorlds().get(worldId);
        }
        return this.getServer().getWorld(name);
    }

    @Override
    public void addReloadListener(IConf listener) {
        this.confList.add(listener);
    }

    @Override
    public Methods getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    public int broadcastMessage(String message) {
        return this.broadcastMessage(null, null, message, true);
    }

    @Override
    public int broadcastMessage(IUser sender, String message) {
        return this.broadcastMessage(sender, null, message, false);
    }

    @Override
    public int broadcastMessage(String permission, String message) {
        return this.broadcastMessage(null, permission, message, false);
    }

    private int broadcastMessage(IUser sender, String permission, String message, boolean keywords) {
        if (sender != null && sender.isHidden()) {
            return 0;
        }
        IText broadcast = new SimpleTextInput(message);
        Collection<Player> players = this.getOnlinePlayers();
        for (Player player : players) {
            User user = this.getUser(player);
            if ((permission != null || sender != null && user.isIgnoredPlayer(sender)) && (permission == null || !user.isAuthorized(permission))) continue;
            if (keywords) {
                broadcast = new KeywordReplacer(broadcast, new CommandSource((CommandSender)player), this, false);
            }
            for (String messageText : broadcast.getLines()) {
                user.sendMessage(messageText);
            }
        }
        return players.size();
    }

    @Override
    public BukkitTask runTaskAsynchronously(Runnable run) {
        return this.getScheduler().runTaskAsynchronously((Plugin)this, run);
    }

    @Override
    public BukkitTask runTaskLaterAsynchronously(Runnable run, long delay) {
        return this.getScheduler().runTaskLaterAsynchronously((Plugin)this, run, delay);
    }

    @Override
    public BukkitTask runTaskTimerAsynchronously(Runnable run, long delay, long period) {
        return this.getScheduler().runTaskTimerAsynchronously((Plugin)this, run, delay, period);
    }

    @Override
    public int scheduleSyncDelayedTask(Runnable run) {
        return this.getScheduler().scheduleSyncDelayedTask((Plugin)this, run);
    }

    @Override
    public int scheduleSyncDelayedTask(Runnable run, long delay) {
        return this.getScheduler().scheduleSyncDelayedTask((Plugin)this, run, delay);
    }

    @Override
    public int scheduleSyncRepeatingTask(Runnable run, long delay, long period) {
        return this.getScheduler().scheduleSyncRepeatingTask((Plugin)this, run, delay, period);
    }

    @Override
    public TNTExplodeListener getTNTListener() {
        return this.tntListener;
    }

    @Override
    public PermissionsHandler getPermissionsHandler() {
        return this.permissionsHandler;
    }

    @Override
    public AlternativeCommandsHandler getAlternativeCommandsHandler() {
        return this.alternativeCommandsHandler;
    }

    @Override
    public IItemDb getItemDb() {
        return this.itemDb;
    }

    @Override
    public UserMap getUserMap() {
        return this.userMap;
    }

    @Override
    public I18n getI18n() {
        return this.i18n;
    }

    @Override
    public EssentialsTimer getTimer() {
        return this.timer;
    }

    @Override
    public List<String> getVanishedPlayers() {
        return Collections.unmodifiableList(new ArrayList<String>(this.vanishedPlayers));
    }

    @Override
    public Collection<String> getVanishedPlayersNew() {
        return this.vanishedPlayers;
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        try {
            return this.getServer().getOnlinePlayers();
        }
        catch (NoSuchMethodError ex) {
            try {
                return Arrays.asList((Player[])this.oldGetOnlinePlayers.invoke((Object)this.getServer(), new Object[0]));
            }
            catch (InvocationTargetException ex1) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (IllegalAccessException ex1) {
                throw new RuntimeException("Error invoking oldGetOnlinePlayers", ex1);
            }
        }
    }

    @Override
    public Iterable<User> getOnlineUsers() {
        return Iterables.transform(this.getOnlinePlayers(), (Function)new Function<Player, User>(){

            public User apply(Player player) {
                return Essentials.this.getUser(player);
            }
        });
    }

    @Override
    public SpawnerProvider getSpawnerProvider() {
        return this.spawnerProvider;
    }

    @Override
    public SpawnEggProvider getSpawnEggProvider() {
        return this.spawnEggProvider;
    }

    @Override
    public PotionMetaProvider getPotionMetaProvider() {
        return this.potionMetaProvider;
    }

    private static void addDefaultBackPermissionsToWorld(World w) {
        String permName = "essentials.back.into." + w.getName();
        Permission p = Bukkit.getPluginManager().getPermission(permName);
        if (p == null) {
            p = new Permission(permName, "Allows access to /back when the destination location is within world " + w.getName(), PermissionDefault.TRUE);
            Bukkit.getPluginManager().addPermission(p);
        }
    }

    private AbstractItemDb getItemDbFromConfig() {
        String setting = this.settings.getItemDbType();
        if (setting.equalsIgnoreCase("json")) {
            return new FlatItemDb(this);
        }
        if (setting.equalsIgnoreCase("csv")) {
            return new LegacyItemDb(this);
        }
        VersionUtil.BukkitVersion version = VersionUtil.getServerBukkitVersion();
        if (version.isHigherThanOrEqualTo(VersionUtil.v1_13_0_R01)) {
            return new FlatItemDb(this);
        }
        return new LegacyItemDb(this);
    }

    private static class EssentialsWorldListener
    implements Listener,
    Runnable {
        private final transient IEssentials ess;

        public EssentialsWorldListener(IEssentials ess) {
            this.ess = ess;
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onWorldLoad(WorldLoadEvent event) {
            Essentials.addDefaultBackPermissionsToWorld(event.getWorld());
            this.ess.getJails().onReload();
            this.ess.getWarps().reloadConfig();
            for (IConf iConf : ((Essentials)this.ess).confList) {
                if (!(iConf instanceof IEssentialsModule)) continue;
                iConf.reloadConfig();
            }
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onWorldUnload(WorldUnloadEvent event) {
            this.ess.getJails().onReload();
            this.ess.getWarps().reloadConfig();
            for (IConf iConf : ((Essentials)this.ess).confList) {
                if (!(iConf instanceof IEssentialsModule)) continue;
                iConf.reloadConfig();
            }
        }

        @Override
        public void run() {
            this.ess.reload();
        }
    }
}

