/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.matchers;

import com.griefcraft.util.ProtectionFinder;
import com.griefcraft.util.VersionUtil;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class WallMatcher
implements ProtectionFinder.Matcher {
    public static final Set<Material> PROTECTABLES_WALL = EnumSet.of(Material.WHITE_WALL_BANNER, new Material[]{Material.ORANGE_WALL_BANNER, Material.MAGENTA_WALL_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.YELLOW_WALL_BANNER, Material.LIME_WALL_BANNER, Material.PINK_WALL_BANNER, Material.GRAY_WALL_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.CYAN_WALL_BANNER, Material.PURPLE_WALL_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_WALL_BANNER, Material.GREEN_WALL_BANNER, Material.RED_WALL_BANNER, Material.BLACK_WALL_BANNER});
    public static final Set<Material> PROTECTABLES_LEVERS_ET_AL;
    public static final BlockFace[] POSSIBLE_FACES;

    @Override
    public boolean matches(ProtectionFinder finder) {
        Block block = finder.getBaseBlock().getBlock();
        for (BlockFace blockFace : POSSIBLE_FACES) {
            Block matched;
            Block face = block.getRelative(blockFace);
            if (face == null || (matched = this.tryMatchBlock(face, blockFace)) == null) continue;
            finder.addBlock(matched);
            return true;
        }
        return false;
    }

    private Block tryMatchBlock(Block block, BlockFace matchingFace) {
        byte direction = block.getData();
        BlockData blockData = block.getBlockData();
        if (PROTECTABLES_WALL.contains(block.getType()) && blockData instanceof Directional) {
            if (((Directional)block.getState().getBlockData()).getFacing() == matchingFace) {
                return block;
            }
        } else if (PROTECTABLES_LEVERS_ET_AL.contains(block.getType())) {
            int EAST = 4;
            int WEST = 3;
            int SOUTH = 1;
            int NORTH = 2;
            if (matchingFace == BlockFace.EAST && (direction & EAST) == EAST) {
                return block;
            }
            if (matchingFace == BlockFace.WEST && (direction & WEST) == WEST) {
                return block;
            }
            if (matchingFace == BlockFace.SOUTH && (direction & SOUTH) == SOUTH) {
                return block;
            }
            if (matchingFace == BlockFace.NORTH && (direction & NORTH) == NORTH) {
                return block;
            }
        }
        return null;
    }

    static {
        if (VersionUtil.getMinorVersion() > 13) {
            PROTECTABLES_WALL.addAll(EnumSet.of(Material.OAK_WALL_SIGN, new Material[]{Material.BIRCH_WALL_SIGN, Material.SPRUCE_WALL_SIGN, Material.JUNGLE_WALL_SIGN, Material.ACACIA_WALL_SIGN, Material.DARK_OAK_WALL_SIGN}));
        } else {
            PROTECTABLES_WALL.add(Material.getMaterial((String)"WALL_SIGN"));
        }
        PROTECTABLES_LEVERS_ET_AL = EnumSet.of(Material.LEVER, new Material[]{Material.OAK_BUTTON, Material.BIRCH_BUTTON, Material.SPRUCE_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.DARK_OAK_BUTTON, Material.STONE_BUTTON});
        POSSIBLE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    }
}

