/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util.matchers;

import com.griefcraft.util.ProtectionFinder;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.Chest;

public class DoubleChestMatcher
implements ProtectionFinder.Matcher {
    public static final Set<Material> PROTECTABLES_CHESTS = EnumSet.of(Material.CHEST, Material.TRAPPED_CHEST);
    public static final BlockFace[] POSSIBLE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};

    @Override
    public boolean matches(ProtectionFinder finder) {
        BlockState baseBlockState = finder.getBaseBlock();
        Chest baseBlockData = null;
        try {
            baseBlockData = (Chest)baseBlockState.getBlockData();
        }
        catch (ClassCastException e) {
            return false;
        }
        BlockFace neighboringBlockFace = DoubleChestMatcher.getNeighboringChestBlockFace(baseBlockData);
        if (neighboringBlockFace == null) {
            return false;
        }
        Block neighboringBlock = baseBlockState.getBlock().getRelative(neighboringBlockFace);
        if (baseBlockState.getType() == neighboringBlock.getType()) {
            finder.addBlock(neighboringBlock);
            return true;
        }
        return false;
    }

    public static BlockFace getNeighboringChestBlockFace(Chest chest) {
        if (chest.getType() == Chest.Type.SINGLE) {
            return null;
        }
        BlockFace face = chest.getFacing();
        switch (face) {
            case NORTH: {
                return chest.getType() == Chest.Type.LEFT ? BlockFace.EAST : BlockFace.WEST;
            }
            case SOUTH: {
                return chest.getType() == Chest.Type.LEFT ? BlockFace.WEST : BlockFace.EAST;
            }
            case EAST: {
                return chest.getType() == Chest.Type.LEFT ? BlockFace.SOUTH : BlockFace.NORTH;
            }
            case WEST: {
                return chest.getType() == Chest.Type.LEFT ? BlockFace.NORTH : BlockFace.SOUTH;
            }
        }
        return null;
    }
}

