/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.lwc.LWC;
import java.net.URL;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater {
    static final String VERSION_URL = "https://api.spiget.org/v2/resources/2162/versions?size=2147483647&spiget__ua=SpigetDocs";
    static final String DESCRIPTION_URL = "https://api.spiget.org/v2/resources/2162/updates?size=2147483647&spiget__ua=SpigetDocs";

    public void init() {
        final LWC lwc = LWC.getInstance();
        if (lwc.getConfiguration().getBoolean("core.updateNotifier", true)) {
            lwc.getPlugin().getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)lwc.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Object[] updates = Updater.getLastUpdate();
                    if (updates.length == 2) {
                        lwc.log("[ModernLWC] New update avaible:");
                        lwc.log("New version: " + updates[0]);
                        lwc.log("Your version: " + LWC.getInstance().getPlugin().getDescription().getVersion());
                        lwc.log("What's new: " + updates[1]);
                    }
                }
            });
        }
    }

    public static Object[] getLastUpdate() {
        try {
            JSONArray versionsArray = (JSONArray)JSONValue.parseWithException((String)new URL(String.valueOf(VERSION_URL)).toString());
            Double lastVersion = Double.parseDouble(((JSONObject)versionsArray.get(versionsArray.size() - 1)).get((Object)"name").toString());
            if (lastVersion > Double.parseDouble(LWC.getInstance().getPlugin().getDescription().getVersion())) {
                JSONArray updatesArray = (JSONArray)JSONValue.parseWithException((String)new URL(String.valueOf(DESCRIPTION_URL)).toString());
                String updateName = ((JSONObject)updatesArray.get(updatesArray.size() - 1)).get((Object)"title").toString();
                Object[] update = new Object[]{lastVersion, updateName};
                return update;
            }
        }
        catch (Exception e) {
            return new String[0];
        }
        return new String[0];
    }
}

