/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.util.NameFetcher;
import com.griefcraft.util.UUIDFetcher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class UUIDRegistry {
    private static final Map<String, PlayerInfo> nameToUUIDCache = new HashMap<String, PlayerInfo>();
    private static final Map<UUID, PlayerInfo> UUIDToNameCache = new HashMap<UUID, PlayerInfo>();

    public static void updateCache(UUID uuid, String name) {
        PlayerInfo playerInfo = new PlayerInfo(uuid, name);
        nameToUUIDCache.put(name.toLowerCase(), playerInfo);
        UUIDToNameCache.put(uuid, playerInfo);
    }

    public static boolean isValidUUID(String uuid) {
        return uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    }

    public static String getName(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (UUIDToNameCache.containsKey(uuid)) {
            return UUIDToNameCache.get(uuid).getName();
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            UUIDRegistry.updateCache(uuid, player.getName());
            return player.getName();
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offlinePlayer != null && offlinePlayer.getName() != null) {
            UUIDRegistry.updateCache(uuid, offlinePlayer.getName());
            return offlinePlayer.getName();
        }
        try {
            Object results = new NameFetcher(Arrays.asList(uuid)).call();
            if (results.containsKey(uuid)) {
                UUIDRegistry.updateCache(uuid, (String)results.get(uuid));
                return (String)results.get(uuid);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static UUID getUUID(String name) {
        String nameLower = name.toLowerCase();
        try {
            if (nameToUUIDCache.containsKey(nameLower)) {
                return nameToUUIDCache.get(nameLower).getUUID();
            }
            if (UUIDRegistry.isValidUUID(name)) {
                return UUID.fromString(name);
            }
            if (Bukkit.getOnlineMode()) {
                Object results = new UUIDFetcher(Arrays.asList(nameLower)).call();
                for (String key : results.keySet()) {
                    if (!key.equalsIgnoreCase(name)) continue;
                    UUID uuid = (UUID)results.get(key);
                    UUIDRegistry.updateCache(uuid, key);
                    return uuid;
                }
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
                if (offlinePlayer != null && offlinePlayer.getUniqueId() != null) {
                    if (offlinePlayer.getName() != null) {
                        name = offlinePlayer.getName();
                    }
                    UUIDRegistry.updateCache(offlinePlayer.getUniqueId(), name);
                    return offlinePlayer.getUniqueId();
                }
            }
            nameToUUIDCache.put(nameLower, null);
            return null;
        }
        catch (Exception e) {
            nameToUUIDCache.put(nameLower, null);
            return null;
        }
    }

    public static String formatPlayerName(String name, boolean showUUID) {
        if (UUIDRegistry.isValidUUID(name)) {
            String formattedName = UUIDRegistry.getName(UUID.fromString(name));
            return (formattedName == null ? "Unknown" : formattedName) + (showUUID ? " (" + name + ")" : "");
        }
        return name;
    }

    public static String formatPlayerName(String name) {
        return UUIDRegistry.formatPlayerName(name, true);
    }

    static class PlayerInfo {
        private UUID uuid;
        private String name;

        public PlayerInfo(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }
    }
}

