/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.util;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.sql.PhysDB;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DatabaseThread
implements Runnable {
    private final LWC lwc;
    private final Queue<Protection> updateQueue = new ConcurrentLinkedQueue<Protection>();
    private final Thread thread = new Thread(this);
    private boolean running = false;
    private long lastFlush = -1L;
    private long nextKeepalivePacket = 0L;
    private int pingInterval = 0;

    public DatabaseThread(LWC lwc) {
        this.lwc = lwc;
        this.running = true;
        this.lastFlush = System.currentTimeMillis();
        this.thread.start();
        this.pingInterval = lwc.getConfiguration().getInt("database.ping_interval", 300);
    }

    public void addProtection(Protection protection) {
        this.updateQueue.offer(protection);
    }

    public void removeProtection(Protection protection) {
        this.updateQueue.remove(protection);
    }

    public int size() {
        return this.updateQueue.size();
    }

    public void stop() {
        this.running = false;
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        this.flushDatabase();
    }

    public void flush() {
        this.lastFlush = System.currentTimeMillis() - 9999999L;
    }

    private void flushDatabase() {
        if (!this.updateQueue.isEmpty()) {
            PhysDB database = this.lwc.getPhysicalDatabase();
            database.setAutoCommit(false);
            database.setUseStatementCache(false);
            Iterator iter = this.updateQueue.iterator();
            while (iter.hasNext()) {
                Protection protection = (Protection)iter.next();
                iter.remove();
                protection.saveNow();
            }
            database.setUseStatementCache(true);
            database.setAutoCommit(true);
        }
        this.lastFlush = System.currentTimeMillis();
        if (System.currentTimeMillis() > this.nextKeepalivePacket && this.lwc.getPhysicalDatabase().isConnected()) {
            this.nextKeepalivePacket = System.currentTimeMillis() + (long)(this.pingInterval * 1000);
            this.lwc.getPhysicalDatabase().pingDatabase();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            long intervalMilliseconds;
            long currentTime;
            int interval = this.lwc.getConfiguration().getInt("core.flushInterval", 5);
            if (interval > 120) {
                interval = 120;
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastFlush > (intervalMilliseconds = (long)interval * 1000L)) {
                this.flushDatabase();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.running = false;
            }
        }
    }
}

