/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.towny;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import java.lang.reflect.Method;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyModule
extends JavaModule {
    private boolean townyBorders;
    private Towny towny;

    @Override
    public void load(LWC lwc) {
        this.townyBorders = lwc.getConfiguration().getBoolean("core.townyBorders", false);
        Plugin townyPlugin = lwc.getPlugin().getServer().getPluginManager().getPlugin("Towny");
        if (townyPlugin == null) {
            return;
        }
        this.towny = (Towny)townyPlugin;
    }

    private void trigger(LWCProtectionRegisterEvent event) {
        event.getLWC().sendLocale((CommandSender)event.getPlayer(), "lwc.towny.blocked", new Object[0]);
        event.setCancelled(true);
    }

    @Override
    public void onAccessRequest(LWCAccessEvent event) {
        Player player = event.getPlayer();
        Protection protection = event.getProtection();
        if (event.getAccess() != Permission.Access.NONE) {
            return;
        }
        if (protection.getType() != Protection.Type.PRIVATE) {
            return;
        }
        if (this.towny == null) {
            return;
        }
        for (Permission permission : protection.getPermissions()) {
            if (permission.getType() != Permission.Type.TOWN) continue;
            String townName = permission.getName();
            try {
                Town town = this.towny.getTownyUniverse().getTown(townName);
                if (town == null) {
                    return;
                }
                if (!town.hasResident(player.getName())) {
                    event.setAccess(Permission.Access.NONE);
                } else {
                    event.setAccess(Permission.Access.PLAYER);
                }
                if (!town.getMayor().getName().equalsIgnoreCase(player.getName())) continue;
                event.setAccess(Permission.Access.ADMIN);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.townyBorders || this.towny == null) {
            return;
        }
        Block block = event.getBlock();
        TownyWorld world = null;
        try {
            try {
                this.towny.getTownyUniverse();
                world = TownyUniverse.getWorld((String)block.getWorld().getName());
            }
            catch (IncompatibleClassChangeError e) {
                try {
                    Method method = TownyUniverse.class.getDeclaredMethod("getWorld", String.class);
                    world = (TownyWorld)method.invoke(null, block.getWorld().getName());
                }
                catch (Exception ex) {
                    this.trigger(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.trigger(event);
            return;
        }
        if (!world.isUsingTowny()) {
            return;
        }
    }
}

