/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.pluginsupport;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.palmergames.bukkit.towny.event.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Towny
extends JavaModule {
    private boolean townyBorders;
    private com.palmergames.bukkit.towny.Towny towny = null;

    @Override
    public void load(LWC lwc) {
        this.townyBorders = lwc.getConfiguration().getBoolean("core.townyBorders", false);
        Plugin townyPlugin = lwc.getPlugin().getServer().getPluginManager().getPlugin("Towny");
        if (townyPlugin == null) {
            return;
        }
        this.towny = (com.palmergames.bukkit.towny.Towny)townyPlugin;
    }

    private void trigger(LWCProtectionRegisterEvent event) {
        event.getLWC().sendLocale((CommandSender)event.getPlayer(), "lwc.towny.blocked", new Object[0]);
        event.setCancelled(true);
    }

    @Override
    public void onAccessRequest(LWCAccessEvent event) {
        Player player = event.getPlayer();
        Protection protection = event.getProtection();
        if (event.getAccess() != Permission.Access.NONE) {
            return;
        }
        if (protection.getType() != Protection.Type.PRIVATE) {
            return;
        }
        if (this.towny == null) {
            return;
        }
        for (Permission permission : protection.getPermissions()) {
            if (permission.getType() != Permission.Type.TOWN) continue;
            try {
                Town town = WorldCoord.parseWorldCoord((Block)event.getProtection().getBlock()).getTownBlock().getTown();
                if (town == null) {
                    return;
                }
                if (!town.hasResident(player.getName())) {
                    event.setAccess(Permission.Access.NONE);
                    continue;
                }
                if (town.getMayor().getName().equalsIgnoreCase(player.getName())) {
                    event.setAccess(Permission.Access.ADMIN);
                    continue;
                }
                event.setAccess(Permission.Access.PLAYER);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.townyBorders || this.towny == null) {
            return;
        }
        Block block = event.getBlock();
        TownyWorld world = null;
        try {
            try {
                world = WorldCoord.parseWorldCoord((Block)block).getTownyWorld();
            }
            catch (IncompatibleClassChangeError e) {
                try {
                    Method method = TownyUniverse.class.getDeclaredMethod("getWorld", String.class);
                    world = (TownyWorld)method.invoke(null, block.getWorld().getName());
                }
                catch (Exception ex) {
                    this.trigger(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.trigger(event);
            return;
        }
        if (!world.isUsingTowny()) {
            return;
        }
        try {
            TownBlock townBlock = world.getTownBlock(Coord.parseCoord((Block)block));
            if (!townBlock.getTown().hasResident(event.getPlayer().getName())) {
                this.trigger(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unclaimTowny(TownUnclaimEvent event) throws NotRegisteredException, TownyException {
        if (this.towny == null) {
            return;
        }
        List wcl = AreaSelectionUtil.selectWorldCoordArea((TownBlockOwner)event.getTown(), (WorldCoord)event.getWorldCoord(), (String[])new String[]{"auto"});
        wcl = AreaSelectionUtil.filterOwnedBlocks((TownBlockOwner)event.getTown(), (List)wcl);
        for (WorldCoord wc : wcl) {
            PlotBlockData pbd = new PlotBlockData(wc.getTownBlock());
            for (int z = 0; z < pbd.getSize(); ++z) {
                for (int x = 0; x < pbd.getSize(); ++x) {
                    for (int y = pbd.getHeight(); y > 0; --y) {
                        Block b = event.getWorldCoord().getBukkitWorld().getBlockAt(pbd.getX() * pbd.getSize() + x, y, pbd.getZ() * pbd.getSize() + z);
                        LWC lwc = LWC.getInstance();
                        Protection protection = lwc.getPhysicalDatabase().loadProtection(event.getWorldCoord().getWorldName(), b.getX(), b.getY(), b.getZ());
                        if (protection == null) continue;
                        protection.remove();
                    }
                }
            }
        }
    }
}

