/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.modes;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Mode;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import java.util.Map;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DropTransferModule
extends JavaModule {
    private LWC lwc;

    @Override
    public void load(LWC lwc) {
        this.lwc = lwc;
    }

    private boolean isPlayerDropTransferring(LWCPlayer player) {
        return player.hasMode("+dropTransfer");
    }

    private int getPlayerDropTransferTarget(LWCPlayer player) {
        Mode mode = player.getMode("dropTransfer");
        if (mode == null) {
            return -1;
        }
        String target = mode.getData();
        try {
            return Integer.parseInt(target);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void onDropItem(LWCDropItemEvent event) {
        Player bPlayer = event.getPlayer();
        Item item = event.getEvent().getItemDrop();
        ItemStack itemStack = item.getItemStack();
        LWCPlayer player = this.lwc.wrapPlayer((CommandSender)bPlayer);
        int protectionId = this.getPlayerDropTransferTarget(player);
        if (protectionId == -1) {
            return;
        }
        if (!this.isPlayerDropTransferring(player)) {
            return;
        }
        Protection protection = this.lwc.getPhysicalDatabase().loadProtection(protectionId);
        if (protection == null) {
            this.lwc.sendLocale(player, "lwc.nolongerexists", new Object[0]);
            player.disableMode(player.getMode("dropTransfer"));
            return;
        }
        World world = player.getServer().getWorld(protection.getWorld());
        if (world == null) {
            this.lwc.sendLocale(player, "lwc.invalidworld", new Object[0]);
            player.disableMode(player.getMode("dropTransfer"));
            return;
        }
        if (bPlayer.getWorld() != world && !this.lwc.getConfiguration().getBoolean("modes.droptransfer.crossWorld", false)) {
            this.lwc.sendLocale(player, "lwc.dropxfer.acrossworlds", new Object[0]);
            player.disableMode(player.getMode("dropTransfer"));
            return;
        }
        Block block = world.getBlockAt(protection.getX(), protection.getY(), protection.getZ());
        Map<Integer, ItemStack> remaining = this.lwc.depositItems(block, itemStack);
        if (remaining == null || remaining.size() > 0) {
            this.lwc.sendLocale(player, "lwc.dropxfer.chestfull", new Object[0]);
            event.getEvent().setCancelled(true);
        }
        bPlayer.updateInventory();
        item.remove();
    }

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Set<String> actions = event.getActions();
        boolean canAccess = event.canAccess();
        Player bPlayer = event.getPlayer();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)bPlayer);
        if (!actions.contains("dropTransferSelect")) {
            return;
        }
        if (!canAccess) {
            lwc.sendLocale(player, "protection.interact.dropxfer.noaccess", new Object[0]);
        } else {
            if (event.getEvent().getClickedBlock() instanceof Container) {
                lwc.sendLocale(player, "protection.interact.dropxfer.notchest", new Object[0]);
                player.removeAllActions();
                event.setResult(Module.Result.CANCEL);
                return;
            }
            Mode mode = new Mode();
            mode.setName("dropTransfer");
            mode.setData(protection.getId() + "");
            mode.setPlayer(bPlayer);
            player.enableMode(mode);
            mode = new Mode();
            mode.setName("+dropTransfer");
            mode.setPlayer(bPlayer);
            player.enableMode(mode);
            lwc.sendLocale(player, "protection.interact.dropxfer.finalize", new Object[0]);
        }
        player.removeAllActions();
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        Player player = event.getPlayer();
        Set<String> actions = event.getActions();
        if (!actions.contains("dropTransferSelect")) {
            return;
        }
        this.lwc.sendLocale((CommandSender)player, "protection.interact.dropxfer.notprotected", new Object[0]);
        this.lwc.removeModes((CommandSender)player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (!event.hasFlag("p", "mode")) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        LWCPlayer player = lwc.wrapPlayer(sender);
        String mode = args[0].toLowerCase();
        if (!mode.equals("droptransfer")) {
            return;
        }
        event.setCancelled(true);
        mode = "dropTransfer";
        if (args.length < 2) {
            lwc.sendLocale(player, "protection.modes.dropxfer.help", new Object[0]);
            return;
        }
        String action = args[1].toLowerCase();
        player.getName();
        if (action.equals("select")) {
            if (this.isPlayerDropTransferring(player)) {
                lwc.sendLocale(player, "protection.modes.dropxfer.select.error", new Object[0]);
                return;
            }
            player.disableMode(player.getMode(mode));
            Action temp = new Action();
            temp.setName("dropTransferSelect");
            temp.setPlayer(player);
            player.addAction(temp);
            lwc.sendLocale(player, "protection.modes.dropxfer.select.finalize", new Object[0]);
        } else if (action.equals("on")) {
            int target = this.getPlayerDropTransferTarget(player);
            if (target == -1) {
                lwc.sendLocale(player, "protection.modes.dropxfer.selectchest", new Object[0]);
                return;
            }
            Mode temp = new Mode();
            temp.setName("+dropTransfer");
            temp.setPlayer(player.getBukkitPlayer());
            player.enableMode(temp);
            lwc.sendLocale(player, "protection.modes.dropxfer.on.finalize", new Object[0]);
        } else if (action.equals("off")) {
            int target = this.getPlayerDropTransferTarget(player);
            if (target == -1) {
                lwc.sendLocale(player, "protection.modes.dropxfer.selectchest", new Object[0]);
                return;
            }
            player.disableMode(player.getMode("+dropTransfer"));
            lwc.sendLocale(player, "protection.modes.dropxfer.off.finalize", new Object[0]);
        } else if (action.equals("status")) {
            if (this.getPlayerDropTransferTarget(player) == -1) {
                lwc.sendLocale(player, "protection.modes.dropxfer.status.off", new Object[0]);
            } else if (this.isPlayerDropTransferring(player)) {
                lwc.sendLocale(player, "protection.modes.dropxfer.status.active", new Object[0]);
            } else {
                lwc.sendLocale(player, "protection.modes.dropxfer.status.inactive", new Object[0]);
            }
        }
    }
}

