/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.flag;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCMagnetPullEvent;
import com.griefcraft.util.config.Configuration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MagnetModule
extends JavaModule {
    private Configuration configuration = Configuration.load("magnet.yml");
    private boolean enabled = false;
    private List<Material> itemBlacklist;
    private int radius;
    private int perSweep;
    private final Queue<MagnetNode> items = new LinkedList<MagnetNode>();

    public static boolean isDisplay(Entity entity) {
        try {
            ItemMeta itemMeta;
            if (entity.getType() == EntityType.DROPPED_ITEM ? (itemMeta = ((Item)entity).getItemStack().getItemMeta()) != null && MagnetModule.containsLocation(itemMeta.getDisplayName()) : entity.getType() == EntityType.ARMOR_STAND && MagnetModule.containsLocation(entity.getCustomName())) {
                return true;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return false;
    }

    public static boolean containsLocation(String s) {
        if (s == null) {
            return false;
        }
        return s.startsWith("***{") && s.indexOf(44) != s.lastIndexOf(44) && s.indexOf(125) != -1;
    }

    @Override
    public void load(LWC lwc) {
        this.enabled = this.configuration.getBoolean("magnet.enabled", false);
        this.itemBlacklist = new ArrayList<Material>();
        this.radius = this.configuration.getInt("magnet.radius", 3);
        this.perSweep = this.configuration.getInt("magnet.perSweep", 20);
        if (!this.enabled) {
            return;
        }
        List<String> temp = this.configuration.getStringList("magnet.blacklist", new ArrayList<String>());
        for (String item : temp) {
            Material material = Material.matchMaterial((String)item);
            if (material == null) continue;
            this.itemBlacklist.add(material);
        }
        MagnetTask searchThread = new MagnetTask();
        lwc.getPlugin().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)lwc.getPlugin(), (Runnable)searchThread, 50L, 50L);
    }

    private class MagnetTask
    implements Runnable {
        private MagnetTask() {
        }

        @Override
        public void run() {
            MagnetNode node;
            Server server = Bukkit.getServer();
            LWC lwc = LWC.getInstance();
            if (MagnetModule.this.items.size() == 0) {
                for (World world : server.getWorlds()) {
                    block3: for (Entity entity : world.getEntities()) {
                        if (MagnetModule.isDisplay(entity) || !(entity instanceof Item)) continue;
                        Item item = (Item)entity;
                        ItemStack stack = item.getItemStack();
                        if (MagnetModule.this.itemBlacklist.contains(stack.getType()) || stack.getAmount() <= 0 || item.isDead()) continue;
                        LWCMagnetPullEvent event = new LWCMagnetPullEvent(item);
                        lwc.getModuleLoader().dispatchEvent(event);
                        if (event.isCancelled()) continue;
                        Location location = item.getLocation();
                        int x = location.getBlockX();
                        int y = location.getBlockY();
                        int z = location.getBlockZ();
                        List<Protection> protections = lwc.getPhysicalDatabase().loadProtections(world.getName(), x, y, z, MagnetModule.this.radius);
                        for (Protection protection : protections) {
                            if (!protection.hasFlag(Flag.Type.MAGNET) || protection.getBukkitWorld().getName() != item.getWorld().getName() || !(protection.getBlock().getState() instanceof InventoryHolder) || item.getItemStack().getType().toString().contains("SHULKER_BOX") && protection.getBlock().getType().toString().contains("SHULKER_BOX")) continue;
                            MagnetNode node2 = new MagnetNode();
                            node2.item = item;
                            node2.protection = protection;
                            MagnetModule.this.items.offer(node2);
                            continue block3;
                        }
                    }
                }
            }
            int count = 0;
            while ((node = (MagnetNode)MagnetModule.this.items.poll()) != null) {
                Map<Integer, ItemStack> remaining;
                Item item = node.item;
                Protection protection = node.protection;
                World world = item.getWorld();
                ItemStack itemStack = item.getItemStack();
                Location location = item.getLocation();
                Block block = protection.getBlock();
                if (item.isDead()) continue;
                try {
                    remaining = lwc.depositItems(block, itemStack);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                if (remaining == null) continue;
                if (remaining.size() == 1) {
                    ItemStack other = remaining.values().iterator().next();
                    if (itemStack.getType() == other.getType() && itemStack.getAmount() == other.getAmount()) continue;
                }
                item.remove();
                if (remaining.size() > 0) {
                    for (ItemStack stack : remaining.values()) {
                        world.dropItemNaturally(location, stack);
                    }
                }
                if (count > MagnetModule.this.perSweep) break;
                ++count;
            }
        }
    }

    private class MagnetNode {
        Item item;
        Protection protection;

        private MagnetNode() {
        }
    }
}

