/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.fix;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.matchers.DoubleChestMatcher;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FixModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() == Module.Result.CANCEL) {
            return;
        }
        if (!event.hasAction("fix")) {
            return;
        }
        LWC lwc = event.getLWC();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        Protection protection = event.getProtection();
        Block block = protection.getBlock();
        if (!lwc.canAdminProtection(event.getPlayer(), protection)) {
            return;
        }
        if (DoubleChestMatcher.PROTECTABLES_CHESTS.contains(block.getType()) || block.getType() == Material.FURNACE || block.getType() == Material.DISPENSER) {
            lwc.adjustChestDirection(block, event.getEvent().getBlockFace());
            lwc.sendLocale(player, "lwc.fix.fixed", "block", block.getType().toString().toLowerCase());
            player.removeAction(player.getAction("fix"));
        }
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getSender() instanceof Player)) {
            return;
        }
        if (!event.hasFlag("fix")) {
            return;
        }
        LWC lwc = event.getLWC();
        LWCPlayer player = lwc.wrapPlayer(event.getSender());
        Action action = new Action();
        action.setName("fix");
        action.setPlayer(player);
        player.addAction(action);
        lwc.sendLocale(player, "lwc.fix.clickblock", new Object[0]);
        event.setCancelled(true);
    }
}

