/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.economy;

import com.griefcraft.integration.ICurrency;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.History;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.util.config.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.InventoryHolder;

public class EconomyModule
extends JavaModule {
    private final Map<String, String> cache = new HashMap<String, String>();
    private Logger logger = Logger.getLogger("LWC");
    private Configuration configuration = Configuration.load("economy.yml");
    private Map<Location, String> priceCache = Collections.synchronizedMap(new HashMap());

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT || !event.canAccess()) {
            return;
        }
        if (!this.configuration.getBoolean("Economy.enabled", true)) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        if (!lwc.getCurrency().isActive()) {
            return;
        }
        if (!(protection.getBlock().getState() instanceof InventoryHolder)) {
            return;
        }
        if (event.getEvent().getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        double usageFee = this.resolveDouble(player, "usageFee", false);
        if (usageFee <= 0.0) {
            return;
        }
        if (!lwc.getCurrency().canAfford(player, usageFee)) {
            player.sendMessage("\u00a74You need " + lwc.getCurrency().format(usageFee) + " to open your protection!");
            event.setResult(Module.Result.CANCEL);
            return;
        }
        lwc.getCurrency().removeMoney(player, usageFee);
        player.sendMessage("\u00a72You have been charged " + lwc.getCurrency().format(usageFee) + " to open your protection.");
    }

    @Override
    public void onDestroyProtection(LWCProtectionDestroyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.configuration.getBoolean("Economy.enabled", true)) {
            return;
        }
        if (!this.configuration.getBoolean("Economy.refunds", true)) {
            return;
        }
        if (!LWC.getInstance().isHistoryEnabled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        if (!lwc.getCurrency().isActive()) {
            return;
        }
        if (!lwc.getCurrency().usingCentralBank()) {
            return;
        }
        List<History> transactions = protection.getRelatedHistory(History.Type.TRANSACTION);
        for (History history : transactions) {
            double charge;
            if (history.getStatus() == History.Status.INACTIVE || (charge = history.getDouble("charge")) <= 0.0 || lwc.getCurrency().canCentralBankAfford(charge)) continue;
            player.sendMessage("\u00a74The Server's Bank does not contain enough funds to remove that protection!");
            event.setCancelled(true);
            return;
        }
    }

    @Override
    public void onPostRegistration(LWCProtectionRegistrationPostEvent event) {
        if (!this.configuration.getBoolean("Economy.enabled", true)) {
            return;
        }
        if (!LWC.getInstance().isHistoryEnabled()) {
            return;
        }
        Protection protection = event.getProtection();
        Block block = protection.getBlock();
        if (block == null || !this.priceCache.containsKey(block.getLocation())) {
            return;
        }
        Location location = block.getLocation();
        String cachedPrice = this.priceCache.get(location);
        boolean usedDiscount = cachedPrice.startsWith("d");
        double charge = Double.parseDouble(usedDiscount ? cachedPrice.substring(1) : cachedPrice);
        List<History> transactions = protection.getRelatedHistory(History.Type.TRANSACTION);
        if (transactions.size() == 0) {
            this.logger.severe("LWC-Economy POST_REGISTRATION encountered a severe problem!: transactions.size() == 0");
        }
        History history = transactions.get(transactions.size() - 1);
        history.addMetaData("charge=" + charge);
        if (usedDiscount) {
            history.addMetaData("discount=true");
            String discountId = this.resolveValue(protection.getBukkitOwner(), "discount.id");
            if (!discountId.isEmpty()) {
                history.addMetaData("discountId=" + discountId);
            }
        }
        history.saveNow();
        this.priceCache.remove(location);
    }

    @Override
    public void onPostRemoval(LWCProtectionRemovePostEvent event) {
        if (!this.configuration.getBoolean("Economy.enabled", true)) {
            return;
        }
        if (!this.configuration.getBoolean("Economy.refunds", true)) {
            return;
        }
        if (!LWC.getInstance().isHistoryEnabled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        if (!lwc.getCurrency().isActive()) {
            return;
        }
        List<History> transactions = protection.getRelatedHistory(History.Type.TRANSACTION);
        for (History history : transactions) {
            Player owner;
            double charge;
            if (history.getStatus() == History.Status.INACTIVE || (charge = history.getDouble("charge")) <= 0.0 || (owner = Bukkit.getServer().getPlayer(history.getPlayer())) == null) continue;
            ICurrency currency = lwc.getCurrency();
            currency.addMoney(owner, charge);
            owner.sendMessage("\u00a72You have been refunded " + currency.format(charge) + " because an LWC protection of yours was removed!");
        }
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.configuration.getBoolean("Economy.enabled", true)) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        ICurrency currency = lwc.getCurrency();
        if (!currency.isActive()) {
            return;
        }
        boolean usedDiscount = false;
        double charge = 0.0;
        String value = lwc.resolveProtectionConfiguration(block, "charge");
        if (value != null) {
            try {
                charge = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            charge = this.resolveDouble(player, "charge", false);
        }
        try {
            boolean isDiscountActive = Boolean.parseBoolean(this.resolveValue(player, "discount.active"));
            if (isDiscountActive) {
                int discountedProtections = this.resolveInt(player, "discount.amount", true);
                double discountPrice = this.resolveDouble(player, "discount.newCharge", false);
                if (discountedProtections > 0) {
                    int currentProtections = 0;
                    DiscountType discountType = DiscountType.valueOf(this.resolveValue(player, "discount.type").toUpperCase());
                    String discountId = this.resolveValue(player, "discount.id");
                    switch (discountType) {
                        case EXACT: {
                            currentProtections = this.countDiscountedProtections(lwc, player, discountPrice, discountId.isEmpty() ? null : discountId, false);
                            break;
                        }
                        case TOTAL: {
                            currentProtections = lwc.getPhysicalDatabase().getProtectionCount(player.getName());
                            break;
                        }
                        case IN_USE: {
                            currentProtections = this.countDiscountedProtections(lwc, player, discountPrice, discountId.isEmpty() ? null : discountId, true);
                        }
                    }
                    if (discountedProtections > currentProtections) {
                        charge = discountPrice;
                        usedDiscount = true;
                    }
                }
            }
        }
        catch (NumberFormatException isDiscountActive) {
            // empty catch block
        }
        Location location = block.getLocation();
        if (lwc.isHistoryEnabled()) {
            this.priceCache.put(location, (usedDiscount ? "d" : "") + charge);
        }
        if (charge == 0.0) {
            player.sendMessage("\u00a72This one's on us!");
        } else {
            if (!currency.canAfford(player, charge)) {
                player.sendMessage("\u00a74You do not have enough " + currency.getMoneyName() + " to buy an LWC protection.");
                player.sendMessage("\u00a74The balance required for an LWC protection is: " + currency.format(charge));
                this.priceCache.remove(location);
                event.setCancelled(true);
                return;
            }
            currency.removeMoney(player, charge);
            player.sendMessage("\u00a72Charged " + currency.format(charge) + (usedDiscount ? "\u00a74 (Discount)\u00a72" : "") + " for an LWC protection. Thank you.");
        }
    }

    private int resolveInt(Player player, String node, boolean sortHighest) {
        return (int)this.resolveDouble(player, node, sortHighest);
    }

    private double resolveDouble(Player player, String node, boolean sortHighest) {
        LWC lwc = LWC.getInstance();
        double value = -1.0;
        String cacheKey = "resolve-" + player.getName() + node;
        if (this.cache.containsKey(cacheKey)) {
            return Double.parseDouble(this.cache.get(cacheKey));
        }
        try {
            value = Double.parseDouble(this.configuration.getString("players." + player.getName() + "." + node, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == -1.0) {
            for (String groupName : lwc.getPermissions().getGroups(player)) {
                if (groupName == null || groupName.isEmpty()) continue;
                try {
                    double v = Double.parseDouble(this.map("groups." + groupName + "." + node, "-1"));
                    if (v == -1.0 || (!sortHighest || !(v > value) && value != -1.0) && (sortHighest || !(v < value) && value != -1.0)) continue;
                    value = v;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (value == -1.0) {
            try {
                value = Double.parseDouble(this.map("Economy." + node, "-1"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.cache.put(cacheKey, Double.toString(value));
        return value;
    }

    private String resolveValue(Player player, String node) {
        LWC lwc = LWC.getInstance();
        String value = this.configuration.getString("players." + player.getName() + "." + node, null);
        if (value == null) {
            for (String groupName : lwc.getPermissions().getGroups(player)) {
                if (groupName == null || groupName.isEmpty() || value != null) continue;
                value = this.map("groups." + groupName + "." + node, null);
            }
        }
        if (value == null) {
            value = this.map("Economy." + node, null);
        }
        return value != null && !value.isEmpty() ? value : "";
    }

    private String map(String path, String defaultValue) {
        String value = this.configuration.getString(path, defaultValue);
        if (value == null) {
            int lastIndex = path.lastIndexOf(".");
            String node = path.substring(lastIndex + 1);
            value = this.configuration.getString("Economy." + node);
        }
        return value;
    }

    private int countDiscountedProtections(LWC lwc, Player player, double discountPrice, String discountId, boolean onlyCountActiveTransactions) {
        LWCPlayer lwcPlayer = lwc.wrapPlayer((CommandSender)player);
        List<History> related = lwcPlayer.getRelatedHistory(History.Type.TRANSACTION);
        int amount = 0;
        for (History history : related) {
            double charge;
            if (!history.getBoolean("discount") || discountId != null && (!history.hasKey("discountId") || !history.getString("discountId").equals(discountId)) || onlyCountActiveTransactions && history.getStatus() == History.Status.INACTIVE || (charge = history.getDouble("charge")) != discountPrice) continue;
            ++amount;
        }
        return amount;
    }

    public static enum DiscountType {
        TOTAL,
        EXACT,
        IN_USE;

    }
}

