/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.doors;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.config.Configuration;
import com.griefcraft.util.matchers.DoorMatcher;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DoorsModule
extends JavaModule {
    private static final int TICKS_PER_SECOND = 20;
    private final Configuration configuration = Configuration.load("doors.yml");
    private LWC lwc;
    private Action action = Action.TOGGLE;

    @Override
    public void load(LWC lwc) {
        this.lwc = lwc;
        this.loadAction();
    }

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        Protection other;
        if (event.getResult() == Module.Result.CANCEL || !this.isEnabled()) {
            return;
        }
        if (!event.canAccess()) {
            return;
        }
        Protection protection = event.getProtection();
        Block block = event.getEvent().getClickedBlock();
        Player player = event.getPlayer();
        if (!this.isValid(block.getType())) {
            return;
        }
        boolean doubleDoors = this.usingDoubleDoors();
        Block doubleDoorBlock = null;
        if (doubleDoors && (doubleDoorBlock = this.getDoubleDoor(block)) != null && !this.lwc.canAccessProtection(player, other = this.lwc.findProtection(doubleDoorBlock.getLocation()))) {
            doubleDoorBlock = null;
        }
        boolean opensWhenClicked = DoorMatcher.WOODEN_DOORS.contains(block.getType()) || DoorMatcher.WOODEN_FENCE_GATES.contains(block.getType()) || DoorMatcher.WOODEN_TRAP_DOORS.contains(block.getType());
        this.changeDoorStates(true, opensWhenClicked ? null : block, doubleDoorBlock);
        if (this.action == Action.OPEN_AND_CLOSE || protection.hasFlag(Flag.Type.AUTOCLOSE)) {
            final Block finalBlock = block;
            final Block finalDoubleDoorBlock = doubleDoorBlock;
            int wait = this.getAutoCloseInterval() * 20;
            this.lwc.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.lwc.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    DoorsModule.this.changeDoorStates(false, new Block[]{finalBlock, finalDoubleDoorBlock});
                }
            }, (long)wait);
        }
    }

    private void changeDoorStates(boolean allowDoorToOpen, Block ... doors) {
        block9: for (Block door : doors) {
            if (door == null) continue;
            Openable doorBlockData = null;
            try {
                doorBlockData = (Openable)door.getBlockData();
            }
            catch (ClassCastException e) {
                continue;
            }
            boolean doorIsOpen = doorBlockData.isOpen();
            if (!allowDoorToOpen && !doorIsOpen) continue;
            doorBlockData.setOpen(!doorIsOpen);
            door.setBlockData((BlockData)doorBlockData);
            switch (door.getType()) {
                case OAK_DOOR: 
                case SPRUCE_DOOR: 
                case BIRCH_DOOR: 
                case JUNGLE_DOOR: 
                case ACACIA_DOOR: 
                case DARK_OAK_DOOR: {
                    door.getWorld().playEffect(door.getLocation(), doorIsOpen ? Effect.DOOR_CLOSE : Effect.DOOR_TOGGLE, 0);
                    continue block9;
                }
                case IRON_DOOR: {
                    door.getWorld().playEffect(door.getLocation(), doorIsOpen ? Effect.IRON_DOOR_CLOSE : Effect.IRON_DOOR_TOGGLE, 0);
                    continue block9;
                }
                case OAK_TRAPDOOR: 
                case SPRUCE_TRAPDOOR: 
                case BIRCH_TRAPDOOR: 
                case JUNGLE_TRAPDOOR: 
                case ACACIA_TRAPDOOR: 
                case DARK_OAK_TRAPDOOR: {
                    door.getWorld().playEffect(door.getLocation(), doorIsOpen ? Effect.TRAPDOOR_CLOSE : Effect.TRAPDOOR_TOGGLE, 0);
                    continue block9;
                }
                case IRON_TRAPDOOR: {
                    door.getWorld().playEffect(door.getLocation(), doorIsOpen ? Effect.IRON_TRAPDOOR_CLOSE : Effect.IRON_TRAPDOOR_TOGGLE, 0);
                    continue block9;
                }
                case OAK_FENCE_GATE: 
                case SPRUCE_FENCE_GATE: 
                case BIRCH_FENCE_GATE: 
                case JUNGLE_FENCE_GATE: 
                case ACACIA_FENCE_GATE: 
                case DARK_OAK_FENCE_GATE: {
                    door.getWorld().playEffect(door.getLocation(), doorIsOpen ? Effect.FENCE_GATE_CLOSE : Effect.FENCE_GATE_TOGGLE, 0);
                    continue block9;
                }
            }
        }
    }

    private Block getDoubleDoor(Block block) {
        if (!this.isValid(block.getType())) {
            return null;
        }
        for (Material material : DoorMatcher.PROTECTABLES_DOORS) {
            Block found = this.lwc.findAdjacentBlock(block, material, new Block[0]);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.configuration.getBoolean("doors.enabled", true);
    }

    private boolean isValid(Material material) {
        return DoorMatcher.PROTECTABLES_DOORS.contains(material) || DoorMatcher.FENCE_GATES.contains(material) || DoorMatcher.TRAP_DOORS.contains(material);
    }

    private int getAutoCloseInterval() {
        return this.configuration.getInt("doors.interval", 3);
    }

    private boolean usingDoubleDoors() {
        return this.configuration.getBoolean("doors.doubleDoors", true);
    }

    private void loadAction() {
        String strAction = this.configuration.getString("doors.action");
        this.action = strAction.equalsIgnoreCase("openAndClose") ? Action.OPEN_AND_CLOSE : Action.TOGGLE;
    }

    private static enum Action {
        OPEN_AND_CLOSE,
        TOGGLE;

    }
}

