/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.destroy;

import com.griefcraft.cache.BlockCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.History;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DestroyModule
extends JavaModule {
    @Override
    public void onDestroyProtection(LWCProtectionDestroyEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getMethod() != LWCProtectionDestroyEvent.Method.BLOCK_DESTRUCTION && event.getMethod() != LWCProtectionDestroyEvent.Method.ENTITY_DESTRUCTION) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        boolean isOwner = protection.isOwner(player = event.getPlayer());
        if (isOwner) {
            if (!lwc.isAdmin(player) && Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "readonly-remove"))) {
                lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
                event.setCancelled(true);
                return;
            }
            for (History history : protection.getRelatedHistory(History.Type.TRANSACTION)) {
                if (history.getStatus() != History.Status.ACTIVE) continue;
                history.addMetaData("destroyer=" + player.getName());
                history.addMetaData("destroyerTime=" + System.currentTimeMillis() / 1000L);
            }
            protection.remove();
            if (!Boolean.parseBoolean(lwc.resolveProtectionConfiguration(protection.getBlock(), "quiet"))) {
                BlockCache blockCache = BlockCache.getInstance();
                lwc.sendLocaleToActionBar((CommandSender)player, "protection.unregistered", "block", LWC.materialToString(blockCache.getBlockType(protection.getBlockId())));
            }
            return;
        }
        event.setCancelled(true);
    }
}

