/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.admin;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.PhysDB;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class AdminCleanup
extends JavaModule {
    private static int BATCH_SIZE = 250;

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("a", "admin")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        if (!args[0].equals("cleanup")) {
            return;
        }
        event.setCancelled(true);
        boolean silent = false;
        if (args.length > 1 && args[1].equalsIgnoreCase("silent")) {
            silent = true;
        }
        lwc.sendLocale(sender, "protection.admin.cleanup.start", "count", lwc.getPhysicalDatabase().getProtectionCount());
        new Thread(new Admin_Cleanup_Thread(lwc, sender, silent)).start();
    }

    private static class Admin_Cleanup_Thread
    implements Runnable {
        private LWC lwc;
        private CommandSender sender;
        private boolean silent;

        public Admin_Cleanup_Thread(LWC lwc, CommandSender sender, boolean silent) {
            this.lwc = lwc;
            this.sender = sender;
            this.silent = silent;
        }

        public void push(List<Integer> toRemove) throws SQLException {
            StringBuilder builder = new StringBuilder();
            int total = toRemove.size();
            int count = 0;
            Iterator<Integer> iter = toRemove.iterator();
            String prefix = this.lwc.getPhysicalDatabase().getPrefix();
            Statement statement = this.lwc.getPhysicalDatabase().getConnection().createStatement();
            while (iter.hasNext()) {
                int protectionId = iter.next();
                if (count % 100000 == 0) {
                    builder.append("DELETE FROM ").append(prefix).append("protections WHERE id IN (").append(protectionId);
                } else {
                    builder.append(",").append(protectionId);
                }
                if (count % 100000 == 99999 || count == total - 1) {
                    builder.append(")");
                    statement.executeUpdate(builder.toString());
                    builder.setLength(0);
                    this.sender.sendMessage("\u00a72REMOVED " + (count + 1) + " / " + total);
                }
                ++count;
            }
            statement.close();
        }

        @Override
        public void run() {
            LinkedList<Integer> toRemove = new LinkedList<Integer>();
            int removed = 0;
            int percentChecked = 0;
            BukkitScheduler scheduler = Bukkit.getScheduler();
            try {
                this.sender.sendMessage("\u00a74Processing cleanup request now in a separate thread");
                final ArrayList<Protection> protections = new ArrayList<Protection>(BATCH_SIZE);
                int totalProtections = this.lwc.getPhysicalDatabase().getProtectionCount();
                PhysDB database = new PhysDB();
                database.connect();
                database.load();
                Statement resultStatement = database.getConnection().createStatement(1003, 1007);
                if (this.lwc.getPhysicalDatabase().getType() == Database.Type.MySQL) {
                    resultStatement.setFetchSize(Integer.MIN_VALUE);
                }
                String prefix = this.lwc.getPhysicalDatabase().getPrefix();
                ResultSet result = resultStatement.executeQuery("SELECT id, owner, type, x, y, z, data, blockId, world, password, date, last_accessed FROM " + prefix + "protections");
                int checked = 0;
                while (result.next()) {
                    Protection tprotection = database.resolveProtection(result);
                    if (protections.size() != BATCH_SIZE) {
                        protections.add(tprotection);
                        if (protections.size() != totalProtections) continue;
                    }
                    Future getBlocks = scheduler.callSyncMethod((Plugin)this.lwc.getPlugin(), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            for (Protection protection : protections) {
                                protection.getBlock();
                            }
                            return null;
                        }
                    });
                    getBlocks.get();
                    for (final Protection protection : protections) {
                        block14: {
                            if (protection.getBlockId() == 5000) {
                                int fakeId = 5000;
                                Future entityExists = scheduler.callSyncMethod((Plugin)this.lwc.getPlugin(), (Callable)new Callable<Boolean>(){

                                    @Override
                                    public Boolean call() throws Exception {
                                        if (protection.getBukkitWorld() == null) {
                                            return false;
                                        }
                                        for (Entity entity : protection.getBukkitWorld().getEntities()) {
                                            if (entity.getUniqueId().hashCode() != 5000) continue;
                                            return true;
                                        }
                                        return false;
                                    }
                                });
                                try {
                                    boolean exists = (Boolean)entityExists.get();
                                    if (exists) break block14;
                                    toRemove.add(protection.getId());
                                    ++removed;
                                    if (!this.silent) {
                                        this.lwc.sendLocale(this.sender, "protection.admin.cleanup.removednoexist", "protection", protection.toString());
                                    }
                                }
                                catch (InterruptedException e) {
                                    this.lwc.log("Exception caught during cleanup: " + e.getMessage());
                                }
                            } else {
                                Block block = protection.getBlock();
                                if (block == null || !this.lwc.isProtectable(block)) {
                                    toRemove.add(protection.getId());
                                    ++removed;
                                    if (!this.silent) {
                                        this.lwc.sendLocale(this.sender, "protection.admin.cleanup.removednoexist", "protection", protection.toString());
                                    }
                                }
                            }
                        }
                        ++checked;
                    }
                    int percent = (int)((double)checked / (double)totalProtections * 100.0);
                    if (percent % 5 == 0 && percentChecked != percent) {
                        percentChecked = percent;
                        this.sender.sendMessage("\u00a74Cleanup @ " + percent + "% [ " + checked + "/" + totalProtections + " protections ] [ removed " + removed + " protections ]");
                    }
                    protections.clear();
                }
                result.close();
                resultStatement.close();
                this.push(toRemove);
                this.sender.sendMessage("Cleanup completed. Removed " + removed + " protections out of " + checked + " checked protections.");
            }
            catch (Exception e) {
                this.lwc.log("Exception caught during cleanup: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

